#ifndef __MESH__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "defines.hpp"
#include "polygfx.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

extern int   HALF_SCREEN_WIDTH;
extern int   HALF_SCREEN_HEIGHT;
extern float HALF_SCREEN_WIDTH_VD;
extern float HALF_SCREEN_HEIGHT_VD;
extern int   YON_Z;
extern int   HITHER_Z;

extern void Error(char *fmt, ...);

const int CENTER    = 0;             // just some define statements.
const int VERTICES  = 1;

typedef float MATRIX[4][4];

struct tempstruct {     // used for calculating avgnormals for polygons.
  int p0,p1,p2;         // and other stuff!
};

typedef struct _3dpointyp {
    float x,y,z;
    float morphx,morphy,morphz;
    float morphdx,morphdy,morphdz;      // used for morphing.
    int u,v;
    int Intensity;       // for Gouraud(Phong) Shading.
    int valid;         // if this point is valid. (used for Morphing.)
} POINT3D;

class POLYGONCLASS {

 friend class FILESYSTEMCLASS;
    
 public:

    #define MAX_VERTEX 3

    POINT3D   *Vertex[MAX_VERTEX];    // holds the vertices of object, pointer to actual camera coords in main object.
    POINT3D   *AvgNormal[MAX_VERTEX]; // holds pointer to avgnormal point in camera coords.
    POINT3D    Normal;                // holds normal for this frame. (used for shadow mapping.)
    POINT3D    shadow[MAX_VERTEX];    // holds info for shadow.
    
    float      Normalength;           // length of the normal.
    float      avgz;                  // holds precomputed avg z for depth sort.
    int        u0,v0,u1,v1,u2,v2;     // holds the uv coords for polygon.
    int        color;                 // holds the color of the polygon.
    int        visible;               // is polygon visible?
    int        shadowcolor;           // holds the shadow color.
    int        shadowvisible;         // is shadow visible?
    unsigned char *texture;           // pointer to texture for this polygon.

    POLYGONCLASS(void);
    ~POLYGONCLASS(void);
};

int PolyCompare(const void **arg1, const void **arg2);  // compare function for qsort.
void ComputeAvgZ(void);

class LIGHTCLASS {
    private:
      POINT3D lightsource;           // light vector.
      POINT3D infinitelightsource;

    public:
      LIGHTCLASS(void);
      ~LIGHTCLASS(void);

      SetLight(float x, float y, float z);
      POINT3D *GetLight(void);      
      POINT3D *GetInfiniteLight(void);
};

class CAMERACLASS {
    private:
      POINT3D viewpoint;
      int angx,angy,angz;

    public:
      CAMERACLASS(void);
      ~CAMERACLASS(void);

      void SetViewPoint(float viewx,float viewy,float viewz);
      void MoveViewPoint(float viewx,float viewy,float viewz);
      void SetViewAngle(int angle_x,int angle_y,int angle_z);
      void MoveViewAngle(int angle_x,int angle_y,int angle_z);
      POINT3D *GetViewPoint(void);
      void CreateCameraMatrix(MATRIX CameraMatrix);
};

class OBJECTCLASS {

 friend class FILESYSTEMCLASS;

 public:
    char  name[20];                // name of object.
    int   ObjectID;                // id of object.
    int   numpoly;                 // how many polys make up object.
    int   numvertices;             // how many vertices make up object.
   
    float worldx,worldy,worldz;    // position of object in world.
    float maxz;
    float radius;                  // radius of object.
    float xsphere,ysphere,zsphere; // center coords, in camera space.
    float morphsteps;              // num of steps to morph this object in.

    POINT3D      *LocalCoord;
    POINT3D      *CameraCoord;

    POLYGONCLASS *Polygon;
    OBJECTCLASS  *NextObject;
    OBJECTCLASS  *MorphSource;         // source object to start next morphing.
    OBJECTCLASS  *NextMorphObject;     // circular list.    
    OBJECTCLASS(void);
    ~OBJECTCLASS(void);

    void PolyCull(int Mode);
    void TransformObject(MATRIX TSR_Matrix);
    void Local2Camera(MATRIX CameraMatrix, int Mode);
    OBJECTCLASS *CreateMorphData(void);
    OBJECTCLASS *GetMorphObject(void);
    void HSR_Shade(POINT3D *viewpoint, POINT3D *lightsource);
    void DoShadows(POINT3D *lightsource);
    void GetCenterStats(float *radius, float *xsphere, float *ysphere, float *zsphere);
    void ComputeNormalength(int vertex0, int vertex1, int vertex2,POLYGONCLASS *ThisPolygon);
    void PreComputeNormal(int vertex0, int vertex1, int vertex2,int index);
    void PreComputeAvgNormal(struct tempstruct *polystats);
    void ComputeRadius(void);
    void FindCenter(void);
};

class MESHCLASS {

 friend class FILESYSTEMCLASS;

    public:

      int MAX_LIGHTS;
      int MAX_CAMERAS;
      int velangx,velangy,velangz;       // the velocity of rotation angles.
      int angx,angy,angz;                // angles to rotate object.
      int tx,ty,tz;                      // translation vectors.
      int translevel;                    // level of transparency.
      int totalfaces;                    // used to allocate MeshList.

      int   _CURRENTCAMERA_;             // default camera.
      
      MATRIX CameraMatrix;
      MATRIX TSR_Matrix;

      OBJECTCLASS *ObjectHead;
      LIGHTCLASS  *Light;
      CAMERACLASS *Camera;

      MESHCLASS(void);
     ~MESHCLASS(void);

      int MaxTransLevel;                 // how many transparency levels.

      void  CreateMeshList(void);
      void  ResetOrigin(void);
      void  SetTransparencyLevel(int delta);
      void  SetMaxTransparency(int Levels);
      void  SetShading(int Shade);
      void  SetTextureMapping(int mode);
      void  SetMorph(int mode);
      void  SetShadow(int mode);
      void  SetHazing(int mode);
      void  SetTransparency(int mode);
      void  SetCurrentCamera(int camera);
      void  MoveCamera(int angle_x,int angle_y,int angle_z,float viewx,float viewy,float viewz);
      void  SetTSRVectors(int angle_x,int angle_y,int angle_z,int transx,int transy,int transz);
      void  ResetTSRVectors(void);
      void  CreateTSR_Matrix(void);
      int   SetWorldXYZ(int ObjectID,float wx,float wy,float wz);
      void  ObjectCull(int Mode);
      void  Push(OBJECTCLASS *ThisObject, int Status);
      void  _3DPipeLine(void);
      void  DepthSort(void);
      void  Render(void);
};

  void  MakeVector(POINT3D *init, POINT3D *term, POINT3D *vector);
  void  CrossProduct(POINT3D *u, POINT3D *v, POINT3D *normal);
  float Magnitude(POINT3D *vector);
  void  Normalize(POINT3D *vector);
  float DotProduct(POINT3D *u, POINT3D *v);
  void  CopyPoint3D(POINT3D *source, POINT3D *dest);
  void  BenchMark(int type);

#define __MESH__
#endif

