#ifndef __POLYGFX__
#include "defines.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

extern void Error(char *fmt, ...);

extern "C" {

extern long           _X1,_Y1,_Z1,_X2,_Y2,_Z2,_X3,_Y3,_Z3; // Globals for Drawing polygons ( Assembly access ). Defined in World.hpp
extern long           _I1,_I2,_I3;
extern long           _A1,_A2,_A3;
extern long           _U1,_V1,_U2,_V2,_U3,_V3;
extern long           _MinClipX,_MinClipY,_MaxClipX,_MaxClipY;
extern long           _TransLevel;
extern long           _ColorIndex;
extern long           _AvgZ;
extern unsigned char *_RendBuffer;

void Line(unsigned char *Buffer,unsigned char color, int count);
#pragma aux Line parm [edi] [eax] [ecx]\
	    modify [edi eax ecx];

void Scan_Convert_Lambert(void);
void Scan_Convert_Gouraud(void);

}

extern unsigned char *LookPal;             // Look up Palette and Texture map.
extern unsigned char *LookPalPhong;        // phong illumination palette.

extern unsigned char *TransTBL;
extern unsigned char *HazeTBL;
extern int           *PhongTBL;             // holds angular intensities.
extern int           *TextureMap;

extern int   SCREENWIDTH;
extern int   SCREENHEIGHT;

extern int   POLY_MIN_CLIP_X;
extern int   POLY_MIN_CLIP_Y;
extern int   POLY_MAX_CLIP_X;
extern int   POLY_MAX_CLIP_Y;

int FindCode(int x, int y);          // used for clipping.

void BresenHamLine(int x1,int y1,int x2,int y2,unsigned char color,
                   unsigned char *Buffer);

void Scan_Convert_Wire(void);

//void Scan_Convert_Lambert(void);            // in assembly module, polylow.asm
//void Scan_Convert_Gouraud(void);
void Scan_Convert_Phong(void);

void Scan_Convert_TextureL(void);
void Scan_Convert_TextureG(void);
void Scan_Convert_TextureP(void);

void Scan_Convert_LambertT(void);
void Scan_Convert_GouraudT(void);
void Scan_Convert_PhongT(void);

void Scan_Convert_TextureLT(void);			    
void Scan_Convert_TextureGT(void);
void Scan_Convert_TexturePT(void);

void Scan_Convert_LambertH(void);
void Scan_Convert_GouraudH(void);
void Scan_Convert_PhongH(void);

void Scan_Convert_TextureLH(void);
void Scan_Convert_TextureGH(void);
void Scan_Convert_TexturePH(void);

#define __POLYGFX__
#endif
