#ifndef __VIDEO__

#include <i86.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include "defines.hpp"
#include "timer.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

extern void Error(char *fmt, ...);

extern "C" {

extern long _ScreenWidth,_MinClipX,_MaxClipX,_MinClipY,_MaxClipY;       // defined in polylow.asm
extern unsigned char *_LookPAL, *_RendBuffer;

}

typedef struct imagestats_typ {
    int width,height;
    int size;
} ImageStats;

class VIDEOCLASS {
    
  private:
    unsigned char *VidMem;

    #define COLOR_MASK        0x3C6 // the bit mask register
    #define COLOR_REGISTER_RD 0x3C7 // set read index at this I/O
    #define COLOR_REGISTER_WR 0x3C8 // set write index at this I/O
    #define COLOR_DATA        0x3C9 // the R/W data is here

    enum {NORMAL,RLE};
    enum {PCX_OK,PCX_NOMEM,PCX_TOOBIG,PCX_NOFILE};

    typedef struct
    {
      char manufacturer;    // Always set to 0
      char version;         // Always 5 for 256-color files
      char encoding;        // Always set to 1 
      char bits_per_pixel;  // Should be 8 for 256-color files 
      short int xmin,ymin;       // Coordinates for top left corner 
      short int xmax,ymax;       // Width and height of image 
      short int hres;            // Horizontal resolution of image 
      short int vres;            // Vertical resolution of image 
      unsigned char palette16[48];   // EGA palette; not used for 256-color files
      char reserved;        // Reserved for future use 
      char color_planes;    // Color planes
      short int bytes_per_line;  // Number of bytes in 1 line of pixels 
      short int palette_type;    // Should be 2 for color palette 
      char filler[58];      // Nothing but junk 
    } PcxHeader;

    typedef struct
    {
      PcxHeader hdr;
      unsigned char *bitmap;
      unsigned char pal[768];
      short int width,height;
      int imagebytes;
    } PcxFile;

  int prevmode;
  int MEMSIZE;          // size of VidMem for various modes.
  int bgcolor;
  int Shades;           // how many shades of palette.
  
  PcxFile *pcx;
  ImageStats Stats;                      // holds stats of image.

  unsigned long int PcxSize;             // Size of PCX file
  unsigned char CurrentPalette[768];        // holds colors of the currentpalette.
  
  unsigned char *Background;             // holds background picture, if there.
  unsigned char *VideoBuffer;                 // holds double buffer.  

  public:
    VIDEOCLASS(void);
   ~VIDEOCLASS(void);

    void InitVideo(int Mode);
    void LoadBackground(char *filename);
    void DeleteBackground(void);
    unsigned char *LoadPcxFile(char *filename);
    void SetAllRgbPalette(void);
    void SetPaletteArg(unsigned char *pal);
    void CreateRGBPalette(void);
    void LoadTextureMap(char *filename);
    void LoadPalTable(char *filename);
    void LoadPalPhongTable(char *filename);
    void LoadPhongTBL(char *filename);
    int  LoadTransTable(char *filename);
    void LoadHazeTable(char *filename);
    ImageStats *GetStats();
    void ClearBuffer(void);
    unsigned char *GetBuffer(void);
    unsigned char *CreateBuffer(int color);
    void Buf2Video(void);
    void FadeToBlack(void);
    void FadeToColor(void);
    void SetClipExtents(int XMinClip,int YMinClip,int XMaxClip,int YMaxClip,
                        int HitherClip,int YonClip);
};

#define __VIDEO__
#endif

