#ifndef __VOXEL__

#include <stdio.h>
#include <math.h>
#include "defines.hpp"
#include "video.hpp"
#include "input.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

extern void Error(char *fmt, ...);

extern "C" {

extern unsigned char *_Skymap;
extern unsigned char *_Colormap;
extern unsigned char *_ShadowmapPtr;
extern unsigned char *_ShadowPAL;
extern unsigned char *_Buffer;
extern long          *_Heightmap;
extern long           _SKYHEIGHT;
extern long           _SkyHoriz;
extern long           _SkyLimit;
extern long           _LeftCos;
extern long           _RightCos;
extern long           _LeftSin;
extern long           _RightSin;
extern long           _vx;
extern long           _vy;
extern long           _x;
extern long           _y;
extern long           _z;
extern long           _dx;
extern long           _dy;
extern long           _dz;
extern long           _col;
extern long           _kVScale;

void RenderSkyLine(void);
void CastRay(void);
			
long GetOffset(long u,long v);
#pragma aux GetOffset parm [ecx] [edx]\
            modify [edi edx]\
            value [ebx];

long GetOffset2(long u,long v);
#pragma aux GetOffset2 parm [ecx] [edx]\
            modify [edi edx]\
            value [ebx];
}

extern int SCREENHEIGHT;
extern int SCREENWIDTH;

const float ANGULAR_INCREMENT  = 0.17578;      

class VOXELCLASS {

  friend class FILESYSTEMCLASS;

  private:
  
  #define ANGLE_MASK 0x7FF           // mask out upper bits, modulus.
  #define ANGLE_360 0x800            // 2048 angular increments.
  #define ANGLE_180 ANGLE_360/2
  #define ANGLE_90  ANGLE_180/2
  #define ANGLE_60  ANGLE_360/6
  #define ANGLE_45  ANGLE_90/2
  #define ANGLE_30  ANGLE_360/12
  #define ANGLE_15  ANGLE_30/2
  #define ANGLE_5   ANGLE_30/6
  #define ANGLE_0   0

  #define KVSCALE 0x600              // quick way to inc/dec size of mountains.

  #define VIEWDISTANCE (250<<8)      // View Distance in 24:8 format.

  #define YAWACCEL ANGLE_5
  #define MAXALTITUDE (600<<16)
  #define MINALTITUDE (10<<16)

  #define DEFAULTPITCH 120           // 200-80.
  #define DEFAULTSPEED 2048          // fixed 16:16
  #define PITCHSPEED 4
  #define SKYHEIGHT 60*VIEWDISTANCE  // put together so we don't have to mult later.
  #define VIEWSPEED 8

  long  COS[ANGLE_360],
        SIN[ANGLE_360];

  unsigned char *ShadowLeft,*ShadowCenter,*ShadowRight;

  long Yaw,Altitude,Pitch,Speed,viewpoint_x,viewpoint_y;

  public:
    VOXELCLASS(void);
    ~VOXELCLASS(void);

    void CreateDataBase(VIDEOCLASS *Video);
    void RenderSky(void);
    void RenderView(unsigned char *DoubleBuffer);
    void HandleInput(INPUTCLASS *Input);
    void CheckCrashed(void);

};

#define __VOXEL__
#endif
