#include "input.hpp"
#include <dos.h>

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

void (_interrupt _far *Old_Isr)(void);
void _interrupt _far New_Key_Int(void);

short raw_key;                   // scan codes for keyboard.
short key_table[128];
int keys_active=0;

void InitKeyBoard(void)
{
   Old_Isr=_dos_getvect(KEYBOARD_INT);   // save BIOS keyboard interrupt
   _dos_setvect(KEYBOARD_INT,New_Key_Int);   // install new int 9h handler

   memset(key_table,0,128);         
}

void RestoreKeyBoard(void)
{
   _dos_setvect(KEYBOARD_INT,Old_Isr);   // restore BIOS keyboard interrupt
}
	
#pragma aux GetKeyCodes=\
      "sti"\
      "in al,0x60"\
      "xor ah,ah"\
      "mov raw_key,ax"\
      "in al,0x61"\
      "or al,82h"\
      "out 0x61,al"\
      "and al,7fh"\
      "out 0x61,al"\
      "mov al,20h"\
      "out 0x20,al"\
      ;
      
void _interrupt _far New_Key_Int(void)
{
      GetKeyCodes();
	
      switch(raw_key)
	{
	   case MAKE_ESC:
	      key_table[SCAN_ESC]=1;
              keys_active++;
	   break;
	   case MAKE_1:
	      key_table[SCAN_1]=1;
              keys_active++;
	   break;
	   case MAKE_2:
	      key_table[SCAN_2]=1;
              keys_active++;
	   break;
	   case MAKE_3:
	      key_table[SCAN_3]=1;
              keys_active++;
	   break;
	   case MAKE_4:
	      key_table[SCAN_4]=1;
              keys_active++;
	   break;
	   case MAKE_5:
	      key_table[SCAN_5]=1;
              keys_active++;
	   break;
	   case MAKE_6:
	      key_table[SCAN_6]=1;
              keys_active++;
	   break;
	   case MAKE_7:
	      key_table[SCAN_7]=1;
              keys_active++;
	   break;
	   case MAKE_8:
	      key_table[SCAN_8]=1;
              keys_active++;
	   break;
	   case MAKE_9:
	      key_table[SCAN_9]=1;
              keys_active++;
	   break;
	   case MAKE_0:
	      key_table[SCAN_0]=1;
              keys_active++;
	   break;
	   case MAKE_MINUS:
	      key_table[SCAN_MINUS]=1;
              keys_active++;
	   break;
	   case MAKE_EQUAL:
	      key_table[SCAN_EQUAL]=1;
              keys_active++;
	   break;
	   case MAKE_BKSP:
	      key_table[SCAN_BKSP]=1;
              keys_active++;
	   break; 
	   case MAKE_TAB:
	      key_table[SCAN_TAB]=1;
              keys_active++;
	   break;
	   case MAKE_Q:
	      key_table[SCAN_Q]=1;
              keys_active++;
	   break;
	   case MAKE_W:
	      key_table[SCAN_W]=1;
              keys_active++;
	   break;
	   case MAKE_E:
	      key_table[SCAN_E]=1;
              keys_active++;
	   break;
	   case MAKE_R:
	      key_table[SCAN_R]=1;
              keys_active++;
	   break;
	   case MAKE_T:
	      key_table[SCAN_T]=1;
              keys_active++;
	   break;
	   case MAKE_Y:
	      key_table[SCAN_Y]=1;
              keys_active++;
	   break;
	   case MAKE_U:
	      key_table[SCAN_U]=1;
              keys_active++;
	   break;
	   case MAKE_I:
	      key_table[SCAN_I]=1;
              keys_active++;
	   break;
	   case MAKE_O:
	      key_table[SCAN_O]=1;
              keys_active++;
	   break;
	   case MAKE_P:
	      key_table[SCAN_P]=1;
              keys_active++;
	   break;
	   case MAKE_LSB:
	      key_table[SCAN_LSB]=1;
              keys_active++;
	   break;
	   case MAKE_RSB:
	      key_table[SCAN_RSB]=1;
              keys_active++;
	   break;
	   case MAKE_ENTER:
	      key_table[SCAN_ENTER]=1;
              keys_active++;
	   break;
	   case MAKE_CTRL:
	      key_table[SCAN_CTRL]=1;
              keys_active++;
	   break;
	   case MAKE_A:
	      key_table[SCAN_A]=1;
              keys_active++;
	   break;
	   case MAKE_S:
	      key_table[SCAN_S]=1;
              keys_active++;
	   break;
	   case MAKE_D:
	      key_table[SCAN_D]=1;
              keys_active++;
	   break;
	   case MAKE_F:
	      key_table[SCAN_F]=1;
              keys_active++;
	   break;
	   case MAKE_G:
	      key_table[SCAN_G]=1;
              keys_active++;
	   break;
	   case MAKE_H:
	      key_table[SCAN_H]=1;
              keys_active++;
	   break;
	   case MAKE_J:
	      key_table[SCAN_J]=1;
              keys_active++;
	   break;
	   case MAKE_K:
	      key_table[SCAN_K]=1;
              keys_active++;
	   break;
	   case MAKE_L:
	      key_table[SCAN_L]=1;
              keys_active++;
	   break;
	   case MAKE_SEMICOLON:
	      key_table[SCAN_SEMICOLON]=1;
              keys_active++;
	   break;
	   case MAKE_APOS:
	      key_table[SCAN_APOS]=1;
              keys_active++;
	   break;
	   case MAKE_TILDE:
	      key_table[SCAN_TILDE]=1;
              keys_active++;
	   break;
	   case MAKE_LEFTSHFT:
	      key_table[SCAN_LEFTSHFT]=1;
              keys_active++;
	   break;
	   case MAKE_BACKSLASH:
	      key_table[SCAN_BACKSLASH]=1;
              keys_active++;
	   break;
	   case MAKE_Z:
	      key_table[SCAN_Z]=1;
              keys_active++;
	   break;
	   case MAKE_X:
	      key_table[SCAN_X]=1;
              keys_active++;
	   break;
	   case MAKE_C:
	      key_table[SCAN_C]=1;
              keys_active++;
	   break;
	   case MAKE_V:
	      key_table[SCAN_V]=1;
              keys_active++;
	   break;
	   case MAKE_B:
	      key_table[SCAN_B]=1;
              keys_active++;
	   break;
	   case MAKE_N:
	      key_table[SCAN_N]=1;
              keys_active++;
	   break;
	   case MAKE_M:
	      key_table[SCAN_M]=1;
              keys_active++;
	   break;
	   case MAKE_COMMA:
	      key_table[SCAN_COMMA]=1;
              keys_active++;
	   break;
	   case MAKE_PERIOD:
	      key_table[SCAN_PERIOD]=1;
              keys_active++;
	   break;
	   case MAKE_SLASH:
	      key_table[SCAN_SLASH]=1;
              keys_active++;
	   break;
	   case MAKE_RIGHTSHFT:
	      key_table[SCAN_RIGHTSHFT]=1;
              keys_active++;
	   break;
	   case MAKE_PRINTSCRN:
	      key_table[SCAN_PRINTSCRN]=1;
              keys_active++;
	   break;
	   case MAKE_ALT:
	      key_table[SCAN_ALT]=1;
              keys_active++;
	   break;
	   case MAKE_SPACE:
	      key_table[SCAN_SPACE]=1;
              keys_active++;
	   break;
	   case MAKE_CAPLOCK:
	      key_table[SCAN_CAPLOCK]=1;
              keys_active++;
	   break;
	   case MAKE_F1:
	      key_table[SCAN_F1]=1;
              keys_active++;
	   break;
	   case MAKE_F2:
	      key_table[SCAN_F2]=1;
              keys_active++;
	   break;
	   case MAKE_F3:
	      key_table[SCAN_F3]=1;
              keys_active++;
	   break;
	   case MAKE_F4:
	      key_table[SCAN_F4]=1;
              keys_active++;
	   break;
	   case MAKE_F5:
	      key_table[SCAN_F5]=1;
              keys_active++;
	   break;
	   case MAKE_F6:
	      key_table[SCAN_F6]=1;
              keys_active++;
	   break;
	   case MAKE_F7:
	      key_table[SCAN_F7]=1;
              keys_active++;
	   break;
	   case MAKE_F8:
	      key_table[SCAN_F8]=1;
              keys_active++;
	   break;
	   case MAKE_F9:
	      key_table[SCAN_F9]=1;
              keys_active++;
	   break;
	   case MAKE_F10:
	      key_table[SCAN_F10]=1;
              keys_active++;
	   break;
	   case MAKE_NUMLOCK:
	      key_table[SCAN_NUMLOCK]=1;
              keys_active++;
	   break;
	   case MAKE_SCROLLOCK:
	      key_table[SCAN_SCROLLOCK]=1;
              keys_active++;
	   break;
	   case MAKE_HOME:
	      key_table[SCAN_HOME]=1;
              keys_active++;
	   break;
	   case MAKE_UP:
	      key_table[SCAN_UP]=1; 
              keys_active++;
	   break;
	   case MAKE_PGUP:
	      key_table[SCAN_PGUP]=1;
              keys_active++;
	   break;
	   case MAKE_KEYPADMINUS:
	      key_table[SCAN_KEYPADMINUS]=1;
              keys_active++;
	   break;
	   case MAKE_LEFT:
	      key_table[SCAN_LEFT]=1;
              keys_active++;
	   break;
	   case MAKE_CENTER:
	      key_table[SCAN_CENTER]=1;
              keys_active++;
	   break;
	   case MAKE_RIGHT:
	      key_table[SCAN_RIGHT]=1;
              keys_active++;
	   break;
	   case MAKE_KEYPADPLUS:
	      key_table[SCAN_KEYPADPLUS]=1;
              keys_active++;
	   break;
	   case MAKE_END:
	      key_table[SCAN_END]=1;
              keys_active++;
	   break;
	   case MAKE_DOWN:
	      key_table[SCAN_DOWN]=1;
              keys_active++;
	   break;
	   case MAKE_PGDOWN:
	      key_table[SCAN_PGDOWN]=1;
              keys_active++;
	   break;
	   case MAKE_INSERT:
	      key_table[SCAN_INSERT]=1;
              keys_active++;
	   break;
	   case MAKE_DELETE:
	      key_table[SCAN_DELETE]=1;
              keys_active++;
	   break;
	   case MAKE_F11:
	      key_table[SCAN_F11]=1;
              keys_active++;
	   break;
	   case MAKE_F12:
	      key_table[SCAN_F12]=1;
              keys_active++;
	   break;

	   case BREAK_ESC:
	      key_table[SCAN_ESC]=0;
              keys_active--;
	   break;
	   case BREAK_1:
	      key_table[SCAN_1]=0;
              keys_active--;
	   break;
	   case BREAK_2:
	      key_table[SCAN_2]=0;
              keys_active--;
	   break;
	   case BREAK_3:
	      key_table[SCAN_3]=0;
              keys_active--;
	   break;
	   case BREAK_4:
	      key_table[SCAN_4]=0;
              keys_active--;
	   break;
	   case BREAK_5:
	      key_table[SCAN_5]=0;
              keys_active--;
	   break;
	   case BREAK_6:
	      key_table[SCAN_6]=0;
              keys_active--;
	   break;
	   case BREAK_7:
	      key_table[SCAN_7]=0;
              keys_active--;
	   break;
	   case BREAK_8:
	      key_table[SCAN_8]=0;
              keys_active--;
	   break;
	   case BREAK_9:
	      key_table[SCAN_9]=0;
              keys_active--;
	   break;
	   case BREAK_0:
	      key_table[SCAN_0]=0;
              keys_active--;
	   break;
	   case BREAK_MINUS:
	      key_table[SCAN_MINUS]=0;
              keys_active--;
	   break;
	   case BREAK_EQUAL:
	      key_table[SCAN_EQUAL]=0;
              keys_active--;
	   break;
	   case BREAK_BKSP:
	      key_table[SCAN_BKSP]=0;
              keys_active--;
	   break;
	   case BREAK_TAB:
	      key_table[SCAN_TAB]=0;
              keys_active--;
	   break;
	   case BREAK_Q:
	      key_table[SCAN_Q]=0;
              keys_active--;
	   break;
	   case BREAK_W:
	      key_table[SCAN_W]=0;
              keys_active--;
	   break;
	   case BREAK_E:
	      key_table[SCAN_E]=0;
              keys_active--;
	   break;
	   case BREAK_R:
	      key_table[SCAN_R]=0;
              keys_active--;
	   break;
	   case BREAK_T:
	      key_table[SCAN_T]=0;
              keys_active--;
	   break;
	   case BREAK_Y:
	      key_table[SCAN_Y]=0;
              keys_active--;
	   break;
	   case BREAK_U:
	      key_table[SCAN_U]=0;
              keys_active--;
	   break;
	   case BREAK_I:
	      key_table[SCAN_I]=0;
              keys_active--;
	   break;
	   case BREAK_O:
	      key_table[SCAN_O]=0;
              keys_active--;
	   break;
	   case BREAK_P:
	      key_table[SCAN_P]=0;
              keys_active--;
	   break;
	   case BREAK_LSB:
	      key_table[SCAN_LSB]=0;
              keys_active--;
	   break;
	   case BREAK_RSB:
	      key_table[SCAN_RSB]=0;
              keys_active--;
	   break;
	   case BREAK_ENTER:
	      key_table[SCAN_ENTER]=0;
              keys_active--;
	   break;
	   case BREAK_CTRL:
	      key_table[SCAN_CTRL]=0;
              keys_active--;
	   break;
	   case BREAK_A:
	      key_table[SCAN_A]=0;
              keys_active--;
	   break;
	   case BREAK_S:
	      key_table[SCAN_S]=0;
              keys_active--;
	   break;
	   case BREAK_D:
	      key_table[SCAN_D]=0;
              keys_active--;
	   break;
	   case BREAK_F:
	      key_table[SCAN_F]=0;
              keys_active--;
	   break;
	   case BREAK_G:
	      key_table[SCAN_G]=0;
              keys_active--;
	   break;
	   case BREAK_H:
	      key_table[SCAN_H]=0;
              keys_active--;
	   break;
	   case BREAK_J:
	      key_table[SCAN_J]=0;
              keys_active--;
	   break;
	   case BREAK_K:
	      key_table[SCAN_K]=0;
              keys_active--;
	   break;
	   case BREAK_L:
	      key_table[SCAN_L]=0;
              keys_active--;
	   break;
	   case BREAK_SEMICOLON:
	      key_table[SCAN_SEMICOLON]=0;
              keys_active--;
	   break;
	   case BREAK_APOS:
	      key_table[SCAN_APOS]=0;
              keys_active--;
	   break;
	   case BREAK_TILDE:
	      key_table[SCAN_TILDE]=0;
              keys_active--;
	   break;
	   case BREAK_LEFTSHFT:
	      key_table[SCAN_LEFTSHFT]=0;
              keys_active--;
	   break;
	   case BREAK_BACKSLASH:
	      key_table[SCAN_BACKSLASH]=0;
              keys_active--;
	   break;
	   case BREAK_Z:
	      key_table[SCAN_Z]=0;
              keys_active--;
	   break;
	   case BREAK_X:
	      key_table[SCAN_X]=0;
              keys_active--;
	   break;
	   case BREAK_C:
	      key_table[SCAN_C]=0;
              keys_active--;
	   break;
	   case BREAK_V:
	      key_table[SCAN_V]=0;
              keys_active--;
	   break;
	   case BREAK_B:
	      key_table[SCAN_B]=0;
              keys_active--;
	   break;
	   case BREAK_N:
	      key_table[SCAN_N]=0;
              keys_active--;
	   break;
	   case BREAK_M:
	      key_table[SCAN_M]=0;
              keys_active--;
	   break;
	   case BREAK_COMMA:
	      key_table[SCAN_COMMA]=0;
              keys_active--;
	   break;
	   case BREAK_PERIOD:
	      key_table[SCAN_PERIOD]=0;
              keys_active--;
	   break;
	   case BREAK_SLASH:
	      key_table[SCAN_SLASH]=0;
              keys_active--;
	   break;
	   case BREAK_RIGHTSHFT:
	      key_table[SCAN_RIGHTSHFT]=0;
              keys_active--;
	   break;
	   case BREAK_PRINTSCRN:
	      key_table[SCAN_PRINTSCRN]=0;
              keys_active--;
	   break;
	   case BREAK_ALT:
	      key_table[SCAN_ALT]=0;
              keys_active--;
	   break;
	   case BREAK_SPACE:
	      key_table[SCAN_SPACE]=0;
              keys_active--;
	   break;
	   case BREAK_CAPLOCK:
	      key_table[SCAN_CAPLOCK]=0;
              keys_active--;
	   break;
	   case BREAK_F1:
	      key_table[SCAN_F1]=0;
              keys_active--;
	   break;
	   case BREAK_F2:
	      key_table[SCAN_F2]=0;
              keys_active--;
	   break;
	   case BREAK_F3:
	      key_table[SCAN_F3]=0;
              keys_active--;
	   break;
	   case BREAK_F4:
	      key_table[SCAN_F4]=0;
              keys_active--;
	   break;
	   case BREAK_F5:
	      key_table[SCAN_F5]=0;
              keys_active--;
	   break;
	   case BREAK_F6:
	      key_table[SCAN_F6]=0;
              keys_active--;
	   break;
	   case BREAK_F7:
	      key_table[SCAN_F7]=0;
              keys_active--;
	   break;
	   case BREAK_F8:
	      key_table[SCAN_F8]=0;
              keys_active--;
	   break;
	   case BREAK_F9:
	      key_table[SCAN_F9]=0;
              keys_active--;
	   break;
	   case BREAK_F10:
	      key_table[SCAN_F10]=0;
              keys_active--;
	   break;
	   case BREAK_NUMLOCK:
	      key_table[SCAN_NUMLOCK]=0;
              keys_active--;
	   break;
	   case BREAK_SCROLLOCK:
	      key_table[SCAN_SCROLLOCK]=0;
              keys_active--;
	   break;
	   case BREAK_HOME:
	      key_table[SCAN_HOME]=0;
              keys_active--;
	   break;
	   case BREAK_UP:
	      key_table[SCAN_UP]=0; 
              keys_active--;
	   break;
	   case BREAK_PGUP:
	      key_table[SCAN_PGUP]=0;
              keys_active--;
	   break;
	   case BREAK_KEYPADMINUS:
	      key_table[SCAN_KEYPADMINUS]=0;
              keys_active--;
	   break;
	   case BREAK_LEFT:
	      key_table[SCAN_LEFT]=0;
              keys_active--;
	   break;
	   case BREAK_CENTER:
	      key_table[SCAN_CENTER]=0;
              keys_active--;
	   break;
	   case BREAK_RIGHT:
	      key_table[SCAN_RIGHT]=0;
              keys_active--;
	   break;
	   case BREAK_KEYPADPLUS:
	      key_table[SCAN_KEYPADPLUS]=0;
              keys_active--;
	   break;
	   case BREAK_END:
	      key_table[SCAN_END]=0;
              keys_active--;
	   break;
	   case BREAK_DOWN:
	      key_table[SCAN_DOWN]=0;
              keys_active--;
	   break;
	   case BREAK_PGDOWN:
	      key_table[SCAN_PGDOWN]=0;
              keys_active--;
	   break;
	   case BREAK_INSERT:
	      key_table[SCAN_INSERT]=0;
              keys_active--;
	   break;
	   case BREAK_DELETE:
	      key_table[SCAN_DELETE]=0;
              keys_active--;
	   break;
	   case BREAK_F11:
	      key_table[SCAN_F11]=0;
              keys_active--;
	   break;
	   case BREAK_F12:
	      key_table[SCAN_F12]=0;
              keys_active--;
	   break;
	   default:
	   break;
	}
}

KEYBOARDCLASS::KEYBOARDCLASS(void)
{
  InitKeyBoard();
}

KEYBOARDCLASS::~KEYBOARDCLASS(void)
{
  RestoreKeyBoard();
}

void KEYBOARDCLASS::ClearKeys(void)
{
  memset(key_table,0,128);       // To clear all pending key presses.
  keys_active=0;
}

int KEYBOARDCLASS::Is_Key(const short key)
{
  int result;

   switch (key)
   {
      case SCAN_ANY:
        if (keys_active)
          result = TRUE;
        else
          result = FALSE;
      break;
      case SCAN_ESC:
	if (key_table[SCAN_ESC])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F1:
	if (key_table[SCAN_F1])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F2:
	if (key_table[SCAN_F2])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F3:
	if (key_table[SCAN_F3])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F4:
	if (key_table[SCAN_F4])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F5:
	if (key_table[SCAN_F5])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F6:
	if (key_table[SCAN_F6])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F7:
	if (key_table[SCAN_F7])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F8:
	if (key_table[SCAN_F8])
          result = TRUE;
	else
          result = FALSE;
	   break;
      case SCAN_F9:
	if (key_table[SCAN_F9])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F10:
	if (key_table[SCAN_F10])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F11:
	if (key_table[SCAN_F11])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F12:
	if (key_table[SCAN_F12])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_1:
	if (key_table[SCAN_1])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_2:
	 if (key_table[SCAN_2])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_3:
	if (key_table[SCAN_3])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_4:
	if (key_table[SCAN_4])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_5:
	if (key_table[SCAN_5])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_6:
	if (key_table[SCAN_6])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_7:
	if (key_table[SCAN_7])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_8:
	if (key_table[SCAN_8])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_9:
	if (key_table[SCAN_9])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_0:
	if (key_table[SCAN_0])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_MINUS:
	 if (key_table[SCAN_MINUS])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_EQUAL:
	 if (key_table[SCAN_EQUAL])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_BKSP:
	if (key_table[SCAN_BKSP])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_Q:
	if (key_table[SCAN_Q])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_W:
	if (key_table[SCAN_W])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_E:
	if (key_table[SCAN_E])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_R:
	if (key_table[SCAN_R])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_T:
	if (key_table[SCAN_T])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_Y:
	if (key_table[SCAN_Y])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_U:
	if (key_table[SCAN_U])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_I:
	if (key_table[SCAN_I])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_O:
	if (key_table[SCAN_O])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_P:
	if (key_table[SCAN_P])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_LSB:
	if (key_table[SCAN_LSB])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_RSB:
	if (key_table[SCAN_RSB])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_ENTER:
	if (key_table[SCAN_ENTER])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_A:
	if (key_table[SCAN_A])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_S:
	if (key_table[SCAN_S])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_D:
	if (key_table[SCAN_D])
           result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_F:
	if (key_table[SCAN_F])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_G:
	if (key_table[SCAN_G])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_H:
	if (key_table[SCAN_H])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_J:
	if (key_table[SCAN_J])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_K:
	if (key_table[SCAN_K])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_L:
	if (key_table[SCAN_L])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_SEMICOLON:
	if (key_table[SCAN_SEMICOLON])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_APOS:
	if (key_table[SCAN_APOS])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_Z:
	if (key_table[SCAN_Z])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_X:
	if (key_table[SCAN_X])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_C:
	if (key_table[SCAN_C])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_V:
	if (key_table[SCAN_V])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_B:
	if (key_table[SCAN_B])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_N:
	if (key_table[SCAN_N])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_M:
	if (key_table[SCAN_M])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_COMMA:
	if (key_table[SCAN_COMMA])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_PERIOD:
	if (key_table[SCAN_PERIOD])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_SLASH:
	if (key_table[SCAN_SLASH])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_INSERT:
	if (key_table[SCAN_INSERT])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_DELETE:
	if (key_table[SCAN_DELETE])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_HOME:
	if (key_table[SCAN_HOME])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_END:
	if (key_table[SCAN_END])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_PGUP:
	if (key_table[SCAN_PGUP])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_PGDOWN:
	if (key_table[SCAN_PGDOWN])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_RIGHT:
	if (key_table[SCAN_RIGHT])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_LEFT:
	if (key_table[SCAN_LEFT])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_UP:
	if (key_table[SCAN_UP])
          result = TRUE;
	else
          result = FALSE;
      break;
      case SCAN_DOWN:
	if (key_table[SCAN_DOWN])
          result = TRUE;
	else
          result = FALSE;
      break;
	 
      default:
        result = FALSE;
      break;
   }
  return (result);
}
   
INPUTCLASS::INPUTCLASS(void)               // constructor.
{

}


INPUTCLASS::~INPUTCLASS(void)              // destructor.
{

}

