
;  Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

		.486
		
		ASSUME  CS:_TEXT
		ASSUME  DS:_DATA

                _SCREENWIDTH      EQU 80         ; 320/4         
                _SCREENW          EQU 320  
                _SCREENH          EQU 200 
                _SCREENSIZE       EQU 64000
                _SHADOWSTART      EQU 127        ; for a Shadow of width 64
                _SHADOWEND        EQU 193
				
; export Functions

                PUBLIC GetOffset
                PUBLIC GetOffset2
                PUBLIC RenderSkyLine
                PUBLIC CastRay

; export data
				
                PUBLIC _Skymap
                PUBLIC _Colormap
                PUBLIC _Heightmap
                PUBLIC _ShadowmapPtr
                PUBLIC _ShadowPAL
                PUBLIC _Buffer    
                PUBLIC _SKYHEIGHT
                PUBLIC _SkyHoriz  
                PUBLIC _SkyLimit    
                PUBLIC _LeftCos    
                PUBLIC _LeftSin   
                PUBLIC _RightCos  
                PUBLIC _RightSin    
                PUBLIC _vx
                PUBLIC _vy 
                PUBLIC _x
                PUBLIC _y
                PUBLIC _z
                PUBLIC _dx
                PUBLIC _dy
                PUBLIC _dz
                PUBLIC _col
                PUBLIC _kVScale
		
_DATA           SEGMENT 'DATA' USE32

; Export data		 
                _Skymap         dd 0
                _Colormap       dd 0
                _Heightmap      dd 0
                _ShadowmapPtr   dd 0
                _ShadowPAL      dd 0
                _Buffer         dd 0
                _SKYHEIGHT      dd 0
                _SkyHoriz       dd 0
                _SkyLimit       dd 0
                _LeftCos        dd 0
                _LeftSin        dd 0
                _RightCos       dd 0
                _RightSin       dd 0
                _vx             dd 0
                _vy             dd 0             
                _x              dd 0
                _y              dd 0
                _z              dd 0
                _dx             dd 0
                _dy             dd 0
                _dz             dd 0
                _col            dd 0
                _kVScale        dd 0
		
; Local to module
	
                _Dist           dd 0
                _row            dd 0
                _color          dd 0
                _depth          dd 0
                _pixel          dd 0
                _u0             dd 0
                _v0             dd 0
                _u1             dd 0
                _v1             dd 0
                _Du             dd 0
                _Dv             dd 0
                _shadowoffset   dd 0
                _DEPTHCLIP      dd 0
                _SCANLINELENGTH dd 204   ; 16:16 fixed point
                					
_DATA           ENDS
						
_TEXT           SEGMENT PUBLIC 'CODE' USE32

GetOffset  PROC    NEAR
               mov ebx,edx
               shr ebx,23
               shld ebx,ecx,9
	       cld	
	       ret
GetOffset  ENDP

GetOffset2 PROC    NEAR
               mov ebx,edx
               shr ebx,24
               shld ebx,ecx,8
	       cld	
	       ret
GetOffset2 ENDP

RenderSkyLine PROC NEAR

              push esi
	      push edi
	      push ebp
	      	      
              mov edi,_Buffer                         
              mov esi,_Skymap   
	      
              jmp $+2	           ; clear prefetch queue

              mov _row,0
@@DoSky:	      
              mov eax,_SKYHEIGHT
              mov ebx,_SkyHoriz
              sub ebx,_row
	      cdq
	      div ebx
	      mov ebx,eax         ; save Dist
              mov eax,_LeftCos
	      cdq
              imul ebx
              add eax,_vx             
	      mov ecx,eax         
              mov eax,_RightCos
	      cdq
	      imul ebx
              add eax,_vx
	      sub eax,ecx         ; holds Du
	      sar eax,8           ; get in 24:8 format
              cdq
              imul _SCANLINELENGTH ; normalized to 24:8 format
              mov _Du,eax
              mov eax,_LeftSin
	      cdq
              imul ebx
              add eax,_vy
	      mov ebp,eax
              mov eax,_RightSin
	      cdq
	      imul ebx
              add eax,_vy
	      sub eax,ebp
	      sar eax,8
	      cdq
              imul _SCANLINELENGTH    ; normalized to 24:8 format
              mov _Dv,eax
	      sal ecx,8           ; normalize u0 and u1 to 8:24 format
              sal ebp,8
	      mov edx,ebp	      
              	      
              mov ebp,_SCREENWIDTH   ; inner for loop                                         

@@DoScanLine:

              mov ebx,edi            ; get 64 bits of edi in active cache

              mov ebx,edx
	      shr ebx,24
	      shld ebx,ecx,8	      
	      mov al,BYTE PTR [ esi+ebx ]
              add ecx,_Du            ; u0+=Du
              add edx,_Dv            ; v0+=Dv  
              	      
              mov ebx,edx
	      shr ebx,24
	      shld ebx,ecx,8	      
	      mov ah,BYTE PTR [ esi+ebx ]
              add ecx,_Du            ; u0+=Du
              add edx,_Dv            ; v0+=Dv  
	      
              bswap eax              	      	      

              mov ebx,edx
	      shr ebx,24
	      shld ebx,ecx,8	      
	      mov ah,BYTE PTR [ esi+ebx ]
              add ecx,_Du            ; u0+=Du
              add edx,_Dv            ; v0+=Dv  
	     
              mov ebx,edx
	      shr ebx,24
	      shld ebx,ecx,8	      
	      mov al,BYTE PTR [ esi+ebx ]
              add ecx,_Du            ; u0+=Du
              add edx,_Dv            ; v0+=Dv  

              bswap eax	     
              mov [edi],eax          ; slap to buffer
              add edi,4

              dec ebp
	      jnz @@DoScanLine	      	      	     
              inc _row
              mov ebp,_row
              cmp ebp,_SkyLimit
	      jl @@DoSky
	      
	      pop ebp
	      pop edi
	      pop esi
              
	      cld	      
	      ret
	      
RenderSkyLine ENDP
          
CastRay PROC NEAR

              push esi
	      push edi
	      push ebp

              mov eax,_kVScale
	      shl eax,8
              mov _DEPTHCLIP,eax

              mov eax,_SCREENSIZE
              sub eax,_SCREENW
              add eax,_col
              mov _pixel,eax
              mov esi,_Heightmap   

              mov eax,_col            
              cmp eax,_SHADOWSTART
	      jle @@NoShadow
              cmp eax,_SHADOWEND
	      jge @@NoShadow
                                         ; in shadow
	      
              jmp $+2	                 ; clear prefetch queue

              sub eax,_SHADOWSTART
              mov _shadowoffset,eax
              mov eax,_x                 ; x
              mov ebx,_y                 ; y
              mov ecx,_z                 ; z
	      xor edx,edx                ; ph
              mov _depth,-1  

@@DoSliver:              	      
              cmp edx,_DEPTHCLIP      
	      jge @@TheEnd        
              add eax,_dx
              add ebx,_dy
              add ecx,_dz
              add edx,_kVScale
	      add _depth,1
	      mov ebp,ebx
	      shr ebp,23
	      shld ebp,eax,9
	      mov edi,[ esi+ebp*4 ]
	      cmp edi,ecx
	      jle @@DoSliver
              push esi                        ; need register --> if only intel had more!
	      push ebx               
	      push eax                       
	      xor ebx,ebx
              mov esi,_Colormap   
	      mov bl,BYTE PTR [ esi+ebp ]             ; ebx holds color
              mov ebp,_depth
	      shl ebp,6
              add ebp,_shadowoffset
              mov esi,_ShadowmapPtr
	      xor eax,eax
	      mov al,BYTE PTR [ esi+ebp ]
     	      shl ebx,1
	      add eax,ebx
              mov esi,_ShadowPAL    
	      mov bl, BYTE PTR [ esi+eax ]             
	      mov ebp,edi                      ; ebx holds height
              mov edi,_Buffer   
              mov esi,_pixel
              mov eax,_dz
	      	      	      
@@ReplicateColor:              	      	       

              add eax,_kVScale                 ; dz+=kVScale
              mov BYTE PTR [ edi+esi ],bl	      
              add ecx,edx                      ; z+=ph
              sub esi,_SCREENW                 ; pixel-=SCREENWIDTH     
              cmp esi,0
	      jge  @@PassOver
              pop eax
	      pop ebx
	      pop esi
	      jmp @@TheEnd
	      
@@PassOver:
	      
              cmp ebp,ecx
              jg  @@ReplicateColor              
              mov _dz,eax
              mov _pixel,esi
	      pop eax               ; restore x 
	      pop ebx               ; restore y
	      pop esi               ; point back to Heightmap
   	      jmp @@DoSliver
	              
@@NoShadow:
	      
              jmp $+2	            ; clear prefetch queue

              mov eax,_x            ; x
              mov ebx,_y            ; y
              mov ecx,_z            ; z
	      xor edx,edx           ; ph

@@DoSliver2:              	      
              
              cmp edx,_DEPTHCLIP              
   	      jge @@TheEnd
              add eax,_dx
              add ebx,_dy
              add ecx,_dz
              add edx,_kVScale
	      mov ebp,ebx
	      shr ebp,23
	      shld ebp,eax,9
	      mov edi,DWORD PTR [ esi+ebp*4 ]
	      cmp edi,ecx
	      jle @@DoSliver2
              push esi
	      push ebx                        
	      push eax                         ; need reg --> if only intel had more!
              mov esi,_Colormap   
	      mov bl,BYTE PTR [ esi+ebp ]
	      mov ebp,edi                      ; ebp holds height
              mov edi,_Buffer   
              mov esi,_pixel
              mov eax,_dz
	      	      	      
@@ReplicateColor2:              	      	       

              add eax,_kVScale                 ; dz+=kVScale
              mov BYTE PTR [ edi+esi ],bl     
              add ecx,edx                      ; z+=ph
              sub esi,_SCREENW                 ; pixel-=SCREENWIDTH     
              cmp esi,0                        ; pixel position < 0      
	      jge  @@PassOver2
              pop eax
	      pop ebx
	      pop esi
	      jmp @@TheEnd
	      
@@PassOver2:
	      
              cmp ebp,ecx
              jg  @@ReplicateColor2             
              mov _dz,eax
              mov _pixel,esi
	      pop eax
	      pop ebx
	      pop esi
   	      jmp @@DoSliver2

@@TheEnd:
	       
	      pop ebp
	      pop edi
	      pop esi

	      cld	      
              ret
	      
CastRay ENDP
_TEXT            ENDS

		END
