UNIT DTrig;

(******************************************************)
INTERFACE
(******************************************************)

Function DCos(VAR Angle:Word):Integer;
Function DSin(Angle:Word):Integer;
Function DTan(VAR Angle:Word):LongInt;
Function DArcTan(VAR Quadrant:Byte; VAR Tangiens:LongInt):Word;

(******************************************************)
IMPLEMENTATION
(******************************************************)

CONST
   CosTab:Array[0..360] Of Integer=
      (1000,  1000,  999,   999,   998,   996,   995,   993,   990,   988,
       985,   982,   978,   974,   970,   966,   961,   956,   951,   946,
       940,   934,   927,   921,   914,   906,   899,   891,   883,   875,
       866,   857,   848,   839,   829,   819,   809,   799,   788,   777,
       766,   755,   743,   731,   719,   707,   695,   682,   669,   656,
       643,   629,   616,   602,   588,   574,   559,   545,   530,   515,
       500,   485,   469,   454,   438,   423,   407,   391,   375,   358,
       342,   326,   309,   292,   276,   259,   242,   225,   208,   191,
       174,   156,   139,   122,   105,   87,    70,    52,    35,    17,
       0,    -17,   -35,   -52,   -70,   -87,   -105,  -122,  -139,  -156,
      -174,  -191,  -208,  -225,  -242,  -259,  -276,  -292,  -309,  -326,
      -342,  -358,  -375,  -391,  -407,  -423,  -438,  -454,  -469,  -485,
      -500,  -515,  -530,  -545,  -559,  -574,  -588,  -602,  -616,  -629,
      -643,  -656,  -669,  -682,  -695,  -707,  -719,  -731,  -743,  -755,
      -766,  -777,  -788,  -799,  -809,  -819,  -829,  -839,  -848,  -857,
      -866,  -875,  -883,  -891,  -899,  -906,  -914,  -921,  -927,  -934,
      -940,  -946,  -951,  -956,  -961,  -966,  -970,  -974,  -978,  -982,
      -985,  -988,  -990,  -993,  -995,  -996,  -998,  -999,  -999,  -1000,
      -1000, -1000, -999,  -999,  -998,  -996,  -995,  -993,  -990,  -988,
      -985,  -982,  -978,  -974,  -970,  -966,  -961,  -956,  -951,  -946,
      -940,  -934,  -927,  -921,  -914,  -906,  -899,  -891,  -883,  -875,
      -866,  -857,  -848,  -839,  -829,  -819,  -809,  -799,  -788,  -777,
      -766,  -755,  -743,  -731,  -719,  -707,  -695,  -682,  -669,  -656,
      -643,  -629,  -616,  -602,  -588,  -574,  -559,  -545,  -530,  -515,
      -500,  -485,  -469,  -454,  -438,  -423,  -407,  -391,  -375,  -358,
      -342,  -326,  -309,  -292,  -276,  -259,  -242,  -225,  -208,  -191,
      -174,  -156,  -139,  -122,  -105,  -87,   -70,   -52,   -35,   -17,
       0,     17,    35,    52,    70,    87,    105,   122,   139,   156,
       174,   191,   208,   225,   242,   259,   276,   292,   309,   326,
       342,   358,   375,   391,   407,   423,   438,   454,   469,   485,
       500,   515,   530,   545,   559,   574,   588,   602,   616,   629,
       643,   656,   669,   682,   695,   707,   719,   731,   743,   755,
       766,   777,   788,   799,   809,   819,   829,   839,   848,   857,
       866,   875,   883,   891,   899,   906,   914,   921,   927,   934,
       940,   946,   951,   956,   961,   966,   970,   974,   978,   982,
       985,   988,   990,   993,   995,   996,   998,   999,   999,   1000,
       1000);

   TanTab:Array[0..360] Of LongInt=
      (0,     17,    35,    52,    70,     87,    105,   123,   141,   158,
       176,   194,   213,   231,   249,    268,   287,   306,   325,   344,
       364,   384,   404,   424,   445,    466,   488,   510,   532,   554,
       577,   601,   625,   649,   675,    700,   727,   754,   781,   810,
       839,   869,   900,   933,   966,    1000,  1036,  1072,  1111,  1150,
       1192,  1235,  1280,  1327,  1376,  1428,  1483,  1540,  1600,  1664,
       1732,  1804,  1881,  1963,  2050,  2145,  2246,  2356,  2475,  2605,
       2747,  2904,  3078,  3271,  3487,  3732,  4011,  4331,  4705,  5145,
       5671,  6314,  7115,  8144,  9514,  11430, 14301, 19081, 28636, 57290,
       00000,-57290,-28636,-19081,-14301,-11430,-9514, -8144, -7115, -6314,
      -5671, -5145, -4705, -4331, -4011, -3732, -3487, -3271, -3078, -2904,
      -2747, -2605, -2475, -2356, -2246, -2145, -2050, -1963, -1881, -1804,
      -1732, -1664, -1600, -1540, -1483, -1428, -1376, -1327, -1280, -1235,
      -1192, -1150, -1111, -1072, -1036, -1000, -966,  -933,  -900,  -869,
      -839,  -810,  -781,  -754,  -727,  -700,  -675,  -649,  -625,  -601,
      -577,  -554,  -532,  -510,  -488,  -466,  -445,  -424,  -404,  -384,
      -364,  -344,  -325,  -306,  -287,  -268,  -249,  -231,  -213,  -194,
      -176,  -158,  -141,  -123,  -105,  -87,   -70,   -52,   -35,   -17,
       0,     17,    35,    52,    70,    87,    105,   123,   141,   158,
       176,   194,   213,   231,   249,   268,   287,   306,   325,   344,
       364,   384,   404,   424,   445,   466,   488,   510,   532,   554,
       577,   601,   625,   649,   675,   700,   727,   754,   781,   810,
       839,   869,   900,   933,   966,   1000,  1036,  1072,  1111,  1150,
       1192,  1235,  1280,  1327,  1376,  1428,  1483,  1540,  1600,  1664,
       1732,  1804,  1881,  1963,  2050,  2145,  2246,  2356,  2475,  2605,
       2747,  2904,  3078,  3271,  3487,  3732,  4011,  4331,  4705,  5145,
       5671,  6314,  7115,  8144,  9514,  11430, 14301, 19081, 28636, 57290,
       00000,-57290,-28636,-19081,-14301,-11430,-9514, -8144, -7115, -6314,
      -5671, -5145, -4705, -4331, -4011, -3732, -3487, -3271, -3078, -2904,
      -2747, -2605, -2475, -2356, -2246, -2145, -2050, -1963, -1881, -1804,
      -1732, -1664, -1600, -1540, -1483, -1428, -1376, -1327, -1280, -1235,
      -1192, -1150, -1111, -1072, -1036, -1000, -966,  -933,  -900,  -869,
      -839,  -810,  -781,  -754,  -727,  -700,  -675,  -649,  -625,  -601,
      -577,  -554,  -532,  -510,  -488,  -466,  -445,  -424,  -404,  -384,
      -364,  -344,  -325,  -306,  -287,  -268,  -249,  -231,  -213,  -194,
      -176,  -158,  -141,  -123,  -105,  -87,   -70,   -52,   -35,   -17,
       0);

(******************************************************)

Function DCos(VAR Angle:Word):Integer;
   Begin
   DCos:=CosTab[Angle];
   End;

(******************************************************)

Function DSin(Angle:Word):Integer;
   Begin

   If Angle<=90 Then
      Angle:=90-Angle
   Else
      Angle:=450-Angle;

   DSin:=CosTab[Angle];
   End;

(******************************************************)

Function DTan(VAR Angle:Word):LongInt;
   Begin
   DTan:=TanTab[Angle];
   End;

(******************************************************)

Function DArcTan(VAR Quadrant:Byte; VAR Tangiens:LongInt):Word;
   VAR
      Low,Mid,High:Word;

   Begin
   Low:=90*Quadrant;
   Mid:=90*Quadrant+45;
   High:=90*Quadrant+90;

   While High-Low>1 Do
      Begin

      If Tangiens<DTan(Mid) Then
         Begin
         High:=Mid;
         Mid:=(High-Low)Div 2;
         Inc(Mid,Low);
         End
      Else If Tangiens>DTan(Mid) Then
         Begin
         Low:=Mid;
         Mid:=(High-Low)Div 2;
         Inc(Mid,Low);
         End
      Else
         Begin
         Low:=Mid;
         High:=Mid;
         End;

      End;

   If Low<>High Then
      Begin

      If Tangiens-Low<=High-Tangiens Then
         Mid:=Low
      Else
         Mid:=High;

      End;

   DArcTan:=Mid;
   End;

(******************************************************)

Begin
End.