   UNIT VecObj;

   (***************************************************)
   INTERFACE
   (***************************************************)

   CONST
      MaxUsedPoints=16;
      MaxUsedLinks=16;
      X=1;
      Y=2;
      Z=3;
      StartPoint=0;
      EndPoint=1;
      New=0;
      Old=1;

   VAR
      Obj:Record
      Points:Byte;
      Links:Byte;
      PointPos:Array[1..MaxUsedPoints,X..Z] Of Integer;
      Link:Array[1..MaxUsedLinks,StartPoint..EndPoint] Of Byte;
      Pos:Array[X..Z] Of LongInt;
      End;

   PROCEDURE SetCStructure;
   PROCEDURE InitC;
   PROCEDURE SetOStructure;
   PROCEDURE InitO;
   PROCEDURE SetLIStructure;
   PROCEDURE InitL;
   PROCEDURE InitI;
   PROCEDURE SetRStructure;
   PROCEDURE InitR;
   PROCEDURE SetSStructure;
   PROCEDURE InitS;
   PROCEDURE SetSpaceStructure;
   PROCEDURE InitSpace;

   (***************************************************)
   IMPLEMENTATION
   (***************************************************)

   PROCEDURE SetCStructure;
   Begin
   Obj.Points:=10;
   Obj.Links:=10;

   Obj.Link[1,StartPoint]:=1;
   Obj.Link[1,EndPoint]:=2;
   Obj.Link[2,StartPoint]:=2;
   Obj.Link[2,EndPoint]:=3;
   Obj.Link[3,StartPoint]:=3;
   Obj.Link[3,EndPoint]:=4;
   Obj.Link[4,StartPoint]:=4;
   Obj.Link[4,EndPoint]:=5;
   Obj.Link[5,StartPoint]:=5;
   Obj.Link[5,EndPoint]:=6;
   Obj.Link[6,StartPoint]:=6;
   Obj.Link[6,EndPoint]:=7;
   Obj.Link[7,StartPoint]:=7;
   Obj.Link[7,EndPoint]:=8;
   Obj.Link[8,StartPoint]:=8;
   Obj.Link[8,EndPoint]:=9;
   Obj.Link[9,StartPoint]:=9;
   Obj.Link[9,EndPoint]:=10;
   Obj.Link[10,StartPoint]:=10;
   Obj.Link[10,EndPoint]:=1;
   End;

   (***************************************************)

   PROCEDURE InitC;
   Begin
   Obj.PointPos[1,X]:=-1000;
   Obj.PointPos[1,Y]:=-2500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=2000;
   Obj.PointPos[2,Y]:=-2500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=2000;
   Obj.PointPos[3,Y]:=-1500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=-1000;
   Obj.PointPos[4,Y]:=-1500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=-1000;
   Obj.PointPos[5,Y]:=500;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=2000;
   Obj.PointPos[6,Y]:=500;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=2000;
   Obj.PointPos[7,Y]:=2500;
   Obj.PointPos[7,Z]:=1;
   Obj.PointPos[8,X]:=-1000;
   Obj.PointPos[8,Y]:=2500;
   Obj.PointPos[8,Z]:=1;
   Obj.PointPos[9,X]:=-2000;
   Obj.PointPos[9,Y]:=1500;
   Obj.PointPos[9,Z]:=1;
   Obj.PointPos[10,X]:=-2000;
   Obj.PointPos[10,Y]:=-1500;
   Obj.PointPos[10,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE SetOStructure;
   Begin
   Obj.Points:=12;
   Obj.Links:=12;

   Obj.Link[1,StartPoint]:=1;
   Obj.Link[1,EndPoint]:=2;
   Obj.Link[2,StartPoint]:=2;
   Obj.Link[2,EndPoint]:=3;
   Obj.Link[3,StartPoint]:=3;
   Obj.Link[3,EndPoint]:=8;
   Obj.Link[4,StartPoint]:=8;
   Obj.Link[4,EndPoint]:=9;
   Obj.Link[5,StartPoint]:=9;
   Obj.Link[5,EndPoint]:=10;
   Obj.Link[6,StartPoint]:=10;
   Obj.Link[6,EndPoint]:=11;
   Obj.Link[7,StartPoint]:=11;
   Obj.Link[7,EndPoint]:=12;
   Obj.Link[8,StartPoint]:=4;
   Obj.Link[8,EndPoint]:=5;
   Obj.Link[9,StartPoint]:=5;
   Obj.Link[9,EndPoint]:=7;
   Obj.Link[10,StartPoint]:=7;
   Obj.Link[10,EndPoint]:=6;
   Obj.Link[11,StartPoint]:=6;
   Obj.Link[11,EndPoint]:=4;
   Obj.Link[12,StartPoint]:=12;
   Obj.Link[12,EndPoint]:=1;
   End;

   (***************************************************)

   PROCEDURE InitO;
   Begin
   Obj.PointPos[1,X]:=-1000;
   Obj.PointPos[1,Y]:=-2500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=1000;
   Obj.PointPos[2,Y]:=-2500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=2000;
   Obj.PointPos[3,Y]:=-1500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=-1000;
   Obj.PointPos[4,Y]:=-1500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=1000;
   Obj.PointPos[5,Y]:=-1500;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=-1000;
   Obj.PointPos[6,Y]:=500;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=1000;
   Obj.PointPos[7,Y]:=500;
   Obj.PointPos[7,Z]:=1;
   Obj.PointPos[8,X]:=2000;
   Obj.PointPos[8,Y]:=1500;
   Obj.PointPos[8,Z]:=1;
   Obj.PointPos[9,X]:=1000;
   Obj.PointPos[9,Y]:=2500;
   Obj.PointPos[9,Z]:=1;
   Obj.PointPos[10,X]:=-1000;
   Obj.PointPos[10,Y]:=2500;
   Obj.PointPos[10,Z]:=1;
   Obj.PointPos[11,X]:=-2000;
   Obj.PointPos[11,Y]:=1500;
   Obj.PointPos[11,Z]:=1;
   Obj.PointPos[12,X]:=-2000;
   Obj.PointPos[12,Y]:=-1500;
   Obj.PointPos[12,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE SetLIStructure;
   Begin
   Obj.Points:=7;
   Obj.Links:=7;

   Obj.Link[1,StartPoint]:=1;
   Obj.Link[1,EndPoint]:=2;
   Obj.Link[2,StartPoint]:=2;
   Obj.Link[2,EndPoint]:=3;
   Obj.Link[3,StartPoint]:=3;
   Obj.Link[3,EndPoint]:=4;
   Obj.Link[4,StartPoint]:=4;
   Obj.Link[4,EndPoint]:=5;
   Obj.Link[5,StartPoint]:=5;
   Obj.Link[5,EndPoint]:=6;
   Obj.Link[6,StartPoint]:=6;
   Obj.Link[6,EndPoint]:=7;
   Obj.Link[7,StartPoint]:=7;
   Obj.Link[7,EndPoint]:=1;
   End;

   (***************************************************)

   PROCEDURE InitL;
   Begin
   Obj.PointPos[1,X]:=-2000;
   Obj.PointPos[1,Y]:=-2500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=-1000;
   Obj.PointPos[2,Y]:=-2500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=-1000;
   Obj.PointPos[3,Y]:=500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=2000;
   Obj.PointPos[4,Y]:=500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=2000;
   Obj.PointPos[5,Y]:=2500;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=-1000;
   Obj.PointPos[6,Y]:=2500;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=-2000;
   Obj.PointPos[7,Y]:=1500;
   Obj.PointPos[7,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE InitI;
   Begin
   Obj.PointPos[1,X]:=-3000;
   Obj.PointPos[1,Y]:=-2500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=-2000;
   Obj.PointPos[2,Y]:=-2500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=-2000;
   Obj.PointPos[3,Y]:=500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=-1000;
   Obj.PointPos[4,Y]:=500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=-1000;
   Obj.PointPos[5,Y]:=2500;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=-2000;
   Obj.PointPos[6,Y]:=2500;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=-3000;
   Obj.PointPos[7,Y]:=1500;
   Obj.PointPos[7,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE SetRStructure;
   Begin
   Obj.Points:=14;
   Obj.Links:=14;

   Obj.Link[1,StartPoint]:=1;
   Obj.Link[1,EndPoint]:=2;
   Obj.Link[2,StartPoint]:=2;
   Obj.Link[2,EndPoint]:=3;
   Obj.Link[3,StartPoint]:=3;
   Obj.Link[3,EndPoint]:=4;
   Obj.Link[4,StartPoint]:=4;
   Obj.Link[4,EndPoint]:=5;
   Obj.Link[5,StartPoint]:=5;
   Obj.Link[5,EndPoint]:=6;
   Obj.Link[6,StartPoint]:=6;
   Obj.Link[6,EndPoint]:=7;
   Obj.Link[7,StartPoint]:=7;
   Obj.Link[7,EndPoint]:=8;
   Obj.Link[8,StartPoint]:=8;
   Obj.Link[8,EndPoint]:=9;
   Obj.Link[9,StartPoint]:=9;
   Obj.Link[9,EndPoint]:=10;
   Obj.Link[10,StartPoint]:=10;
   Obj.Link[10,EndPoint]:=11;
   Obj.Link[11,StartPoint]:=11;
   Obj.Link[11,EndPoint]:=12;
   Obj.Link[12,StartPoint]:=12;
   Obj.Link[12,EndPoint]:=13;
   Obj.Link[13,StartPoint]:=13;
   Obj.Link[13,EndPoint]:=14;
   Obj.Link[14,StartPoint]:=14;
   Obj.Link[14,EndPoint]:=1;
   End;

   (***************************************************)

   PROCEDURE InitR;
   Begin
   Obj.PointPos[1,X]:=-1500;
   Obj.PointPos[1,Y]:=-1500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=1500;
   Obj.PointPos[2,Y]:=-1500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=2500;
   Obj.PointPos[3,Y]:=-500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=2500;
   Obj.PointPos[4,Y]:=500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=1500;
   Obj.PointPos[5,Y]:=1500;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=2500;
   Obj.PointPos[6,Y]:=1500;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=2500;
   Obj.PointPos[7,Y]:=3500;
   Obj.PointPos[7,Z]:=1;
   Obj.PointPos[8,X]:=500;
   Obj.PointPos[8,Y]:=3500;
   Obj.PointPos[8,Z]:=1;
   Obj.PointPos[9,X]:=-500;
   Obj.PointPos[9,Y]:=2500;
   Obj.PointPos[9,Z]:=1;
   Obj.PointPos[10,X]:=1500;
   Obj.PointPos[10,Y]:=500;
   Obj.PointPos[10,Z]:=1;
   Obj.PointPos[11,X]:=1500;
   Obj.PointPos[11,Y]:=-500;
   Obj.PointPos[11,Z]:=1;
   Obj.PointPos[12,X]:=-500;
   Obj.PointPos[12,Y]:=-500;
   Obj.PointPos[12,Z]:=1;
   Obj.PointPos[13,X]:=-500;
   Obj.PointPos[13,Y]:=3500;
   Obj.PointPos[13,Z]:=1;
   Obj.PointPos[14,X]:=-1500;
   Obj.PointPos[14,Y]:=3500;
   Obj.PointPos[14,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE SetSStructure;
   Begin
   Obj.Points:=16;
   Obj.Links:=16;

   Obj.Link[1,StartPoint]:=1;
   Obj.Link[1,EndPoint]:=2;
   Obj.Link[2,StartPoint]:=2;
   Obj.Link[2,EndPoint]:=3;
   Obj.Link[3,StartPoint]:=3;
   Obj.Link[3,EndPoint]:=4;
   Obj.Link[4,StartPoint]:=4;
   Obj.Link[4,EndPoint]:=5;
   Obj.Link[5,StartPoint]:=5;
   Obj.Link[5,EndPoint]:=6;
   Obj.Link[6,StartPoint]:=6;
   Obj.Link[6,EndPoint]:=7;
   Obj.Link[7,StartPoint]:=7;
   Obj.Link[7,EndPoint]:=8;
   Obj.Link[8,StartPoint]:=8;
   Obj.Link[8,EndPoint]:=9;
   Obj.Link[9,StartPoint]:=9;
   Obj.Link[9,EndPoint]:=10;
   Obj.Link[10,StartPoint]:=10;
   Obj.Link[10,EndPoint]:=11;
   Obj.Link[11,StartPoint]:=11;
   Obj.Link[11,EndPoint]:=12;
   Obj.Link[12,StartPoint]:=12;
   Obj.Link[12,EndPoint]:=13;
   Obj.Link[13,StartPoint]:=13;
   Obj.Link[13,EndPoint]:=14;
   Obj.Link[14,StartPoint]:=14;
   Obj.Link[14,EndPoint]:=15;
   Obj.Link[15,StartPoint]:=15;
   Obj.Link[15,EndPoint]:=16;
   Obj.Link[16,StartPoint]:=16;
   Obj.Link[16,EndPoint]:=1;
   End;

   (***************************************************)

   PROCEDURE InitS;
   Begin
   Obj.PointPos[1,X]:=-1000;
   Obj.PointPos[1,Y]:=-3500;
   Obj.PointPos[1,Z]:=1;
   Obj.PointPos[2,X]:=2000;
   Obj.PointPos[2,Y]:=-3500;
   Obj.PointPos[2,Z]:=1;
   Obj.PointPos[3,X]:=2000;
   Obj.PointPos[3,Y]:=-2500;
   Obj.PointPos[3,Z]:=1;
   Obj.PointPos[4,X]:=-1000;
   Obj.PointPos[4,Y]:=-2500;
   Obj.PointPos[4,Z]:=1;
   Obj.PointPos[5,X]:=-1000;
   Obj.PointPos[5,Y]:=-2000;
   Obj.PointPos[5,Z]:=1;
   Obj.PointPos[6,X]:=1000;
   Obj.PointPos[6,Y]:=-2000;
   Obj.PointPos[6,Z]:=1;
   Obj.PointPos[7,X]:=2000;
   Obj.PointPos[7,Y]:=-1000;
   Obj.PointPos[7,Z]:=1;
   Obj.PointPos[8,X]:=2000;
   Obj.PointPos[8,Y]:=500;
   Obj.PointPos[8,Z]:=1;
   Obj.PointPos[9,X]:=1000;
   Obj.PointPos[9,Y]:=1500;
   Obj.PointPos[9,Z]:=1;
   Obj.PointPos[10,X]:=-2000;
   Obj.PointPos[10,Y]:=1500;
   Obj.PointPos[10,Z]:=1;
   Obj.PointPos[11,X]:=-2000;
   Obj.PointPos[11,Y]:=-500;
   Obj.PointPos[11,Z]:=1;
   Obj.PointPos[12,X]:=1000;
   Obj.PointPos[12,Y]:=-500;
   Obj.PointPos[12,Z]:=1;
   Obj.PointPos[13,X]:=1000;
   Obj.PointPos[13,Y]:=-1000;
   Obj.PointPos[13,Z]:=1;
   Obj.PointPos[14,X]:=-1000;
   Obj.PointPos[14,Y]:=-1000;
   Obj.PointPos[14,Z]:=1;
   Obj.PointPos[15,X]:=-2000;
   Obj.PointPos[15,Y]:=-2000;
   Obj.PointPos[15,Z]:=1;
   Obj.PointPos[16,X]:=-2000;
   Obj.PointPos[16,Y]:=-2500;
   Obj.PointPos[16,Z]:=1;
   End;

   (***************************************************)

   PROCEDURE SetSpaceStructure;
   Begin
   Obj.Points:=16;
   End;

   (***************************************************)

   PROCEDURE InitSpace;
   Begin
   Obj.PointPos[1,X]:=-10000;
   Obj.PointPos[1,Y]:=-3500;
   Obj.PointPos[1,Z]:=13500;
   Obj.PointPos[2,X]:=-5000;
   Obj.PointPos[2,Y]:=-3500;
   Obj.PointPos[2,Z]:=-2059;
   Obj.PointPos[3,X]:=2035;
   Obj.PointPos[3,Y]:=-2356;
   Obj.PointPos[3,Z]:=1060;
   Obj.PointPos[4,X]:=-14990;
   Obj.PointPos[4,Y]:=-2500;
   Obj.PointPos[4,Z]:=1270;
   Obj.PointPos[5,X]:=-100;
   Obj.PointPos[5,Y]:=-2000;
   Obj.PointPos[5,Z]:=-5001;
   Obj.PointPos[6,X]:=10470;
   Obj.PointPos[6,Y]:=-5000;
   Obj.PointPos[6,Z]:=100;
   Obj.PointPos[7,X]:=4700;
   Obj.PointPos[7,Y]:=-10000;
   Obj.PointPos[7,Z]:=-4500;
   Obj.PointPos[8,X]:=2040;
   Obj.PointPos[8,Y]:=5000;
   Obj.PointPos[8,Z]:=-9701;
   Obj.PointPos[9,X]:=-10440;
   Obj.PointPos[9,Y]:=1500;
   Obj.PointPos[9,Z]:=4900;
   Obj.PointPos[10,X]:=-2000;
   Obj.PointPos[10,Y]:=1500;
   Obj.PointPos[10,Z]:=140;
   Obj.PointPos[11,X]:=-2000;
   Obj.PointPos[11,Y]:=-4700;
   Obj.PointPos[11,Z]:=9071;
   Obj.PointPos[12,X]:=1000;
   Obj.PointPos[12,Y]:=-500;
   Obj.PointPos[12,Z]:=778;
   Obj.PointPos[13,X]:=3640;
   Obj.PointPos[13,Y]:=-1050;
   Obj.PointPos[13,Z]:=-7000;
   Obj.PointPos[14,X]:=-1000;
   Obj.PointPos[14,Y]:=-1045;
   Obj.PointPos[14,Z]:=108;
   Obj.PointPos[15,X]:=-2000;
   Obj.PointPos[15,Y]:=-7600;
   Obj.PointPos[15,Z]:=6800;
   Obj.PointPos[16,X]:=-2000;
   Obj.PointPos[16,Y]:=-2457;
   Obj.PointPos[16,Z]:=15400;
   End;

   (***************************************************)

   Begin
   End.