program PHANTOM_3D_ENGINE;
uses vga256,crt;
const SCRWIDTH=320;
      MWIDTH=128;
      MCENTRE=64;
      SIZE=160;           { veelvoud van 2!! }
      LINES=65;           { aantal lijnen voor vloer (MAX. 70) }
      KIM=20;             { hoogte tussen plafond en vloer }
      XPOS=0;
      DARK=1;             { donker in de verte }
      DIST=4500;          { 1769 voor SIZE=320 }
      HAZE=0;             { mistig in de verte }

{ SOURCES INCLUDED - SOFTWARE MADE BY THE PHANTOM - A MEGAVOLT DEMOCODER }
{ explaining everything about this source is getting a bit too laborous, }
{ so if you wanna know anything just give me a ring or leave me a messy  }
{ at MEGAVOLT BBS.                                                       }

{ Important parts for try-out programmers:
  - The first lines (the constants):
    use these to alter the screen size and position.
    you better not change the mapsize, I don't know what will happen,
    but it's vital to the program (I am shifting 7 bits to get a
    128 times multiply you see)
  - The 'dummysource' procedure:
    Here the map is generated. Offcourse you could load your own map,
    just do a blockread after the getmem. There are even animated blocks,
    have a look at the sample map to see how you can use them.
  - The 'dummybitmaps' procedure:
    Every bitmap is 32x32 pixels, that's one kilobyte per bitmap.
    Just draw a bitmap at adres 0, and do a convertbitmap afterwards
    to get it in the right place. Just do the same as I did.
    Hint: Don't use straigt lines, just ditter a little, the effect
    is much better and more natural.
    O yes, color 0 means a bar. Bitmap 3 is completely zero, so you
    get a wall. But you could draw a circle with color 0, so you
    could draw pilars (bitmapped pilars in the future)
    Bitmap 43 (the lavastream) is scrolled to the left, maybe you
    would like something else to scroll to the left, or a different
    effect (like bubbling mud or so)
  - The 'MakeOutlines' procedure:
    I hate to draw a charset by myself, so I made a charset with
    7x7 dots. This looks ugly, but is easy to make. Then I wrote a
    small procedure to make the outlines slightly darker. Looks great.
  - DrawAMap:
    The wonderfull PHANTOM 3D engine. Actually quitte short, but I
    needed a version for every fourth of a circle (quadrant?), that's
    how I kept the transformation-table so short.
    Just pass the correct parameters to it: A coord, and an angle.
    The coords are a bit special:
    Every square on the map is 512 steps, so you can move really smooth.
    X=0 and Y=0 gives you the centre of the map, thus 64,64.
    So, the edges of the map have coords of 32768. (That's the largest
    int, in case you were wondering why the map is so small).
    The rotation is not really in degrees: an angle of 45 is 90 degrees
    real rotation. So, a whole turn is 180 steps. Easy, isn't it?

  Well, I guess this will do for now, just have fun, and call me if
  anything is unclear.

  My adres is: (I love mail)
  Jacco Bikker
  Gestellaan 44
  3431 GN  Nieuwegein

  And my phonenumber is still:  03402-33309
}


var s1,o1,s3,o3,s2,o2,s4,o4: word;
    p1,p2,p3,p4: pointer;
    i,x,y,width: word;
    a1,a2,a3,x1,y1: word;
    sy,ss,w,bg: real;
    f: file;
    sn,cs: array[0..360] of real;
    a: char;
    b: byte;
    r,s,d,x2,y2: integer;
    cset: string;

{assembler variables}
    stacks,loop,bloop,stackp,base,startf,startc: word;
    inner,transp,transs,xdelta,ydelta,wstep: word;
    htable,screen,screen2,hight,bitmap,curr: word;
    xp,yp,map,dir,colsize,coltab,stepsize,steptab,ceiling: word;

procedure DummySource(var p: pointer);
var i,s,o,x: word;
    r,m: array[0..63] of string[64];
    t: string;
    q,w: word;
Function Conv(s: char): byte;
var i: byte;
begin
   for i:=1 to length(cset) do if cset[i]=s then Conv:=i;
end;

begin
   GetMem(p,65535);
   s:=Seg(p^);
   o:=Ofs(p^);
   Cset:=': #ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890/*!)=@;';

   m[ 0]:='################################################################';
   m[ 1]:='################################################################';
   m[ 2]:='#:::::::::::::::: : : : : : : :###: : : : : : : : :::::::::::::#';
   m[ 3]:='#::::::::::::::::: : : : : : PHANTOM## : : : : : : ::::::::::::#';
   m[ 4]:='#:::::::::::::::: : : : : : ;;;;;;;;##: : : : : : : :::::::::::#';
   m[ 5]:='#::::::::::::::::: :PROUDLY PRESENTS## : : : : : : : ::::::::::#';
   m[ 6]:='#===================================#==========================#';
   m[ 7]:='#::::::::::::::::: : : : A FAST;;##============================#';
   m[ 8]:='#:::::::::::::::: : : : : : ;;;;;##============================#';
   m[ 9]:='#::::::::::::::::: : : 3D ENGINE;####===========###: : ::::::::#';
   m[10]:='#:::::::::::::::: : : : : ##====================### : :::::::::#';
   m[11]:='#::::::::::::::::: : : : :##==============## : :###: ::::::::::#';
   m[12]:='#:::::::::::::::: : : FEATURES ARE:#########: : : : : :::::::::#';
   m[13]:='#::::::::::::::::: :######## : : : ######### : : : : ::::::::::#';
   m[14]:='#:::::::::::::::: : : SHADED WALLS: :!:#####: : : : : :::::::::#';
   m[15]:='#::::::::::::::::: : : :## : : : : : ! ##### : : : : ::::::::::#';
   m[16]:='#:::::::::::::::: : :TEXTURED#FLOORS:!:#####: : : : : :::::::::#';
   m[17]:='#::::::::::::::::: : : :## : : : : : ! ##### : : : : ::::::::::#';
   m[18]:='#:::::::::::::::: : : TEXTURED:ROOF :!:#####: : : : : :::::::::#';
   m[19]:='#::::::::::::::::: : : :## : : : : : ########: : : : ::::::::::#';
   m[20]:='#:::::::::::::::: : : HAZE EFFECTS: :######## : : : :::::::::::#';
   m[21]:='#::::::::::::::::: : : :## : : : : : : : : ##: : : : ::::::::::#';
   m[22]:='#:::::::::::::::: : : : ##: : : : : : : : :## : : : : :::::::::#';
   m[23]:='#::::::::::::::::: : : :## : : : : : : : : ##: : : : ::::::::::#';
   m[24]:='#:::::::::::::::: : : : ##: : :9: : : : : :## : : : :::::::::::#';
   m[25]:='#::::::::::::::::: : : :## : :   : : : : : : : : : : ::::::::::#';
   m[26]:='#:::::::::::::::::::::::::::###8 ####::::::::::::::::::::::::::#';
   m[27]:='#:::::::::::::::::::::::::::###  ####::::::::::::::::::::::::::#';
   m[28]:='#::::::::::::::::::::::::::::##7 ###:::::::::::::::::::::::::::#';
   m[29]:='#::::::::::::::::::::::::::::##  ###:::::::::::::::::::::::::::#';
   m[30]:='#::::::::::::::::::::::::::::##6 ###:::::::::::::::::::::::::::#';
   m[31]:='#::::::::::::::::::::::::::::##  ###:::::::::::::::::::::::::::#';
   m[32]:='#::::::::::::::::::::::::::::##5 ###:::::::::::::::::::::::::::#';
   m[33]:='###############################  ###############################';
   m[34]:='###############################4 ###############################';
   m[35]:='#=========================##: : : : : : : :==================  #';
   m[36]:='#=========================## : 3 : : : ##: == == == == == ==   #';
   m[37]:='#=========================##: : : : : :##====================  #';
   m[38]:='#=========================## : 2 : : : ##====================  #';
   m[39]:='#=========================##: : : : : :##====================  #';
   m[40]:='#=========================## : 1 : : : ##====================  #';
   m[41]:='#=========================##: : : : : :##====================  #';
   m[42]:='#=========================## :#0 # :#: ##====================  #';
   m[43]:='#=============================#::#==#========================  #';
   m[44]:='#==============================::============================  #';
   m[45]:='#===================#==========::===============#============  #';
   m[46]:='#==============================::============================  #';
   m[47]:='#==============================::============================  #';
   m[48]:='#==============================::============================  #';
   m[49]:='#===================#==========::===============#============  #';
   m[50]:='#==============================::============================  #';
   m[51]:='#==============================::============================  #';
   m[52]:='#==============================::============================  #';
   m[53]:='#===================#==========::===============#============  #';
   m[54]:='#==========================;;;;;;;;;;;=======================  #';
   m[55]:='#==========================;;;;;;;;;;;=======================  #';
   m[56]:='#==========================;;;;;;;;;;;=======================  #';
   m[57]:='#===================#===#==;#;;;#;;;#;==#===#===#============  #';
   m[58]:='#==========================;;;;;;;;;;;=======================  #';
   m[59]:='#============================================================  #';
   m[60]:='#============================================================  #';
   m[61]:='#============================================================  #';
   m[62]:='################################################################';
   m[63]:='################################################################';

   r[ 0]:='################################################################';
   r[ 1]:='################################################################';
   r[ 2]:='#//////////////////*/*/*/*/*/*/###/////////////////////////////#';
   r[ 3]:='#::::::::::::::::::::::::::::://////##:::::::::::::::::::::::::#';
   r[ 4]:='#::::::::::::::::::::::::::::::::::/##:::::::::::::::::::::::::#';
   r[ 5]:='#::::::::::::::::::::::::::::::::::/##:::::::::::::::::::::::::#';
   r[ 6]:='#:::::::::::::::::::::::::::::::*///#/:::::::::::::::::::::::::#';
   r[ 7]:='#:::::::::::::::::::::          /##///:::::::::::::::::::::::::#';
   r[ 8]:='#:::::::::::::::::::::          /##///:::::::::::::::::::::::::#';
   r[ 9]:='#:::::::::::::::::::::   ///*   /####/:::::::::::::::::::::::::#';
   r[10]:='#:::::::::::::::::::::   /##/   //*///:::////::::::::::::::::::#';
   r[11]:='#:::::::::::::::::::::   /##/:: :://////:/##/::::::::::::::::::#';
   r[12]:='#:::::::::::::::::://////////:: ::/####/:/##/::::::::::::::::::#';
   r[13]:='#::::::::::::::::::/########*:: ::/####/:/##/::::::::::::::::::#';
   r[14]:='#:::::::::::::::::://////////:: ::*/////:/##/::::::::::::::::::#';
   r[15]:='#::::::::::::::::::::::/##/://* :::::::::/##/::::::::::::::::::#';
   r[16]:='#::::::::::::::::::::::////:/#/ :::::::::/##/::::::::::::::::::#';
   r[17]:='#::::::::::::::::::::::/##/:/// :::::::::/##/::::::::::::::::::#';
   r[18]:='#::::::::::::::::::::::////:::: :::://////##//:::::::::::::::::#';
   r[19]:='#:::::::::::::::::     /##/         /########/:::::::::::::::::#';
   r[20]:='#:::::::::::::::::     ////         ///////##/:::::::::::::::::#';
   r[21]:='#:::::::::::::::::     /##*****************##/:::::::::::::::::#';
   r[22]:='#:::::::::::::::::     /##/          :::::/##/:::::::::::::::::#';
   r[23]:='#:::::::::::::::::     /##*****************##/:::::::::::::::::#';
   r[24]:='#:::::::::::::::::     /##/          :::::/##/:::::::::::::::::#';
   r[25]:='#:::::::::::::::::     /##*************************************#';
   r[26]:='#:::::::::::::::::     //// ###//####::::::::::::::::::::::::::#';
   r[27]:='#:::::::::::::::::          ###**####::::::::::::::::::::::::::#';
   r[28]:='#:::::::::::::::::           ##//### ::::::::::::::::::::::::::#';
   r[29]:='#:::::::::::::::::           ##**### ::::::::::::::::::::::::::#';
   r[30]:='#::::::::::::::::::::::::::::##//###:::::::::::::::::::::::::::#';
   r[31]:='#::::::::::::::::::::::::::::##**###:::::::::::::::::::::::::::#';
   r[32]:='#::::::::::::::::::::::::::::##//###:::::::::::::::::::::::::::#';
   r[33]:='###############################**###############################';
   r[34]:='###############################//###############################';
   r[35]:='#:::::::::::::::::::::::::##*************//////////////////////#';
   r[36]:='#:::::::::::::::::::::::::##///////////##/*/*/*/*/*/*/*/*/*/*/*#';
   r[37]:='#:::::::::::::::::::::::::##***********##//////////////////////#';
   r[38]:='#:::::::::::::::::::::::::##///////////##::::::::::::::::::::/*#';
   r[39]:='#:::::::::::::::::::::::::##***********##:::::::::::::::::::://#';
   r[40]:='#:::::::::::::::://///////##///////////##/////////////:::::::/*#';
   r[41]:='#:::::::::::::::://*//*//*##***********##//*//*//*//*/::::::://#';
   r[42]:='#:::::::::::::::://///////##//#//#//#//##/////////////:::::::/*#';
   r[43]:='#:::::::::::::::://///////////#//#//#/////////////////::::::://#';
   r[44]:='#:::::::::::::::://*//*//*//*//*//*//*//*//*//*//*//*/:::::::/*#';
   r[45]:='#::::::::::::::::///#///////////////////////////#/////::::::://#';
   r[46]:='#:::::::::::::::://///////////////////////////////////:::::::/*#';
   r[47]:='#:::::::::::::::://*//*//*//*//*//*//*//*//*//*//*//*/::::::://#';
   r[48]:='#:::::::::::::::://///////////////////////////////////:::::::/*#';
   r[49]:='#::::::::::::::::///#///////////////////////////#/////::::::://#';
   r[50]:='#:::::::::::::::://*/////*//*//*//*//*//*//*//*//*//*/:::::::/*#';
   r[51]:='#:::::::::::::::://///////////////////////////////////::::::://#';
   r[52]:='#:::::::::::::::://///////////////////////////////////:::::::/*#';
   r[53]:='#:::::::::::::::://*#/*//*//*//*//*//*//*//*//*/#*//*/::::::://#';
   r[54]:='#:::::::::::::::://///////////////////////////////////:::::::/*#';
   r[55]:='#:::::::::::::::://///////////////////////////////////::::::://#';
   r[56]:='#:::::::::::::::://*//*//*//*//*//*//*//*//*//*//*//*/:::::::/*#';
   r[57]:='#::::::::::::::::///#///#///#///#///#///#///#///#/////::::::://#';
   r[58]:='#:::::::::::::::://///////////////////////////////////:::::::/*#';
   r[59]:='#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::://#';
   r[60]:='#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::/*#';
   r[61]:='#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::://#';
   r[62]:='################################################################';
   r[63]:='################################################################';

   q:=32*MWIDTH+32+o;
   w:=q+16384;
   for i:=0 to 63 do begin
      for x:=0 to 63 do begin
         mem[s:q+x]:=Conv(m[i][x]);
         mem[s:w+x]:=Conv(r[i][x]);
      end;
      inc(q,MWIDTH);
      inc(w,MWIDTH);
   end;
end;

procedure ConvertBitmap(s,o,n: word);
var x,y,a: word;
begin
   a:=n*1024+o;
   for x:=16 to 47 do for y:=16 to 47 do
      mem[s:a+(x mod 32)+(y mod 32)*32]:=mem[s:o+x+(y-16)*32-16];
end;

function Pixel(s,o: word; x,y: byte): byte;
begin
   Pixel:=0;
   if mem[s:o+x*4+y*128]=31 then Pixel:=1
end;

procedure MakeOutlines(s,o: word);
var z: byte;
    x,y,i,q,w: word;
begin
   for x:=1 to 7 do for y:=1 to 7 do begin
      q:=x*4-2+((y*4)-2)*32+o;
      if mem[s:q+34]=31 then begin
         z:=Pixel(s,o,x,y-1)+2*Pixel(s,o,x+1,y)+4*Pixel(s,o,x,y+1)+8*Pixel(s,o,x-1,y);
         if not (odd(z)) then meml[s:q]:=$8080808;
         if (z=1) or (z=4) or (z=5) or (z=8) or (z=9) or (z=12) or (z=13) or (z=0) then begin
            mem[s:q+35]:=8;
            mem[s:q+67]:=8;
            mem[s:q+99]:=8;
            mem[s:q+3]:=8;
         end;
         if (z=1) or (z=3) or (z=2) or (z=8) or (z=9) or (z=10) or (z=11) or (z=0) then
            meml[s:q+96]:=$8080808;
         if (z<8) then begin
            mem[s:q+32]:=8;
            mem[s:q+64]:=8;
            mem[s:q+96]:=8;
            mem[s:q]:=8;
         end;
      end;
   end;
end;

procedure MChar(b: byte; c: string; var s,o: word);
var i,x,y,x1,y1,a: word;
    t: char;
begin
   for i:=0 to 255 do meml[s:o+(i shl 2)]:=meml[s:o+2048+(i shl 2)];
   for y:=1 to 7 do for x:=1 to 7 do begin
      t:=c[y*8+x-8];
      if t='*' then for x1:=x*4-2 to x*4+1 do for y1:=y*4-2 to y*4+1 do
         mem[s:o+x1+y1*32]:=31;
   end;
   MakeOutlines(s,o);
   ConvertBitmap(s,o,b);
end;

procedure DummyBitmaps(var p: pointer);
var x,y,i,s,o,a,c: word;
begin
   GetMem(p,1024*63);                           {2 bitmaps voorlopig}
   s:=Seg(p^);
   o:=Ofs(p^);
   {clear all bitmaps}
   for i:=0 to 256*63 do meml[s:o+i shl 2]:=0;
   {bitmap 1}
   for y:=0 to 31 do for x:=0 to 31 do mem[s:o+x+y*32]:=random(3)+2;
   ConvertBitmap(s,o,1);
   {bitmap 2}
   for y:=0 to 31 do for x:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   ConvertBitmap(s,o,2);
   {bitmap 4-29 are characters!}
   MChar(4, '---*--- --***-- -**-**- **---** ******* **---** **---**',s,o); {A}
   MChar(5, '*****-- **--**- **---** ******- **---** **--**- *****--',s,o); {B}
   MChar(6, '--****- -**--** **----- **----- **----- -**--** --****-',s,o); {C}
   MChar(7, '*****-- **--**- **---** **---** **---** **--**- *****--',s,o); {D}
   MChar(8, '******* **----- **----- *****-- **----- **----- *******',s,o); {E}
   MChar(9, '******* **----- **----- *****-- **----- **----- **-----',s,o); {F}
   MChar(10,'--****- -**--** **----- **--*** **---** -**--** --****-',s,o); {G}
   MChar(11,'**---** **---** **---** ******* **---** **---** **---**',s,o); {H}
   MChar(12,'-*****- --***-- --***-- --***-- --***-- --***-- -*****-',s,o); {I}
   MChar(13,'-*****- ----**- ----**- ----**- ----**- -**-**- --***--',s,o); {J}
   MChar(14,'**--**- **-**-- ****--- ***---- ****--- **-**-- **--**-',s,o); {K}
   MChar(15,'**----- **----- **----- **----- **----- **----- *******',s,o); {L}
   MChar(16,'**---** **---** ***-*** ***-*** ******* ******* **-*-**',s,o); {M}
   MChar(17,'**---** **---** ***--** ****-** **-**** **--*** **---**',s,o); {N}
   MChar(18,'-*****- **---** **---** **---** **---** **---** -*****-',s,o); {O}
   MChar(19,'******- **---** **---** ******- **----- **----- **-----',s,o); {P}
   MChar(20,'-*****- **---** **---** **---** **---** **--*** -******',s,o); {Q}
   MChar(21,'******- **---** **---** ******- **-**-- **--**- *----**',s,o); {R}
   MChar(22,'-*****- **---** **----- -*****- -----** **---** -*****-',s,o); {S}
   MChar(23,'******* --***-- --***-- --***-- --***-- --***-- --***--',s,o); {T}
   MChar(24,'**---** **---** **---** **---** **---** **---** -*****-',s,o); {U}
   MChar(25,'**---** **---** -**-**- -**-**- --***-- --***-- ---*---',s,o); {V}
   MChar(26,'**---** **---** **---** **-*-** ******* ***-*** **---**',s,o); {W}
   MChar(27,'**---** -**-**- --***-- ---*--- --***-- -**-**- **---**',s,o); {X}
   MChar(28,'**---** **---** -**-**- -**-**- --***-- --***-- --***--',s,o); {Y}
   MChar(29,'******* -----** ----**- ---**-- --**--- -**---- *******',s,o); {Z}
   MChar(30,'---**-- --***-- ---**-- ---**-- ---**-- ---**-- --****-',s,o); {1}
   MChar(31,'-*****- **---** ----**- ---**-- --**--- -**---- *******',s,o); {2}
   MChar(32,'-*****- **---** -----** ----**- -----** **---** -*****-',s,o); {3}
   MChar(33,'----**- ---***- --****- -**-**- ******* ----**- ---****',s,o); {4}
   MChar(34,'******* **----- **----- ******- -----** **---** -*****-',s,o); {5}
   MChar(35,'-*****- **---** **----- ******- **---** **---** -*****-',s,o); {6}
   MChar(36,'******* -----** ----**- ---**-- --**--- -**---- -**----',s,o); {7}
   MChar(37,'-*****- **---** **---** -*****- **---** **---** -*****-',s,o); {8}
   MChar(38,'-*****- **---** **---** -****** -----** **---** -*****-',s,o); {9}
   MChar(39,'-*****- **--*** **--*** **-*-** **-*-** ***--** -*****-',s,o); {0}
   { bitmap 40: plafondpanelen }
   for y:=0 to 31 do for x:=0 to 31 do mem[s:o+x+y*32]:=9;
   for y:=1 to 30 do for x:=1 to 30 do mem[s:o+x+y*32]:=10;
   for y:=14 to 18 do for x:=14 to 18 do mem[s:o+x+y*32]:=9;
   ConvertBitmap(s,o,40);
   { bitmap 41: lampen aan het plafond }
   for y:=11 to 21 do for x:=5 to 27 do mem[s:o+x+y*32]:=12;
   for y:=12 to 20 do for x:=6 to 26 do mem[s:o+x+y*32]:=11;
   ConvertBitmap(s,o,41);
   { bitmap 42: tralies }
   for y:=0 to 31 do for x:=0 to 31 do mem[s:o+x+y*32]:=random(3)+2;
   for i:=0 to 3 do begin
      memw[s:o+(i*8)*32+15]:=0;
      meml[s:o+(i*8+1)*32+14]:=0;
      meml[s:o+(i*8+2)*32+14]:=0;
      memw[s:o+(i*8+3)*32+15]:=0;
   end;
   ConvertBitmap(s,o,42);
   { bitmap 43: deuk in muur }
   for y:=0 to 31 do for x:=0 to 31 do mem[s:o+x+y*32]:=random(3)+2;
   for y:=0 to 31 do for x:=0 to round(31*sin((y*5.625*3.14159)/180)) do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,43);
   { bitmap 44: lavastroompje (wordt naar links gescrolld) }
   c:=13;
   for y:=0 to 31 do for x:=0 to 31 do begin
      mem[s:o+x+y*32]:=c;
      if random(4)=1 then begin inc(c); if c=16 then c:=13 end;
   end;
   ConvertBitmap(s,o,44);
   { bitmap 45 contains something really special: A shrinked version
     of the last displayed screen! (didn't look so good after all) }
   { Bitmap 46: Kleine schaakbordjes }
   for y:=0 to 31 do for x:=0 to 31 do
      if (y<16) and (x<16) or (x>15) and (y>15)
         then mem[s:o+x+y*32]:=random(3)+2
         else mem[s:o+x+y*32]:=random(3)+5;
   ConvertBitmap(s,o,46);
   { wall-bitpattern }
   for y:=0 to 25 do mem[s:o+y*32]:=11;
   for y:=26 to 31 do mem[s:o+y*32]:=12;
end;

procedure ScrollLava; Assembler;
label regels,words;
asm
   mov ES,[s3]                { bitmap-segment }
   mov DI,[o3]
   add DI,44*1024
   mov AL,32
regels:
   mov CX,15
   mov DX,ES:[DI]             { eerste word opslaan }
words:
   mov BX,ES:[DI+2]
   mov ES:[DI],BX
   add DI,2
   loop words
   mov ES:[DI],DX
   add DI,2
   dec AL
   jnz regels
end;

procedure Monitor; Assembler;
label regels,words1,words2,nietnul1,nietnul2,niethalf;
asm
   mov [stacks],SS
   mov ES,[s3]
   mov DI,[o3]
   mov SS,[s4]
   add DI,45*1024+16+16*32
   mov SI,320*39+XPOS
   mov AL,32
regels:
   mov CX,16
   mov BX,SI
   add SI,320*5
words1:
   mov DL,SS:[BX]
   and DL,31
   jnz nietnul1
   mov DL,30
nietnul1:
   mov ES:[DI],DL
   inc DI
   add BX,8
   loop words1
   mov CX,16
   sub DI,32
words2:
   mov DL,SS:[BX]
   and DL,31
   jnz nietnul2
   mov DL,30
nietnul2:
   mov ES:[DI],DL
   inc DI
   add BX,(SIZE/33)
   loop words2
   add DI,32
   cmp AL,17
   jnz niethalf
   mov DI,45*1024+16
niethalf:
   dec AL
   jnz regels
   mov SS,[stacks]
end;


procedure SetPalette;
var r,g,b: array[0..31] of byte;
    a,i: byte;
begin
   { 32 kleuren kunnen gedefinieerd worden: Alle andere worden
     hieruit afgeleid (donkerder). Elk van de 32 kleuren wordt
     donkerder in de diepte, in 8 stappen.                       }

{        red:     green:      blue:     description:             }

   r[ 0]:= 0; g[ 0]:= 0; b[ 0]:= 0;     { grey-scale             }
   r[ 1]:=20; g[ 1]:=15; b[ 1]:=10;
   r[ 2]:=32; g[ 2]:=20; b[ 2]:= 0;     { vloertegel a kleur 1   }
   r[ 3]:=30; g[ 3]:=19; b[ 3]:= 0;     { vloertegel a kleur 2   }
   r[ 4]:=28; g[ 4]:=18; b[ 4]:= 0;     { vloertegel a kleur 3   }
   r[ 5]:=30; g[ 5]:=18; b[ 5]:= 0;     { vloertegel b kleur 1   }
   r[ 6]:=28; g[ 6]:=17; b[ 6]:= 0;     { vloertegel b kleur 2   }
   r[ 7]:=26; g[ 7]:=16; b[ 7]:= 0;     { vloertegel b kleur 3   }
   r[ 8]:=40; g[ 8]:=25; b[ 8]:= 0;     { rand om karakerset     }
   r[ 9]:=24; g[ 9]:=14; b[ 9]:= 0;     { plafond kleur 1        }
   r[10]:=22; g[10]:=12; b[10]:= 0;     { plafond kleur 2        }
   r[11]:=63; g[11]:=63; b[11]:=63;     { lamp kleur 1           }
   r[12]:=55; g[12]:=55; b[12]:=55;     { lamp kleur 2           }
   r[13]:=63; g[13]:=10; b[13]:=10;     { vuurstroom kleur 1     }
   r[14]:=55; g[14]:= 7; b[14]:= 7;     { vuurstroom kleur 2     }
   r[15]:=47; g[15]:= 4; b[15]:= 4;     { vuurstroom kleur 3     }
   r[16]:= 0; g[16]:= 0; b[16]:= 0;
   r[17]:= 0; g[17]:= 0; b[17]:= 0;
   r[18]:= 0; g[18]:= 0; b[18]:= 0;
   r[19]:= 0; g[19]:= 0; b[19]:= 0;
   r[20]:= 0; g[20]:= 0; b[20]:= 0;
   r[21]:= 0; g[21]:= 0; b[21]:= 0;
   r[22]:= 0; g[22]:= 0; b[22]:= 0;
   r[23]:= 0; g[23]:= 0; b[23]:= 0;
   r[24]:= 0; g[24]:= 0; b[24]:= 0;
   r[25]:= 0; g[25]:= 0; b[25]:= 0;
   r[26]:= 0; g[26]:= 0; b[26]:= 0;
   r[27]:= 0; g[27]:= 0; b[27]:= 0;
   r[28]:= 0; g[28]:= 0; b[28]:= 0;
   r[29]:= 0; g[29]:= 0; b[29]:= 0;
   r[30]:= 0; g[30]:= 0; b[30]:= 0;
   r[31]:=63; g[31]:=63; b[31]:=63;

   if (DARK=1) then for a:=0 to 7 do for i:=0 to 31 do palette(i+a*32,
                                             r[i]-((r[i]*a) div 8),
                                             g[i]-((g[i]*a) div 8),
                                             b[i]-((b[i]*a) div 8));
   if (HAZE=1) then for a:=0 to 7 do for i:=0 to 31 do palette(i+a*32,
                                         r[i]+(((63-r[i])*a) div 8),
                                         g[i]+(((63-g[i])*a) div 8),
                                         b[i]+(((63-b[i])*a) div 8));
   if (HAZE=0) and (DARK=0) then for a:=0 to 7 do for i:=0 to 31 do
                                         palette(i+a*32,r[i],g[i],b[i]);
end;

procedure MakeTransTabel(r: word);
var s,o: word;
    w,sy,x1,y1: real;
    yb,yc,y,a2,x,a3,a4: word;
    x2,y2,x3,y3: real;
    f: file;
begin
   w:=SIZE div 2;
   a4:=o1+r*560+32768;
   r:=r*2;
   for y:=0 to LINES do begin
      y1:=(((65536*500)/w)-65536*3.125)/(-4);
      yb:=round(y1/-DIST);
      yc:=round(yb div 32)*32;
      x2:=MCENTRE*65536-(cs[r]*(SIZE div 2)*65536)/w-sn[r]*y1;
      y2:=65536*64+cs[r]*y1-(sn[r]*(SIZE div 2)*65536)/w;
      memw[s1:a4+y*8]:=round(x2/128);
      memw[s1:a4+y*8+2]:=round(y2/128);
      x3:=65536*MCENTRE+cs[r]*(65536*((SIZE div 2)-1))/w-sn[r]*y1-x2;
      y3:=65536*64+cs[r]*y1+sn[r]*(65536*((SIZE div 2)-1))/w-y2;
      memw[s1:a4+y*8+4]:=round(x3/SIZE);
      memw[s1:a4+y*8+6]:=round(y3/SIZE);
      w:=w-(SIZE/145.454545);
      memw[s3:o3+y*2+65350]:=yc+yc*256;
      memw[s3:o3+y*2+64600]:=((65536 div (2*(LINES-y)+KIM))+32768) mod 65536;
   end;
end;


procedure DrawInside(xm,ym,r: integer); assembler;
label q1,q2,q3,q4,picture_q1,picture_q2,drawline_q1,drawline_q2,einde
      ,cx_q1,cy_q1,skipx_q1,skipx_q2,fillup,blkx_q1,blkx_q2
      ,cx_q2,cy_q2,cy_q3,cx_q3,blkx_q3,skipx_q3,drawline_q3,picture_q3
      ,nextx,picture_q4,cy_q4,cx_q4,blkx_q4,skipx_q4,drawline_q4,bklx_q4
      ,bar_q1,bar_q2,bar_q3,bar_q4,drawsky,drawx,clear,uitgang,update,regels
      ,bar_q11,bar_q22,bar_q33,bar_q44;


{ This version draws a floor, a ceiling and shaded walls. }
{ For other features, see previous procedure.             }

asm
    cli
    mov AX,[xm]
    mov [xp],AX
    mov AX,[ym]
    mov [yp],AX
    mov AX,[r]
    mov [stackp],SP           { store SP                  }
    mov [stacks],SS           { store SS                  }
    mov [base],BP             { store BP                  }
    mov SS,[s3]               { hoogte-tabel resetten     }
    mov BX,65350              { adres color-tabel         }
    mov [coltab],BX           { effe opslaan              }
    mov BX,64600              { adres stepsize-tabel      }
    mov [steptab],BX          { ook effe opslaan          }
    mov BX,65000
    mov CX,SIZE
    mov DL,200-LINES
fillup:
    mov SS:[BX],DL
    inc BX
    loop fillup
    mov byte ptr [hight],2*LINES+KIM
    mov ES,[s4]
    cmp AX,45                 { richting > 90?            }
    jae q2
q1:                           { rotaties van 0-89 graden  }
    mov SP,AX                 { rotatie * 560 uitrekenen  }
    mov DX,AX
    shl AX,9                  { *512                      }
    shl SP,5                  { *32                       }
    shl DX,4                  { *16   512+32+16=560       }
    add SP,AX
    add SP,DX
    add SP,32768              { adres na map-memory       }
    mov [transp],SP           { store transtabel-pointer  }
    mov BX,200*320+XPOS-2+2*SIZE
    mov [screen],BX
    mov BX,((198-2*LINES)-KIM)*320+XPOS-2+2*SIZE
    mov [screen2],BX
    mov [loop],LINES          { for loop=0 to 69          }
picture_q1:
    sub byte ptr [hight],2    { hoogteverschil scherm     }
    mov SS,[s1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,SS:[SI]            { start x-coord lijn        }
    add AX,[xp]
    mov BP,SS:[SI+2]          { start y-coord lijn        }
    add BP,[yp]
    mov DX,SS:[SI+4]          { xplus                     }
    mov DI,SS:[SI+6]          { yplus                     }
    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    add [transp],8            { alvast voor volgende lijn }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }
    mov DI,SS:[SI+16384]
    mov SI,SS:[SI]            { en haal actuele veld op   }
    shr SI,8                  { maar 1 byte graag         }
    shl SI,10
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub [screen],320+2*SIZE
    add [screen2],320-2*SIZE
    mov SS,[s3]
    mov DI,[coltab]           { haal adres colortabel     }
    mov SP,SS:[DI]            { SP bevat colsize          }
    add [coltab],2            { alvast voor volgende lijn }
    mov [inner],SIZE          { dot-counter               }
    mov [htable],64999
    mov DL,0
drawline_q1:
    add [screen],2
    add [screen2],2
    inc [htable]
    mov DI,[htable]
    cmp SS:[DI],DL
    jz  skipx_q1              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,SS:[DI+BX]
    cmp CL,DL
    jz blkx_q1                { teken muur, blokker x     }
    mov CH,CL
    add CX,SP
    sub DI,SI
    add DI,[ceiling]
    mov BL,SS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,SP                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  cx_q1
    add BP,[ydelta]
    jo  cy_q1
    dec [inner]
    jnz drawline_q1
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q1:
    add AX,[xdelta]
    jo  cx_q1
    add BP,[ydelta]
    jo  cy_q1
    dec [inner]
    jnz drawline_q1
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
blkx_q1:
    mov DI,[htable]
    mov SS:[DI],DL            { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]
    shr CX,8
    add CL,3
    mov DI,[screen]           { huidige schermadres       }
    mov BL,1
    add BX,SP
    mov BH,BL
bar_q1:
    mov ES:[DI],BX
    sub DI,320
    loop bar_q1
    add AX,[xdelta]
    jo  cx_q1
    add BP,[ydelta]
    jo  cy_q1
    dec [inner]
    jnz drawline_q1
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q1:
    inc [map]
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    add BP,[ydelta]
    jo  cy_q1
    mov SS,[s3]
    dec [inner]
    jnz drawline_q1
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q1:
    add [map],MWIDTH
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    mov SS,[s3]
    dec [inner]
    jnz drawline_q1
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q2:
    sub AX,45
    cmp AX,45
    jae q3

    mov SP,AX                 { rotatie * 560 uitrekenen  }
    mov DX,AX
    shl AX,9                  { *512                      }
    shl SP,5                  { *32                       }
    shl DX,4                  { *16   512+32+16=560       }
    add SP,AX
    add SP,DX
    add SP,32768              { adres na map-memory       }
    mov [transp],SP           { store transtabel-pointer  }
    mov BX,200*320+XPOS-2+2*SIZE
    mov [screen],BX
    mov BX,((198-2*LINES)-KIM)*320+XPOS-2+2*SIZE
    mov [screen2],BX
    mov [loop],LINES          { for loop=0 to 69          }
picture_q2:
    sub [hight],2             { hoogteverschil scherm     }
    mov SS,[s1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,[xp]
    sub AX,SS:[SI+2]          { start x-coord lijn        }
    mov BP,SS:[SI]            { start y-coord lijn        }
    add BP,[yp]
    mov DX,SS:[SI+6]          { xmin                      }
    mov DI,SS:[SI+4]          { yplus                     }
    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    add word ptr[transp],8    { alvast voor volgende lijn }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }
    mov DI,SS:[SI+16384]
    mov SI,SS:[SI]            { en haal actuele veld op   }
    shr SI,8                  { maar 1 byte graag         }
    shl SI,10
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub [screen],320+2*SIZE
    add [screen2],320-2*SIZE
    mov SS,[s3]
    mov DI,[coltab]           { haal adres colortabel     }
    mov SP,SS:[DI]            { SP bevat colsize          }
    add [coltab],2            { alvast voor volgende lijn }
    mov [inner],SIZE          { dot-counter               }
    mov [htable],64999
    mov DL,0
drawline_q2:
    add [screen],2
    add [screen2],2
    inc [htable]
    mov DI,[htable]
    cmp SS:[DI],DL
    jz  skipx_q2              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,SS:[DI+BX]
    cmp CL,DL
    jz blkx_q2                { teken muur, blokker x     }
    mov CH,CL
    add CX,SP
    sub DI,SI
    add DI,[ceiling]
    mov BL,SS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,SP                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  cx_q2
    add BP,[ydelta]
    jo  cy_q2
    dec [inner]
    jnz drawline_q2
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q2:
    sub AX,[xdelta]
    jo  cx_q2
    add BP,[ydelta]
    jo  cy_q2
    dec [inner]
    jnz drawline_q2
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
blkx_q2:
    mov DI,[htable]
    mov SS:[DI],DL            { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]
    shr CX,8
    add CL,3
    mov DI,[screen]           { huidige schermadres       }
    mov BL,1
    add BX,SP
    mov BH,BL
bar_q2:
    mov ES:[DI],BX
    sub DI,320
    loop bar_q2
    sub AX,[xdelta]
    jo  cx_q2
    add BP,[ydelta]
    jo  cy_q2
    dec [inner]
    jnz drawline_q2
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q2:
    dec [map]
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    add BP,[ydelta]
    jo  cy_q2
    mov SS,[s3]
    dec [inner]
    jnz drawline_q2
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q2:
    add [map],MWIDTH
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    mov SS,[s3]
    dec [inner]
    jnz drawline_q2
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q3:
    sub AX,45
    cmp AX,45
    jae q4

    mov SP,AX                 { rotatie * 560 uitrekenen  }
    mov DX,AX
    shl AX,9                  { *512                      }
    shl SP,5                  { *32                       }
    shl DX,4                  { *16   512+32+16=560       }
    add SP,AX
    add SP,DX
    add SP,32768              { adres na map-memory       }
    mov [transp],SP           { store transtabel-pointer  }
    mov BX,200*320+XPOS-2+2*SIZE
    mov [screen],BX
    mov BX,((198-2*LINES)-KIM)*320+XPOS-2+2*SIZE
    mov [screen2],BX
    mov [loop],LINES          { for loop=0 to 69          }
picture_q3:
    sub [hight],2             { hoogteverschil scherm     }
    mov SS,[s1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,[xp]
    sub AX,SS:[SI]            { start x-coord lijn        }
    mov BP,[yp]
    sub BP,SS:[SI+2]          { start y-coord lijn        }
    mov DX,SS:[SI+4]          { xmin                      }
    mov DI,SS:[SI+6]          { ymin                      }
    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    add word ptr[transp],8    { alvast voor volgende lijn }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }
    mov DI,SS:[SI+16384]
    mov SI,SS:[SI]            { en haal actuele veld op   }
    shr SI,8                  { maar 1 byte graag         }
    shl SI,10
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub [screen],320+2*SIZE
    add [screen2],320-2*SIZE
    mov SS,[s3]
    mov DI,[coltab]           { haal adres colortabel     }
    mov SP,SS:[DI]            { SP bevat colsize          }
    add [coltab],2            { alvast voor volgende lijn }
    mov [inner],SIZE          { dot-counter               }
    mov [htable],64999
    mov DL,0
drawline_q3:
    add [screen],2
    add [screen2],2
    inc [htable]
    mov DI,[htable]
    cmp SS:[DI],DL
    jz  skipx_q3              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,SS:[DI+BX]
    cmp CL,DL
    jz blkx_q3                { teken muur, blokker x     }
    mov CH,CL
    add CX,SP
    sub DI,SI
    add DI,[ceiling]
    mov BL,SS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,SP                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  cx_q3
    sub BP,[ydelta]
    jo  cy_q3
    dec [inner]
    jnz drawline_q3
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q3:
    sub AX,[xdelta]
    jo  cx_q3
    sub BP,[ydelta]
    jo  cy_q3
    dec [inner]
    jnz drawline_q3
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
blkx_q3:
    mov DI,[htable]
    mov SS:[DI],DL            { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]
    shr CX,8
    add CL,3
    mov DI,[screen]           { huidige schermadres       }
    mov BL,1
    add BX,SP
    mov BH,BL
bar_q3:
    mov ES:[DI],BX
    sub DI,320
    loop bar_q3
    sub AX,[xdelta]
    jo  cx_q3
    sub BP,[ydelta]
    jo  cy_q3
    dec [inner]
    jnz drawline_q3
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q3:
    dec [map]
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    sub BP,[ydelta]
    jo  cy_q3
    mov SS,[s3]
    dec [inner]
    jnz drawline_q3
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q3:
    sub [map],MWIDTH
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    mov SS,[s3]
    dec [inner]
    jnz drawline_q3
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q4:                           {rotaties van 270-360 graden}
    sub AX,45
    mov SP,AX                 { rotatie * 560 uitrekenen  }
    mov DX,AX
    shl AX,9                  { *512                      }
    shl SP,5                  { *32                       }
    shl DX,4                  { *16   512+32+16=560       }
    add SP,AX
    add SP,DX
    add SP,32768              { adres na map-memory       }
    mov [transp],SP           { store transtabel-pointer  }
    mov BX,200*320+XPOS-2+2*SIZE
    mov [screen],BX
    mov BX,((198-2*LINES)-KIM)*320+XPOS-2+2*SIZE
    mov [screen2],BX
    mov [loop],LINES          { for loop=0 to 69          }
picture_q4:
    sub [hight],2             { hoogteverschil scherm     }
    mov SS,[s1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,SS:[SI+2]          { start x-coord lijn        }
    add AX,[xp]
    mov BP,[yp]
    sub BP,SS:[SI]            { start y-coord lijn        }
    mov DX,SS:[SI+6]          { xplus                     }
    mov DI,SS:[SI+4]          { ymin                      }
    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    add word ptr[transp],8    { alvast voor volgende lijn }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }
    mov DI,SS:[SI+16384]
    mov SI,SS:[SI]            { en haal actuele veld op   }
    shr SI,8                  { maar 1 byte graag         }
    shl SI,10
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub [screen],320+2*SIZE
    add [screen2],320-2*SIZE
    mov SS,[s3]
    mov DI,[coltab]           { haal adres colortabel     }
    mov SP,SS:[DI]            { SP bevat colsize          }
    add [coltab],2            { alvast voor volgende lijn }
    mov [inner],SIZE          { dot-counter               }
    mov [htable],64999
    mov DL,0
drawline_q4:
    add [screen],2
    add [screen2],2
    inc [htable]
    mov DI,[htable]
    cmp SS:[DI],DL
    jz  skipx_q4              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,SS:[DI+BX]
    cmp CL,DL
    jz blkx_q4                { teken muur, blokker x     }
    mov CH,CL
    add CX,SP
    sub DI,SI
    add DI,[ceiling]
    mov BL,SS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,SP                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  cx_q4
    sub BP,[ydelta]
    jo  cy_q4
    dec [inner]
    jnz drawline_q4
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q4:
    add AX,[xdelta]
    jo  cx_q4
    sub BP,[ydelta]
    jo  cy_q4
    dec [inner]
    jnz drawline_q4
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
blkx_q4:
    mov DI,[htable]
    mov SS:[DI],DL            { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]
    shr CX,8
    add CL,3
    mov DI,[screen]           { huidige schermadres       }
    mov BL,1
    add BX,SP
    mov BH,BL
bar_q4:
    mov ES:[DI],BX
    sub DI,320
    loop bar_q4
    add AX,[xdelta]
    jo  cx_q4
    sub BP,[ydelta]
    jo  cy_q4
    dec [inner]
    jnz drawline_q4
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q4:
    inc [map]
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    sub BP,[ydelta]
    jo  cy_q4
    mov SS,[s3]
    dec [inner]
    jnz drawline_q4
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q4:
    sub [map],MWIDTH
    mov SS,[s1]
    mov SI,[map]
    mov DI,SI
    add DI,16384
    mov SI,SS:[SI]
    mov DI,SS:[DI]
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shr SI,8
    shl SI,10
    mov SS,[s3]
    dec [inner]
    jnz drawline_q4
    dec [loop]                { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }

einde:
    mov DI,XPOS+((199-LINES)-KIM)*320
                              { beginadres huidige x      }
    mov BP,SIZE               { loopcounter (horizontaal  }
    mov SI,65000              { adres htable              }
    mov AL,0
    mov DL,255*HAZE
    mov DH,DL
clear:
    cmp SS:[SI],AL            { staat daar een muur?      }
    jz nextx                  { ja: volgende x positie    }
    mov CX,KIM+1              { anders lijntje trekken    }
    mov BX,DI                 { haal beginadres op        }
drawx:
    mov ES:[BX],DX            { zet een byte neer         }
    add BX,320                { volgende regel            }
    loop drawx
nextx:
    add DI,2
    inc SI
    dec BP                    { volgende kolom graag      }
    jnz clear

    mov BP,XPOS+199*320
    mov DL,2*LINES+KIM
    mov AX,0A000h
    mov SS,AX
regels:
    mov CX,(SIZE)             {copieer werkscherm naar beeld}
    mov BX,BP
    sub BP,320
update:
    mov AX,ES:[BX]
    mov SS:[BX],AX
    add BX,2
    loop update
    dec DL
    jnz regels

    mov SS,[stacks]
    mov SP,[stackp]
    mov BP,[base]
    sti

end;


procedure Demo;
var x,y,r: integer;
begin
   x:=0;
   y:=0;
   r:=45;
end;

begin
    for i:=0 to 360 do begin
       sn[i]:=sin((i*3.14159)/180);
       cs[i]:=cos((i*3.14159)/180);
    end;
    DummyBitmaps(p3);                     {p3=pointer naar bitmaps}
    s3:=Seg(p3^);
    o3:=Ofs(p3^);
    DummySource(p1);                      {p1=pointer naar map-geheugen}
    s1:=Seg(p1^);
    o1:=Ofs(p1^);
    GetMem(p4,64000);                     {werkscherm}
    s4:=Seg(p4^);
    o4:=Ofs(p4^);
    for i:=0 to 15999 do meml[s4:o4+i shl 2]:=0;
    for i:=0 to 44 do MakeTransTabel(i);

    InitScreen;
    NCls(0);
    SetPalette;

    assign(f,'3dspace.wad');
    rewrite(f,1);
    BlockWrite(f,p1^,65535);
    BlockWrite(f,p3^,65535);
    close(f);

    repeat
       i:=0;
       s:=1;
       r:=90;
       repeat
          inc(i,s div 4);
          inc(s);
          DrawInside(0,-15000+i*8,r);
          ScrollLava;
       until (i>3400) or (keypressed);
       if not keypressed then begin
          repeat
             dec(i,s div 4);
             dec(s);
             DrawInside(0,-15000+i*8,r);
             ScrollLava;
             inc(r,2);
             if r=180 then r:=0;
          until (((i*8)<1000) and (r=0)) or (keypressed);
       end;
       if not keypressed then begin
          if r>90 then for s:=0 to (r-90) do DrawInside(0,-15000+i*8,r-s)
                  else for s:=r to 90 do DrawInside(0,-15000+i*8,s);
       end;
       if not keypressed then begin
          for s:=0 to (-15000+i*8) do DrawInside(0,(-15000+i*8)-s,90);
       end;
    until keypressed;
    NCls(0);
    TextMode(LastMode);
    ClrScr;
    Writeln('THE PHANTOM - INDEPENDENT CODER');
    Writeln;
    Writeln('This is the promissed update to the 3D-engine I uploaded to several');
    Writeln('BBS''es two weeks ago. This algoritm does not support backgrounds');
    Writeln('anymore, because there''s a roof, and usually you don''t look trough a');
    Writeln('ceiling, do you? Anyway, everything looks much better now, it should be');
    Writeln('slightly faster on local-bus computers (other computers have to wait for');
    Writeln('their slow videocards to draw the pictures).');
    Writeln;
    Writeln('The features of this version are:');
    Writeln('-Fully texture-mapped floors and ceilings, no limitations');
    Writeln('-Shaded and curved walls (curves not demonstrated here)');
    Writeln('-Animated tiles, look at the lava');
    Writeln('-A better animation-sequence');
    Writeln('-Source included! (call me if your syzo deleted it)');
    Writeln;
    Writeln('About the source: I would not be happy if OCEAN comes up with this great');
    Writeln('game in the summer, featuring, guess what, an all new 3D engine, so this');
    Writeln('engine may be used, but only for NON-COMMERCIAL purposes.');
    Writeln('And if you wish to release an awesome demo featuring MY 3D-engine, just');
    Writeln('show my name (THE PHANTOM) somewhere.');
    Writeln;
    Writeln('Well, this looks like the bottom of the screen, so, see you, enjoy life,');
    Writeln('call MEGAVOLT BBS, greetings from');
    Write  ('                                                          THE PHANTOM!');
    gotoxy(1,1);
    repeat
       b:=ord(readkey);
    until not(keypressed);
    repeat
    until keypressed;
    ClrScr;
    Writeln('Thanx for watching our show.');
    Writeln;
    Writeln('Don''t forget to call MEGAVOLT BBS for the latest games, a cool ratio-');
    Writeln('system, and the latest PHANTOM sources. Just DIAL:  030-211143');
    Writeln;
end.
