/**********************************/
/*  Three-dimensional CAD System  */
/*           Version 1.1          */
/*         By Mark Grocki         */
/*        Copyright (C) 1995      */
/**********************************/
/*    Compiled with QuickC 2.5    */
/*        On August 1, 1995       */
/**********************************/

/* Include header files */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <memory.h>
#include <malloc.h>
#include <graph.h>

/* This is as complex as you can make the 3D objects */

#define NUM_VERTICES 100
#define NUM_FACES 50

/* Variables */

int num_faces;
int num_vertices;
int curr_vertices;
int x_coords [NUM_VERTICES];
int y_coords [NUM_VERTICES];
int z_coords [NUM_VERTICES];
int polygons [NUM_FACES][4];
int middle [NUM_FACES];
int color [NUM_FACES];
int draw_order [NUM_FACES];
int vertices [NUM_FACES];
int sx [NUM_VERTICES];
int sy [NUM_VERTICES];
int middle_x [100];
int position [2][200];
int left_right [200];
int polyx [4], polyy [4], top_start, rho, D;
long c_table [360], s_table [360];
int theta, phi;
int tx, ty, lx, ly, fx, fy;
int x, y, z;
int x_1, y_1, x_2, y_2, x_3, y_3;
unsigned char far *image_buffer;
unsigned char far *video_buffer = (char far *)0xA0000000L;

/* Init_LR used in polygon drawing */

void Init_LR (void)
{
  int loop;
  for (loop=0; loop<200; loop++)
  {
    left_right [loop] = 0;
  }
}

/* This is the start of the polygon routine */

/* Line uses the Bresenham algorithm for calculating line points */
/* taken from "Gardens of Imagination" */
/* Modified, of course, to facilitate the polygon drawing... */

void Line (int y1, int y2, int x1, int x2)
{
  int x_diff, y_diff, x_inc=1, y_inc=1, x, y, loop, error=0, flag=1, bottom;

  x = (y1<y2) ? y1 : y2;              /* Crazy conditional notation, eh? */
  bottom = (y1<y2) ? y2 : y1;

  if (x<top_start)                    /* Top start = topmost y of polygon */
    top_start=x;
  if (x>199 || bottom<0)              /* We don't need to touch the line */
    return;                           /* if it's off the screen! */

  x_diff = x2 - x1;                   /* Bresenham stuff */
  y_diff = y2 - y1;

  if (y_diff<0)
  {
    y_diff = -y_diff;
    y_inc = -1;
  }
  if (x_diff<0)
  {
    x_diff = -x_diff;
    x_inc = -1;
  }
  else if (x_diff==0)                 /* Vertical lines */
  {                                   /* Horizontal lines are ignored in */
    x_diff = y_diff;                  /* the Polygon function */
    x_inc = 0;
  }

  x = x1;
  y = y1;

  if (x_diff>y_diff)                           /* Shallow lines */
    for (loop=0; loop<=x_diff; loop++)
    {
      if (y>=0 && y<200 && flag && y!=bottom)
      {
	position [left_right[y]][y] = x;       /* Place x in array of y's */
	left_right [y]++;                      /* we know where to begin */
	flag = 0;                              /* or end our horiz. sliver */
      }
      x+=x_inc;                   /* More Bresenham (I love this guy!) */
      error+=y_diff;
      if (error>=x_diff)
      {
	error-=x_diff;
	y+=y_inc;
	flag = 1;
      }
    }
  else
    for (loop=0; loop<=y_diff; loop++)         /* Steep lines */
    {                                          /* Basically the same stuff */
      if (y>=0 && y<200 && y!=bottom)          /* as shallow lines */
      {
	position [left_right[y]][y] = x;
	left_right [y]++;
      }
      y+=y_inc;
      error+=x_diff;
      if (error>=y_diff)
      {
	error-=y_diff;
	x+=x_inc;
      }
    }
}

/* Draw_Polygon actually draws the 'gon with many horizontal slivers */

void Draw_Polygon (int color)
{
  int start,length,pos0,pos1;
  unsigned int offset;
  register int loop;
  loop = (top_start<0) ? 0 : top_start;
  while (left_right [loop]==2 && loop<200)
  {
    pos0 = position [0][loop];              /* Get the start and end x's */
    pos1 = position [1][loop];
    length = abs(pos1-pos0)+1;
    start = (pos0<pos1) ? pos0 : pos1;      /* Or vice versa */
    if ((start+length)>=0 && start<320)
    {
      if (start<0)                          /* Clip if they're off the */
      {                                     /* screen */
	length+=start;                      /* We're assuming 320x200 */
	start = 0;
      }
      if ((start+length)>319)
	length = 320-start;
      offset = ((loop<<8)+(loop<<6))+start;
      _fmemset ((char far*)(image_buffer+offset),   /* Blast that sliver! */
	color, (unsigned int)length);
    }
    left_right [loop]=0;
    loop++;
  }
}

/* This is where it all starts.  I use globals for the actual co-ords of */
/* the polygon.  This function calls everything else. */

void Polygon (int color, int num_sides)
{
  int x1, y1, x2, y2;
  int loop;
  top_start = 200;
  x1=polyx[0];
  y1=polyy[0];
  for (loop=0; loop<num_sides-1; loop++)     /* Loop through each edge */
  {                                          /* Polygon MUST have 3 or 4 */
    x2=polyx [loop+1];                       /* edges; no more, no less */
    y2=polyy [loop+1];                       /* Must be CONVEX also */

    if (y1!=y2)                     /* If line is horizontal, ignore it */
      Line (y1, y2, x1, x2);

    x1=x2;                          /* End of first face becomes start of */
    y1=y2;                          /* the next one */
  }
  x1=x2;                            /* The last face */
  x2=polyx [0];
  y1=y2;
  y2=polyy [0];
  if (y1!=y2)
    Line (y1, y2, x1, x2);
  Draw_Polygon (color);             /* Draw it to the screen */
}

/* This is the end of the polygon routine */

/* Calculate 3D points and change to 2D screen co-ords */
/* This routine needs to be more optimized */

void Calculate (int num_verts)
{
  int loop;
  long c1,c2,s1,s2,xe,ye,ze;
  c1=c_table [theta];
  c2=c_table [phi];
  s1=s_table [theta];
  s2=s_table [phi];
  for (loop=0; loop<num_verts; loop++)
  {
    xe = (long)(x_coords[loop])*c1*c2+(long)(y_coords[loop])*s1*c2+(long)(z_coords[loop])*s2*256-(long)(rho*65536);
    ye = (long)(x_coords[loop])*s1*256-(long)(y_coords[loop])*c1*256;
    ze = (long)(x_coords[loop])*c1*s2+(long)(y_coords[loop])*s1*s2-(long)(z_coords[loop])*c2*256;
    sx[loop] = (int)(D*ye/xe+160);
    sy[loop] = (int)(100-D*ze/xe);
  }
}

/* Calc_X used for depth sorting */
/* It doesn't work for everything, but hey? */

long Calc_X (int c)
{
  long xc,c1,c2,s1,s2;
  c1=c_table [theta];
  c2=c_table [phi];
  s1=s_table [theta];
  s2=s_table [phi];
  xc = (long)(x_coords[c])*c1*c2+(long)(y_coords[c])*s1*c2+(long)(z_coords[c])*s2*256-(long)(rho*65536);
  return xc;
}

/* Crap sort algorithm */
/* I tried using Quicksort, but something was wrong with the recursion */

void Selection_Sort (int limit)
{
  int top, search, temp;
  for (top=0; top<limit-1; top++)
    for (search=top+1; search<limit; search++)
      if (Calc_X(middle[draw_order[search]])<Calc_X(middle[draw_order[top]]))
      {
	temp = draw_order [search];
	draw_order [search]=draw_order [top];
	draw_order [top]=temp;
      }
}

/* Cosine and sine tables for those nice "quick" calculations */

void Init_Tables ()
{
  int loop;
  for (loop=0; loop<360; loop++)
  {
    c_table[loop]=cos((float)loop/57.29)*256;
    s_table[loop]=sin((float)loop/57.29)*256;
  }
}

void Instructions (void)
{
  _settextcolor (15);
  _settextposition (0,0);
  printf ("3-Dimensional Computer-Aided Design System\n\n");
  printf ("By Mark Grocki\n");
  printf ("Copyright (C) 1995\n");
  printf ("Applied Graphics Technologies\n");
  _settextposition (10,0);
  printf ("   Use <I,J,K,L> to change X and Y co-ordinates, and use\n");
  printf ("<E,D> to change z co-ordinate.  Press <P> to draw a line\n");
  printf ("or position a point.  Put a point at beginning of polygon\n");
  printf ("to end it.  Press <Q> to quit and save the 3-D model.\n");
  printf ("\nNOTE:  MAKE SURE the polygon is CONVEX and that it has THREE\n");
  printf ("or FOUR vertices!  Otherwise, the drawing routines will crash!\n");
  _settextposition (24,0);
  printf ("Press a key to begin...");
  getch();
}

void Init_CAD_Screen (void)
{
  _clearscreen (0);
  _setcolor (1);
  _moveto (20,20);
  _lineto (400,20);
  _lineto (400,220);
  _lineto (20,220);
  _lineto (20,20);
  _moveto (20,240);
  _lineto (400,240);
  _lineto (400,400);
  _lineto (20,400);
  _lineto (20,240);
  _moveto (420,240);
  _lineto (620,240);
  _lineto (620,400);
  _lineto (420,400);
  _lineto (420,240);
  tx = 210;
  lx = tx;
  ty = 120;
  ly = 320;
  fy = ly;
  fx = 520;
  x = 0;
  y = 0;
  z = 0;
  num_faces = 0;
  num_vertices = 0;
}

/* The heart of the CAD program is below.  I won't even begin to describe */
/* it, I've written this part so long ago.  BTW, make sure you follow the */
/* rules for making the polygons:  the program isn't too forgiving if you */
/* mess up. */

void Place_Point (void)
{
  int colr, loop;
  int xt, yt, zt;
  _setcolor (15);
  if (curr_vertices==0)
  {
    _setpixel (tx, ty);
    _setpixel (lx, ly);
    _setpixel (fx, fy);
    if (num_vertices==0)
    {
      x_coords[0] = x;
      y_coords[0] = y;
      z_coords[0] = z;
      polygons[0][0] = 0;
      curr_vertices++;
      goto label;
    }
    goto label2;
  }
  if ((x==x_coords[polygons[num_faces][0]]) && (y==y_coords[polygons[num_faces][0]])
    && (z==z_coords[polygons[num_faces][0]]))
    {
      _moveto (x_1, y_1);
      _lineto (tx, ty);
      _moveto (x_2, y_2);
      _lineto (lx, ly);
      _moveto (x_3, y_3);
      _lineto (fx, fy);
      _settextposition (29,0);
      printf ("                              ");
      _settextposition (27,0);
      printf ("End of polygon %d with %d co-ordinates.   \n", num_faces+1, curr_vertices);
      _settextposition (28,0);
      printf ("                                                      ");
      _settextposition (28,0);
      printf ("Please enter color for this polygon: ");
      scanf ("%d", &colr);
      color [num_faces] = colr;
      xt = 0;
      yt = 0;
      zt = 0;
      for (loop=0; loop<=curr_vertices; loop++)
      {
	xt+=x_coords[polygons[num_faces][loop]];
	yt+=y_coords[polygons[num_faces][loop]];
	zt+=z_coords[polygons[num_faces][loop]];
      }
      num_vertices++;
      vertices [num_faces] = curr_vertices;
      x_coords [num_vertices] = xt/(curr_vertices);
      y_coords [num_vertices] = yt/(curr_vertices);
      z_coords [num_vertices] = zt/(curr_vertices);
      middle [num_faces] = num_vertices;
      num_faces++;
      curr_vertices = 0;
    }
  else
label2 : {
if (curr_vertices!=0)
    {
      _moveto (x_1, y_1);
      _lineto (tx, ty);
      _moveto (x_2, y_2);
      _lineto (lx, ly);
      _moveto (x_3, y_3);
      _lineto (fx, fy);
    }
    if ((num_vertices>0) || (curr_vertices>0))
    {
      for (loop=0; loop<=num_vertices; loop++)
	if ((x==x_coords[loop]) && (y==y_coords[loop]) && (z==z_coords[loop]))
	{
	  polygons [num_faces][curr_vertices] = loop;
	  curr_vertices++;
	  goto label;
	}
      num_vertices++;
    }
    x_coords [num_vertices] = x;
    y_coords [num_vertices] = y;
    z_coords [num_vertices] = z;
    polygons [num_faces][curr_vertices] = num_vertices;
    curr_vertices++;
label : x_1 = tx;
    y_1 = ty;
    x_2 = lx;
    y_2 = ly;
    x_3 = fx;
    y_3 = fy;
  }
}

void Get_Input (void)
{
  int under1=0, under2=0, under3=0;
  int loop, done=0;
  curr_vertices = 0;
  x_1 = tx;
  y_1 = ty;
  x_2 = lx;
  y_2 = ly;
  x_3 = fx;
  y_3 = fy;
  while (!done)
  {
    _setcolor (under1);
    _setpixel (tx, ty);
    _setcolor (under2);
    _setpixel (lx, ly);
    _setcolor (under3);
    _setpixel (fx, fy);
    if (kbhit())
    {
      switch (getch())
      {
	case 'j':
	{
	  tx = tx - (10*(tx>30));
	  x = x - (x>-18);
	  lx = tx;
	}
	break;
	case 'l':
	{
	  tx = tx + (10*(tx<390));
	  x = x + (x<18);
	  lx = tx;
	}
	break;
	case 'i':
	{
	  ty = ty - (10*(ty>30));
	  y = y + (y<9);
	  fx = fx - (10*(fx>430));
	}
	break;
	case 'k':
	{
	  ty = ty + (10*(ty<210));
	  y = y - (y>-9);
	  fx = fx + (10*(fx<610));
	}
	break;
	case 'e':
	{
	  ly = ly - (10*(ly>250));
	  z = z + (z<7);
	  fy = ly;
	}
	break;
	case 'd':
	{
	  ly = ly + (10*(ly<390));
	  z = z - (z>-7);
	  fy = ly;
	}
	break;
	case 'p':
	  Place_Point ();
	break;
	case 'q':
	  done = 1;
	break;
      }
    }
    under1 = _getpixel (tx, ty);
    under2 = _getpixel (lx, ly);
    under3 = _getpixel (fx, fy);
    if (under1==15)
      _setcolor (2);
    else
      _setcolor (15);
    _setpixel (tx, ty);
    _setpixel (lx, ly);
    _setpixel (fx, fy);
    _settextcolor (15);
    _settextposition (27,0);
    printf ("X:  %d                                            \n", x);
    printf ("Y:  %d                                            \n", y);
    printf ("Z:  %d                                            \n", z);
  }
  num_faces--;
  for (loop=0; loop<=num_faces; loop++)
    draw_order [loop] = loop;
}

void Save_3D ()
{
  char *filename;
  int loop, loop2;
  FILE *fp;
  _settextposition (27,0);
  printf ("                \n");
  printf ("                \n");
  printf ("                \n");
  _settextposition (27,0);
  printf ("Please enter 3D object filename (with .3D extension): ");
  scanf ("%s", filename);
  printf ("\n");
  fp = fopen (filename, "w");
  fprintf (fp, "%d\r\n", num_vertices);
  fprintf (fp, "%d\r\n", num_faces);
  for (loop=0; loop<=num_vertices; loop++)
  {
    fprintf (fp, "%d\r\n", x_coords[loop]);
    fprintf (fp, "%d\r\n", y_coords[loop]);
    fprintf (fp, "%d\r\n", z_coords[loop]);
  }
  for (loop=0; loop<=num_faces; loop++)
  {
    fprintf (fp, "%d\r\n", vertices[loop]);
    for (loop2=0; loop2<vertices[loop]; loop2++)
      fprintf (fp, "%d\r\n", polygons[loop][loop2]);
    fprintf (fp, "%d\r\n", middle[loop]);
    fprintf (fp, "%d\r\n", color[loop]);
  }
  fclose (fp);
}

void main (void)
{
  int loop, loop2, angle_inc;
  Init_LR ();
  Init_Tables ();

  _setvideomode (_VRES16COLOR);
  Instructions ();
  Init_CAD_Screen ();
  Get_Input ();
  Save_3D ();

  _setvideomode (_MRES256COLOR);
  image_buffer = (char far*)_fmalloc ((unsigned int)64000);
  _fmemset ((char far *)image_buffer, 1, (unsigned int)64000);
  _settextposition (0,0);

  /* Now see a nice demo of your new 3D object! */

  printf ("Now see your 3-D model in action!\n\n");
  printf ("Please enter rho (40 is good): ");
  scanf ("%d", &rho);
  printf ("\nPlease enter angle increment: ");
  scanf ("%d", &angle_inc);
  theta=0;
  phi=25;
  D=250;

  while (!kbhit())
  {
    _fmemset ((char far*)image_buffer, 0, (unsigned int)64000);

    Calculate (num_vertices+1);
    Selection_Sort (num_faces+1);

    for (loop=0; loop<=num_faces; loop++)
    {
      for (loop2=0; loop2<vertices[draw_order[loop]]; loop2++)
      {
	polyx[loop2]=sx[polygons[draw_order[loop]][loop2]];
	polyy[loop2]=sy[polygons[draw_order[loop]][loop2]];
      }
      Polygon (color[draw_order[loop]], vertices[draw_order[loop]]);
    }
    theta+=angle_inc;
    if (theta>=360)
    {
      theta-=360;
    }
    _fmemcpy ((char far*)video_buffer, (char far*)image_buffer,
      (unsigned int)64000);
  }
  getch();
  _setvideomode (_DEFAULTMODE);
}
