/**********************************/
/*         3-D Object Demo        */
/*           Version 1.5          */
/*         By Mark Grocki         */
/*        Copyright (C) 1995      */
/**********************************/
/*    Compiled with QuickC 2.5    */
/*        On August 1, 1995       */
/**********************************/

/* Include header files */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <math.h>
#include <conio.h>
#include <malloc.h>
#include <graph.h>

/* Movement key constants */

#define FWD 72
#define BACK 80
#define LEFT 75
#define CENTER 76
#define RIGHT 77
#define PAGEUP 73
#define PAGEDN 81
#define FIRE 57
#define QUIT 16

#define BREAK_FWD 200
#define BREAK_BACK 208
#define BREAK_LEFT 203
#define BREAK_CENTER 204
#define BREAK_RIGHT 205
#define BREAK_PUP 209
#define BREAK_PDN 201
#define BREAK_FIRE 185

/* Keyboard interrupt constants */

#define KEYBOARD_INT 0x09
#define KEY_BUFFER 0x60
#define KEY_CONTROL 0x61
#define INT_CONTROL 0x20

/* Vertical sync constants */

#define VGA_INPUT_STATUS 0x3DA
#define VGA_VSYNC_MASK 0x08

/* 3-D object array constants */

#define NUM_VERTICES 150
#define NUM_FACES 70

/* Declare variables */

int num_faces;
int num_vertices;
int x_coords [NUM_VERTICES];
int y_coords [NUM_VERTICES];
int z_coords [NUM_VERTICES];
int polygons [NUM_FACES][4];
int middle [NUM_FACES];
int color [NUM_FACES];
int vertices [NUM_FACES];
int draw_order [NUM_FACES];
int sx [NUM_VERTICES];
int sy [NUM_VERTICES];
int position [2][200];
int left_right [200];
int polyx [4], polyy [4], top_start, rho, D;
long c_table [360], s_table [360];
int theta, phi, done=0, raw_key;
int thetav=0, phiv=0, rhov=0;
void (_interrupt _far *Old_Key_Isr)();
unsigned char far *image_buffer;
unsigned char far *video_buffer = (char far *)0xA0000000L;

void Wait_For_Vsync (void)
{
  while (inp(VGA_INPUT_STATUS) & VGA_VSYNC_MASK)
  {
  }
  while (!(inp(VGA_INPUT_STATUS) & VGA_VSYNC_MASK))
  {
  }
}

void _interrupt _far New_Key_Int(void)
{
_asm
  {
    sti
    in al, KEY_BUFFER
    xor ah,ah
    mov raw_key, ax
    in al, KEY_CONTROL
    or al, 82h
    out KEY_CONTROL,al
    and al,7fh
    out KEY_CONTROL,al
    mov al,20h
    out INT_CONTROL,al
  }
  switch(raw_key)
  {
    case FWD : phiv=-1;
    break;
    case BACK :  phiv=1;
    break;
    case RIGHT : thetav=1;
    break;
    case LEFT : thetav=-1;
    break;
    case PAGEUP : rhov=-1;
    break;
    case PAGEDN : rhov=1;
    break;
    case QUIT : done = 1;
    break;
    case FIRE : {}
    break;
    case BREAK_FWD : phiv=0;
    break;
    case BREAK_BACK : phiv=0;
    break;
    case BREAK_RIGHT : thetav=0;
    break;
    case BREAK_LEFT : thetav=0;
    break;
    case BREAK_PUP : rhov=0;
    break;
    case BREAK_PDN : rhov=0;
    break;
    case BREAK_FIRE : {}
    break;
  }
}

/* Init_LR used in polygon drawing */

void Init_LR (void)
{
  int loop;
  for (loop=0; loop<200; loop++)
  {
    left_right [loop] = 0;
  }
}

/* This is the start of the polygon routine */

/* Line uses the Bresenham algorithm for calculating line points */
/* taken from "Gardens of Imagination" */
/* Modified, of course, to facilitate the polygon drawing... */

void Line (int y1, int y2, int x1, int x2)
{
  int x_diff, y_diff, x_inc=1, y_inc=1, x, y, loop, error=0, flag=1, bottom;

  x = (y1<y2) ? y1 : y2;              /* Crazy conditional notation, eh? */
  bottom = (y1<y2) ? y2 : y1;

  if (x<top_start)                    /* Top start = topmost y of polygon */
    top_start=x;
  if (x>199 || bottom<0)              /* We don't need to touch the line */
    return;                           /* if it's off the screen! */

  x_diff = x2 - x1;                   /* Bresenham stuff */
  y_diff = y2 - y1;

  if (y_diff<0)
  {
    y_diff = -y_diff;
    y_inc = -1;
  }
  if (x_diff<0)
  {
    x_diff = -x_diff;
    x_inc = -1;
  }
  else if (x_diff==0)                 /* Vertical lines */
  {                                   /* Horizontal lines are ignored in */
    x_diff = y_diff;                  /* the Polygon function */
    x_inc = 0;
  }

  x = x1;
  y = y1;

  if (x_diff>y_diff)                           /* Shallow lines */
    for (loop=0; loop<=x_diff; loop++)
    {
      if (y>=0 && y<200 && flag && y!=bottom)
      {
	position [left_right[y]][y] = x;       /* Place x in array of y's */
	left_right [y]++;                      /* we know where to begin */
	flag = 0;                              /* or end our horiz. sliver */
      }
      x+=x_inc;                   /* More Bresenham (I love this guy!) */
      error+=y_diff;
      if (error>=x_diff)
      {
	error-=x_diff;
	y+=y_inc;
	flag = 1;
      }
    }
  else
    for (loop=0; loop<=y_diff; loop++)         /* Steep lines */
    {                                          /* Basically the same stuff */
      if (y>=0 && y<200 && y!=bottom)          /* as shallow lines */
      {
	position [left_right[y]][y] = x;
	left_right [y]++;
      }
      y+=y_inc;
      error+=x_diff;
      if (error>=y_diff)
      {
	error-=y_diff;
	x+=x_inc;
      }
    }
}

/* Draw_Polygon actually draws the 'gon with many horizontal slivers */

void Draw_Polygon (int color)
{
  int start,length,pos0,pos1;
  unsigned int offset;
  register int loop;
  loop = (top_start<0) ? 0 : top_start;
  while (left_right [loop]==2 && loop<200)
  {
    pos0 = position [0][loop];              /* Get the start and end x's */
    pos1 = position [1][loop];
    length = abs(pos1-pos0)+1;
    start = (pos0<pos1) ? pos0 : pos1;      /* Or vice versa */
    if ((start+length)>=0 && start<320)
    {
      if (start<0)                          /* Clip if they're off the */
      {                                     /* screen */
	length+=start;                      /* We're assuming 320x200 */
	start = 0;
      }
      if ((start+length)>319)
	length = 320-start;
      offset = ((loop<<8)+(loop<<6))+start;
      _fmemset ((char far*)(image_buffer+offset),   /* Blast that sliver! */
	color, (unsigned int)length);
    }
    left_right [loop]=0;
    loop++;
  }
}

/* This is where it all starts.  I use globals for the actual co-ords of */
/* the polygon.  This function calls everything else. */

void Polygon (int color, int num_sides)
{
  int x1, y1, x2, y2;
  int loop;
  top_start = 200;
  x1=polyx[0];
  y1=polyy[0];
  for (loop=0; loop<num_sides-1; loop++)     /* Loop through each edge */
  {                                          /* Polygon MUST have 3 or 4 */
    x2=polyx [loop+1];                       /* edges; no more, no less */
    y2=polyy [loop+1];                       /* Must be CONVEX also */

    if (y1!=y2)                     /* If line is horizontal, ignore it */
      Line (y1, y2, x1, x2);

    x1=x2;                          /* End of first face becomes start of */
    y1=y2;                          /* the next one */
  }
  x1=x2;                            /* The last face */
  x2=polyx [0];
  y1=y2;
  y2=polyy [0];
  if (y1!=y2)
    Line (y1, y2, x1, x2);
  Draw_Polygon (color);             /* Draw it to the screen */
}

/* This is the end of the polygon routine */

/* Calculate 3D points and change to 2D screen co-ords */
/* This routine needs to be more optimized */

void Calculate (int num_verts)
{
  int loop;
  long c1,c2,s1,s2,xe,ye,ze;
  c1=c_table [theta];
  c2=c_table [phi];
  s1=s_table [theta];
  s2=s_table [phi];
  for (loop=0; loop<num_verts; loop++)
  {
    xe = (long)(x_coords[loop])*c1*c2+
      (long)(y_coords[loop])*s1*c2+
      (long)(z_coords[loop])*s2*256-(long)(rho*65536);
    ye = (long)(x_coords[loop])*s1*256-
      (long)(y_coords[loop])*c1*256;
    ze = (long)(x_coords[loop])*c1*s2+
      (long)(y_coords[loop])*s1*s2-
      (long)(z_coords[loop])*c2*256;
    sx[loop] = (int)(D*ye/xe+160);
    sy[loop] = (int)(100-D*ze/xe);
  }
}

/* Calc_X used for depth sorting */
/* It doesn't work for everything, but hey? */

long Calc_X (int c)
{
  long xc,c1,c2,s1,s2;
  c1=c_table [theta];
  c2=c_table [phi];
  s1=s_table [theta];
  s2=s_table [phi];
  xc = (long)(x_coords[c])*c1*c2+(long)(y_coords[c])
    *s1*c2+(long)(z_coords[c])*s2*256-(long)(rho*65536);
  return xc;
}

/* Crap sort algorithm */
/* I tried using Quicksort, but something was wrong with the recursion */

void Selection_Sort (int limit)
{
  int top, search, temp;
  for (top=0; top<limit-1; top++)
    for (search=top+1; search<limit; search++)
      if (Calc_X(middle[draw_order[search]])
	< Calc_X(middle[draw_order[top]]))
      {
	temp = draw_order [search];
	draw_order [search]=draw_order [top];
	draw_order [top]=temp;
      }
}

/* Cosine and sine tables for those nice "quick" calculations */

void Init_Tables ()
{
  int loop;
  for (loop=0; loop<360; loop++)
  {
    c_table[loop]=cos((float)loop/57.29)*256;
    s_table[loop]=sin((float)loop/57.29)*256;
  }
}

/* Load the 3D file of your choice */

void Load_3D (char *filename)
{
  int loop, loop2;
  FILE *fp;
  fp = fopen (filename, "r");
  fscanf (fp, "%d", &num_vertices);
  fscanf (fp, "%d", &num_faces);
  for (loop=0; loop<=num_vertices; loop++)
  {
    fscanf (fp, "%d", &x_coords [loop]);
    fscanf (fp, "%d", &y_coords [loop]);
    fscanf (fp, "%d", &z_coords [loop]);
  }
  for (loop=0; loop<=num_faces; loop++)
  {
    fscanf (fp, "%d", &vertices[loop]);
    for (loop2=0; loop2<vertices[loop]; loop2++)
      fscanf (fp, "%d", &polygons[loop][loop2]);
    fscanf (fp, "%d", &middle[loop]);
    fscanf (fp, "%d", &color[loop]);
  }
  fclose (fp);
  for (loop=0; loop<NUM_FACES; loop++)
    draw_order [loop] = loop;
}

void main (void)
{
  char filename [11];
  int loop, loop2, angle_inc;
  _clearscreen (0);
  Init_LR ();
  Init_Tables ();
  printf ("   CONTROLS\n\n");
  printf (" L/R arrows: Rotate by Z-axis\n");
  printf (" U/D arrows: Rotate by Y-axis\n");
  printf (" PGUP/PGDN : Change rho (distance)\n");
  printf (" Q         : Quit\n");
  printf ("\n");
  system ("DIR *.3D");
  printf ("\nEnter 3D filename: ");
  scanf ("%s", filename);
  printf ("\n");
  Load_3D (filename);

  _setvideomode (_MRES256COLOR);
  image_buffer = (char far*)_fmalloc ((unsigned int)64000);
  _fmemset ((char far *)image_buffer, 0, (unsigned int)64000);
  theta=0;
  phi=0;
  D=250;
  rho=30;
  Old_Key_Isr = _dos_getvect (KEYBOARD_INT);
  _dos_setvect (KEYBOARD_INT, New_Key_Int);

  while (!done)
  {
    _fmemset ((char far*)image_buffer, 0, (unsigned int)64000);
    Calculate (num_vertices+1);
    Selection_Sort (num_faces+1);
    for (loop=0; loop<=num_faces; loop++)
    {
      for (loop2=0; loop2<vertices[draw_order[loop]]; loop2++)
      {
	polyx[loop2]=sx[polygons[draw_order[loop]][loop2]];
	polyy[loop2]=sy[polygons[draw_order[loop]][loop2]];
      }
      Polygon (color[draw_order[loop]],
	vertices[draw_order[loop]]);
    }
    Wait_For_Vsync ();
    _fmemcpy ((char far*)video_buffer, (char far*)image_buffer,
      (unsigned int)64000);

    theta+=thetav;
    phi+=phiv;
    rho+=rhov;

    if (theta<0) theta = 359;
    if (theta>359) theta = 0;
    if (phi<0) phi = 359;
    if (phi>359) phi = 0;
    if (rho<15) rho = 15;
    if (rho>200) rho = 200;
  }
  _setvideomode (_DEFAULTMODE);
  _dos_setvect (KEYBOARD_INT, Old_Key_Isr);
}
