/**********************************/
/*         Polygon engine         */
/*           Version 1.5          */
/*         By Mark Grocki         */
/*        Copyright (C) 1995      */
/**********************************/
/*      NOT stand alone code      */
/**********************************/

int position [2][200];
int left_right [200];
int polyx [4], polyy [4]; /* <----- x and y co-ords of vertices are here */
int color;
int num_edges;
int top_start;            /* Topmost y of polygon */

/**********************************/
/* The polygon code will draw any */
/* 3- or 4-sided CONVEX flat      */
/* polygon.                       */
/* Sample execute:                */
/*                                */
/* Polygon (color, num_edges);    */
/**********************************/

/* Init_LR used in polygon drawing */
/* Must be called before ANY polygon drawing is to be done! */

void Init_LR (void)
{
  int loop;
  for (loop=0; loop<200; loop++)
  {
    left_right [loop] = 0;
  }
}

/* This is the start of the polygon routine */

/* Line uses the Bresenham algorithm for calculating line points */
/* taken from "Gardens of Imagination" */
/* Modified, of course, to facilitate the polygon drawing... */

void Line (int y1, int y2, int x1, int x2)
{
  int x_diff, y_diff, x_inc=1, y_inc=1, x, y, loop, error=0, flag=1, bottom;

  x = (y1<y2) ? y1 : y2;              /* Crazy conditional notation, eh? */
  bottom = (y1<y2) ? y2 : y1;

  if (x<top_start)                    /* Top start = topmost y of polygon */
    top_start=x;
  if (x>199 || bottom<0)              /* We don't need to touch the line */
    return;                           /* if it's off the screen! */

  x_diff = x2 - x1;                   /* Bresenham stuff */
  y_diff = y2 - y1;

  if (y_diff<0)
  {
    y_diff = -y_diff;
    y_inc = -1;
  }
  if (x_diff<0)
  {
    x_diff = -x_diff;
    x_inc = -1;
  }
  else if (x_diff==0)                 /* Vertical lines */
  {                                   /* Horizontal lines are ignored in */
    x_diff = y_diff;                  /* the Polygon function */
    x_inc = 0;
  }

  x = x1;
  y = y1;

  if (x_diff>y_diff)                           /* Shallow lines */
    for (loop=0; loop<=x_diff; loop++)
    {
      if (y>=0 && y<200 && flag && y!=bottom)
      {
	position [left_right[y]][y] = x;       /* Place x in array of y's */
	left_right [y]++;                      /* we know where to begin */
	flag = 0;                              /* or end our horiz. sliver */
      }
      x+=x_inc;                   /* More Bresenham (I love this guy!) */
      error+=y_diff;
      if (error>=x_diff)
      {
	error-=x_diff;
	y+=y_inc;
	flag = 1;
      }
    }
  else
    for (loop=0; loop<=y_diff; loop++)         /* Steep lines */
    {                                          /* Basically the same stuff */
      if (y>=0 && y<200 && y!=bottom)          /* as shallow lines */
      {
	position [left_right[y]][y] = x;
	left_right [y]++;
      }
      y+=y_inc;
      error+=x_diff;
      if (error>=y_diff)
      {
	error-=y_diff;
	x+=x_inc;
      }
    }
}

/* Draw_Polygon actually draws the 'gon with many horizontal slivers */

void Draw_Polygon (int color)
{
  int start,length,pos0,pos1;
  unsigned int offset;
  register int loop;
  loop = (top_start<0) ? 0 : top_start;
  while (left_right [loop]==2 && loop<200)
  {
    pos0 = position [0][loop];              /* Get the start and end x's */
    pos1 = position [1][loop];
    length = abs(pos1-pos0)+1;
    start = (pos0<pos1) ? pos0 : pos1;      /* Or vice versa */
    if ((start+length)>=0 && start<320)
    {
      if (start<0)                          /* Clip if they're off the */
      {                                     /* screen */
	length+=start;                      /* We're assuming 320x200 */
	start = 0;
      }
      if ((start+length)>319)
	length = 320-start;
      offset = ((loop<<8)+(loop<<6))+start;
      _fmemset ((char far*)(image_buffer+offset),   /* Blast that sliver! */
	color, (unsigned int)length);
    }
    left_right [loop]=0;
    loop++;
  }
}

/* This is where it all starts.  I use globals for the actual co-ords of */
/* the polygon.  This function calls everything else. */

void Polygon (int color, int num_sides)
{
  int x1, y1, x2, y2;
  int loop;
  top_start = 200;
  x1=polyx[0];
  y1=polyy[0];
  for (loop=0; loop<num_sides-1; loop++)     /* Loop through each edge */
  {                                          /* Polygon MUST have 3 or 4 */
    x2=polyx [loop+1];                       /* edges; no more, no less */
    y2=polyy [loop+1];                       /* Must be CONVEX also */

    if (y1!=y2)                     /* If line is horizontal, ignore it */
      Line (y1, y2, x1, x2);        

    x1=x2;                          /* End of first face becomes start of */
    y1=y2;                          /* the next one */
  }
  x1=x2;                            /* The last face */
  x2=polyx [0];
  y1=y2;
  y2=polyy [0];
  if (y1!=y2)
    Line (y1, y2, x1, x2);
  Draw_Polygon (color);             /* Draw it to the screen */
}

/* This is the end of the polygon routine */

