
; wg3dmat.asm
;
; Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

; Functions
PUBLIC _FLPMultMatrix_

.DATA

.CODE
.486

; _FLPMultMatrix_ ( G3DMATRIX Mat1, G3DMATRIX Mat2, G3DMATRIX Result )
;
; EAX = Mat1, EDX = Mat2, EBX = Result

_FLPMultMatrix_ PROC C
  push ECX
  push ESI
  push EDI

  mov  ECX, 4

  MatrixLoopOut :
    mov  ESI, 4
    mov  EDI, EDX
    MatrixLoopIn :
      fld  dword ptr [EAX]
      fmul dword ptr [EDX]
      fld  dword ptr [EAX+1*4]
      fmul dword ptr [EDX+4*4]
      fld  dword ptr [EAX+2*4]
      fmul dword ptr [EDX+8*4]
      fld  dword ptr [EAX+3*4]
      fmul dword ptr [EDX+12*4]
      faddp st(1), st
      faddp st(1), st
      faddp st(1), st
      add  EDX, 4
      add  EBX, 4
      fstp  dword ptr [EBX-4]
      dec  ESI
      jnz  MatrixLoopIn

    mov  EDX, EDI
    add  EAX, 4*4
    Loop MatrixLoopOut
  pop  EDI 
  pop  ESI
  pop  ECX
  ret
_FLPMultMatrix_ ENDP

END
