
// gfxerror.h
//
// Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

#ifndef __GFXERROR_H__
#define __GFXERROR_H__

#include "stdgfx.h"
#include "gfxsys.h"

#define ERR_TYPE LONG

// Common Error Type
#define ERR_NOERROR   0
#define ERR_UNKNOWN   1
#define ERR_NOMEMORY  2   // Not enough memory
#define ERR_NOEXIST   3   // Not exist ( files, token, ... )
#define ERR_NOVALID   4   // Not valid ( names, number, ... )
#define ERR_FILEIO    5   // File I/O error
#define ERR_USER      6   // User defined error type starts here

class ERRORHANDLER : public SYSTEMTOOL
  {
    protected :
      ERR_TYPE LastError;

    public :
      ERRORHANDLER ();
      virtual ~ERRORHANDLER ();

      void SetError ( ERR_TYPE Err );
      ERR_TYPE GetError ();
  }; // End of ERRORHANDLER

extern ERRORHANDLER Error;

#endif


