
; wvga256.asm
;
; Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

PUBLIC SetVGASelector_, VGACopy256To256_

.DATA
  SrcWd DD 0
  SrcHt DD 0

.CODE
.386

; VOID SetVGASelector ( SHORT Selector )
; EAX = Selector

SetVGASelector_ PROC
  ret 
SetVGASelector_ ENDP


; VOID VGACopy256To256 ( BYTE *Src, LONG AddSrc, LONG SrcWd, LONg SrcHt,
;                        LONG DestCx, LONG DestCy );
;
; EAX = Src, EDX = AddSrc, EBX = SrcWd, ECX = SrcHt
VGACopy256To256_ PROC C, DestCx:DWORD,DestCy:DWORD
  push EDI
  push ESI

  mov  ESI, EAX   ; ESI = Src
  mov  SrcWd, EBX
  mov  SrcHt, ECX
  
  sub  EDX, EBX
  mov  EBX, EDX   ; EBX = AddSrc - SrcWd

  mov  EDI, 0A0000h
  mov  EAX, DestCy
  mov  EDX, 320
  mul  EDX  
  add  EAX, DestCx
  add  EDI, EAX
  
  mov  EDX, 320
  sub  EDX, SrcWd
  cld

  Copy256OutLoop :
    mov ECX, SrcWd
    mov EAX, ECX
    and EAX, 03h
    shr ECX, 2
    rep movsd
    mov ECX, EAX
    rep movsb
    add ESI, EBX
    add EDI, EDX
    dec SrcHt
    jnz Copy256OutLoop

  pop  ESI
  pop  EDI
  ret
VGACopy256To256_ ENDP

END
