
// dlgs.cpp

#include "stdgfx.h"
#include "dlgs.h"

//***********************************
//
// Fog Dialog
//
//***********************************

#define FOG_ONOFF  101
#define FOG_SCALE  102
#define FOG_OK     IDOK
#define FOG_CANCEL IDCANCEL
#define FOG_HELP   998

static BOOLEAN FogOnOff = FALSE;
static float FogScale = (float)100; 

FOGDLG::FOGDLG () : GUIDIALOG ()
  {
  } // End of Constructor for FOGDLG
  
FOGDLG::~FOGDLG ()
  {
  } // End of Destructor for FOGDLG
  
LONG FOGDLG::OnInitDialog ()
  {
    SetButtonState ( FOG_SCALE, FogOnOff );
    
    CHAR Str[128];
    sprintf ( Str, "%4.2f", FogScale );
    SetItemText ( FOG_SCALE, Str );
    return 0;
  } // End of OnInitDialog for FOGDLG

LONG FOGDLG::OnCommand ( LONG Command )
  {
    CHAR Str[128];
     
    switch (Command)
      {        
        case FOG_OK :
          FogOnOff = GetButtonState ( FOG_ONOFF );
          GetItemText ( FOG_SCALE, Str );
          FogScale = (float)atof ( Str );
          ReturnValue = TRUE;
          CloseWindow ();
          break;
        case FOG_CANCEL :
          ReturnValue = FALSE;
          CloseWindow ();
          break;  
      } // End switch
    return 0; 
  } // End of OnCommand for FOGDLG
  
BOOLEAN FOGDLG::IsFogOn ()
  {
    return FogOnOff;
  } // End of IsFogOn for FOGDLG

float FOGDLG::GetFogScale ()
  {
    return FogScale;
  } // End of GetFogScale for FOGDLG
  
//***********************************
//
// Depth Cue Dialog
//
//***********************************

#define DEPTH_ONOFF  101
#define DEPTH_SCALE  102
#define DEPTH_OK     IDOK
#define DEPTH_CANCEL IDCANCEL
#define DEPTH_HELP   998

static BOOLEAN DepthCueOnOff = FALSE;
static float DepthCueScale = (float)100; 

DEPTHDLG::DEPTHDLG () : GUIDIALOG ()
  {
  } // End of Constructor for DEPTHDLG
  
DEPTHDLG::~DEPTHDLG ()
  {
  } // End of Destructor for DEPTHDLG
  
LONG DEPTHDLG::OnInitDialog ()
  {
    SetButtonState ( FOG_SCALE, FogOnOff );
    
    CHAR Str[128];
    sprintf ( Str, "%4.2f", DepthCueScale );
    SetItemText ( DEPTH_SCALE, Str );
    return 0;
  } // End of OnInitDialog for DEPTHDLG

LONG DEPTHDLG::OnCommand ( LONG Command )
  {
    CHAR Str[128];
     
    switch (Command)
      {        
        case DEPTH_OK :
          DepthCueOnOff = GetButtonState ( DEPTH_ONOFF );
          GetItemText ( DEPTH_SCALE, Str );
          DepthCueScale = (float)atof ( Str );
          ReturnValue = TRUE;
          CloseWindow ();
          break;
        case DEPTH_CANCEL :
          ReturnValue = FALSE;
          CloseWindow ();
          break;  
      } // End switch
    return 0; 
  } // End of OnCommand for DEPTHDLG
  
BOOLEAN DEPTHDLG::IsDepthCueOn ()
  {
    return DepthCueOnOff;
  } // End of IsDepthOn for DEPTHDLG

float DEPTHDLG::GetDepthCueScale ()
  {
    return DepthCueScale;
  } // End of GetDepthCueScale for DEPTHDLG
  

//***********************************
//
// BG Color Dialog
//
//***********************************

#define BG_RED    101
#define BG_GREEN  102
#define BG_BLUE   103
#define BG_OK     IDOK
#define BG_CANCEL IDCANCEL
#define BG_HELP   998

INT BGRed=0;
INT BGGreen=0;
INT BGBlue=0;

BGCOLORDLG::BGCOLORDLG () : GUIDIALOG ()
  {
  } // End of Constructor for BGCOLORDLG

BGCOLORDLG::~BGCOLORDLG ()
  {
  } // End of Destructor for BGCOLORDLG

LONG BGCOLORDLG::OnInitDialog ()
  {
    return 0;  
  } // End of OnInitDialog for BGCOLORDLG

LONG BGCOLORDLG::OnCommand ( LONG Command )
  {
    switch (Command)
      {
        case BG_OK :
          BGRed = GetItemNumber ( BG_RED );
          BGGreen = GetItemNumber ( BG_GREEN );
          BGBlue = GetItemNumber ( BG_BLUE );
          ReturnValue = TRUE;
          CloseWindow ();
          break;  
        case BG_CANCEL :
          ReturnValue = FALSE;
          CloseWindow ();
          break;  
      } // End switch  
    return 0;  
  } // End of OnCommand for BGCOLORDLG

VOID BGCOLORDLG::GetRGB ( RGBCOLOR *Col )
  {
    Col->Red = (BYTE)BGRed;  
    Col->Green = (BYTE)BGGreen;  
    Col->Blue = (BYTE)BGBlue;  
  } // End of GetRGB for BGCOLORDLG


//***********************************
//
// Ambient Color Dialog
//
//***********************************

#define AMBIENT_RED    101
#define AMBIENT_GREEN  102
#define AMBIENT_BLUE   103
#define AMBIENT_OK     IDOK
#define AMBIENT_CANCEL IDCANCEL
#define AMBIENT_HELP   998

INT AMBIENTRed=0;
INT AMBIENTGreen=0;
INT AMBIENTBlue=0;

AMBIENTDLG::AMBIENTDLG () : GUIDIALOG ()
  {
  } // End of Constructor for AMBIENTDLG

AMBIENTDLG::~AMBIENTDLG ()
  {
  } // End of Destructor for AMBIENTDLG

LONG AMBIENTDLG::OnInitDialog ()
  {
    return 0;  
  } // End of OnInitDialog for AMBIENTDLG

LONG AMBIENTDLG::OnCommand ( LONG Command )
  {
    switch (Command)
      {
        case AMBIENT_OK :
          AMBIENTRed = GetItemNumber ( AMBIENT_RED );
          AMBIENTGreen = GetItemNumber ( AMBIENT_GREEN );
          AMBIENTBlue = GetItemNumber ( AMBIENT_BLUE );
          ReturnValue = TRUE;
          CloseWindow ();
          break;  
        case AMBIENT_CANCEL :
          ReturnValue = FALSE;
          CloseWindow ();
          break;  
      } // End switch  
    return 0;  
  } // End of OnCommand for AMBIENTDLG

VOID AMBIENTDLG::GetRGB ( RGBCOLOR *Col )
  {
    Col->Red = (BYTE)AMBIENTRed;  
    Col->Green = (BYTE)AMBIENTGreen;  
    Col->Blue = (BYTE)AMBIENTBlue;  
  } // End of GetRGB for AMBIENTDLG

//***********************************
//
// About Dialog
//
//***********************************

#define ABOUT_OK IDOK

LONG ABOUTDLG::OnCommand ( LONG Command ) 
  {
    switch (Command)
      {
        case ABOUT_OK :
          CloseWindow ();
          break;  
      } // End switch
    return 0;  
  } // End of OnCommand for ABOUTDLG

