#define VIEW 100
#define MAXPTS 10	//maximum vertices for each polygon.

typedef struct {
short rotx;
short roty;
short rotz;
short x;
short y;
short z;
short scale_c;	//change in scale
short BREAK;
short debug;
}CONTROL;	//keyboard control structure for inteface purpose.


typedef struct {
short x;
short y;
}COORD; 	//x, y map coordinate.

struct POINT{
VAR x;
VAR y;
VAR z;
VAR t;
POINT operator=(POINT );
};           //point in 3d space

#define VECTOR POINT

typedef struct {
POINT l;             //local
POINT w;             //world
COORD v;             //view
}VERTEX;         //vertex of object.

typedef struct {       //polygon structure.
short num_of_vertex;
short texture_index;     //index: which picture for texture mapping.
short *p_ver;            //array of index of vertices.
COORD *texture_ver;      //array of coordinates on the picture
BYTE  color;
VECTOR normal_w;	//world normal.
VECTOR normal_l;	//local normal.
}POLYGON;

typedef struct {      //for one horizonal line on screen,
short x1;               //first position.
short x2;               //second position.
short mx1;              //x coordinate of first position in picture.
short mx2;              //................second...................
short my1;              //y ..............first....................
short my2;              //y ..............second....................
}SCN_HOR;

class BSPNODE;

typedef class obj3d{
BSPNODE *bsp;
short total_vertex;      //total number of vertex.
short total_poly;        //total number of polygon.
VERTEX * o_ver;        //array keep all vertex in counter clockwis order.
POLYGON * o_poly;      //array keep all polygons.
VERTEX *morph_step;    //steps to take for each morphing frame.
WORD morph_frame;      //upper 8 bit is maximum frame while morphing,
		       //lower 8 bit is the current frame.
VAR matrix[4][4];      //matrix prepared for transformation.
public:
friend class BSPNODE;
void print_obj3d();
void id_matrix();      //identity matrix.
void scale(VAR ratio); //scale objects.
void rotate(short xan,short yan,short zan);
void moveto(VAR x,VAR y,VAR z);   //move to world space position (x, y, z)

int  initobj(char *);
void morph(obj3d *des_obj=NULL);
short add_vertex(POINT new_p);
short poly_split(short *front, short f_num, short *back, short b_num, short cur);
void setworld();                //setup world space.
void setview();                 //setup view space.
void draw(BYTE *screen);	  //draw object by calling draw_poly.
}OBJ3D;


extern VAR SIN[629];
extern VAR COS[629];
extern POINT CAMERA;
extern CONTROL C;

