#include        <stdio.h>
#include	<stdlib.h>
#include        <time.h>
#include	<string.h>

#include        "define.h"
#include	"screen.h"
#include        "3d.h"
#include 	"bsp.h"
#include 	"inteface.h"
#include        "draw.h"
#include        "math.h"

BYTE  **GRAPH;

VAR SIN[629];
VAR COS[629];

unsigned SCR_TBL[SCREEN_HEIGHT];	
unsigned TEX_TBL[100];		
CONTROL C;
POINT CAMERA;

char GRAPHNAME[6][14]={"ac5.raw", "ac4.raw", "ac3.raw", "ac2.raw",
			"ac1.raw", "ac.raw"};

void initgraph()
{
int i;
unsigned offset;
BYTE pal[768];

GRAPH = (BYTE  **)malloc(6*sizeof(BYTE	*));
for(i=0;i<6;i++)
  {
  GRAPH[i] = (BYTE    *)malloc(16000);
  getraw(GRAPHNAME[i], GRAPH[i], pal);
  }

pal[0]=0; pal[1]=0; pal[2]=0;

if (!SETMODE) { printf("Error initialize video mode!"); exit(0);}
modDAC(0, pal, 256);

offset=0;
for (i=0;i<SCREEN_HEIGHT;i++)  //setup screen y offset value.
  {
   SCR_TBL[i]=offset; offset+=SCREEN_WIDTH;}
offset = 0;

for (i=0; i<100;i++)            //setup texture mapping y offset value.
  {
   TEX_TBL[i]=offset; offset +=160;}

for (i=0;i<629;i++)             //setup sin and cos table.
  {
  SIN[i]=(VAR)(sin((float)i/100)*X2O(1));     //modified to be integer.
  COS[i]=(VAR)(cos((float)i/100)*X2O(1));
  }

CAMERA.x = 0; CAMERA.y =0; CAMERA.z = 0;        //set point of view to the origin.

C.BREAK = 0; C.debug=0;

}



int obj3d::initobj(char *file)
{
int garb, i, j;
FILE *f;
int num;
short tm[10];

if((f=fopen(file, "r"))==NULL)
  return 1;

//total vertices and polygons.
fscanf(f, "%d ", &total_vertex);
fscanf(f, "%d ", &total_poly);


o_ver= (VERTEX *)malloc(total_vertex*sizeof(VERTEX));
o_poly= (POLYGON *)malloc(total_poly*sizeof(POLYGON));

//read all vertex;
for (i=0; i<total_vertex; i++)
  {
  fscanf(f, "%d %d %d %d ", &garb, &tm[0], &tm[1], &tm[2]);

  o_ver[i].l.x=(VAR)X2O(tm[0]);
  o_ver[i].l.y=(VAR)X2O(tm[1]);
  o_ver[i].l.z=(VAR)X2O(tm[2]);

  if (garb != i)
    return 3;
  o_ver[i].l.t = 1;
  }

//read polygons.
for (i=0; i<total_poly; i++)
  {
  fscanf(f, "%d %d ", &garb, &(o_poly[i].num_of_vertex));
  if (garb!=i)
    return 4;
  POLYGON *poly=&o_poly[i];
  poly->p_ver = (short *)malloc(o_poly[i].num_of_vertex*sizeof(short));

  //read vertex in each polygon
  for (j=0; j<o_poly[i].num_of_vertex; j++)
    fscanf(f, "%d ", &(o_poly[i].p_ver[j]));
  
  //set local normal and world normal.
  poly->normal_l=get_normal(o_ver[poly->p_ver[0]].l, o_ver[poly->p_ver[1]].l,
  			   o_ver[poly->p_ver[2]].l);
  poly->normal_l.t=get_D(o_ver[poly->p_ver[0]].l, poly->normal_l);
  poly->normal_w=poly->normal_l;  
  			   
  //read texture mapping position or color of the polygon
  fscanf(f, "%d ", &garb);
  if (garb >= 0)
     {
      poly->texture_index = garb;
      poly->texture_ver = (COORD *)malloc(o_poly[i].num_of_vertex*sizeof(COORD));
      for (j=0; j<o_poly[i].num_of_vertex; j++)
	 fscanf(f, "%d %d ", &(poly->texture_ver[j].x),
				 &(poly->texture_ver[j].y));
     }

  else
    {
    poly->texture_index=-1;
    fscanf(f, "%d ", &(poly->color));
    }

  }
  fclose(f);
  //build bsp.
  short *list=new short[total_poly];
  
  for (i=0; i<total_poly; i++)
    list[i]=i;
    
  bsp= new BSPNODE;
  bsp->build_bsp(this, list, total_poly);
  delete list;
 
  //finish building bsp.
  return 0;
}


VAR infinite_value(VAR src, VAR max, VAR min)
  {
    if (src>max) src=min+(src-max);
    if (src<min) src=max-(min-src);
    return src;
  }

VAR adjust_value(VAR src, VAR max, VAR min)
  {
    if (src>max) src=max;
    if (src<min) src=min;
    return src;
   }
   
int main()
{
  OBJ3D obj[5];
  int xangle=0,yangle=0,zangle=0;
  BYTE *vir_screen;
  long vir_screen_size=SCREEN_WIDTH*SCREEN_HEIGHT;
  
  int ind;

  clock_t start, end;

  double frame=0;

   vir_screen=new BYTE [vir_screen_size];
   if (vir_screen==NULL) {printf("Error allocating memory!"); exit(0);}
   initgraph();
   
    int i;
 

    if((ind=obj[0].initobj("copy.3d"))!=0)
      {
      setmode(0x03); printf("\nError Reading Input! %d", ind);
      return 1;}

    clear_control();
    start=clock();

  while (!C.BREAK) {
    frame++;

    memset(vir_screen, 0, vir_screen_size);     //clear virtual screen.

    evaluate_key();
    
    obj[0].id_matrix();

    obj[0].scale(X2O(1));
    
    obj[0].rotate(xangle, yangle, zangle);   //rotate according to 0< angle < 629
     
    obj[0].moveto(0, 0, X2O(120)); 	//locate object at position (0, 0, 120)

    obj[0].setworld();             //calculate vertices in world.

    obj[0].setview();                 //calculate vertices on screen.

    obj[0].draw(vir_screen);

    xangle=(xangle+C.rotx)%629;
    yangle=(yangle+C.roty)%629;
    zangle=(zangle+C.rotz)%629;
     
    CAMERA.x =infinite_value(CAMERA.x+C.x, X2O(65536), -X2O(65536));
    CAMERA.y =infinite_value(CAMERA.y+C.y, X2O(65536), -X2O(65536));
    CAMERA.z =adjust_value(CAMERA.z+C.z, X2O(40), -X2O(300));
      
    clear_control();

    PAINT_SCREEN(0,0,SCREEN_WIDTH, SCREEN_HEIGHT, vir_screen);
    }

    end = clock();
    long shi=(long)end-(long)start;

    setmode(0x03);

    printf("\n%ld frames, %ld ticks.\n %7.2lf f/s!",
		(long)frame, shi, frame*CLOCKS_PER_SEC/shi);
 }
