#include<stdio.h>
#include<math.h>
#include "define.h"
#include "3d.h"
#include "math.h"

VECTOR cross_product(VECTOR v, VECTOR w)
     {
	VECTOR result;
	result.x = O2X(XMUL v.y * w.z - XMUL v.z * w.y);
	result.y = O2X(XMUL v.z * w.x - XMUL v.x * w.z);
	result.z = O2X(XMUL v.x * w.y - XMUL v.y * w.x);
	return result;
     }


VAR dot_product(VECTOR v, VECTOR p) 
     {
      return (VAR)(O2X(XMUL v.x*p.x)+O2X(XMUL v.y*p.y)+O2X(XMUL v.z*p.z));
     }     
     
//with 3 points in 3d space, get a plane's normal and set it's
//distance from origin to 256.
VECTOR get_normal(POINT p1, POINT p2, POINT p3)
  {
  VECTOR v, w;
  VECTOR normal;
  
  v.x = p1.x - p2.x; v.y = p1.y - p2.y; v.z = p1.z - p2.z;
  w.x = p1.x - p3.x; w.y = p1.y - p3.y; w.z = p1.z - p3.z;
  
  normal=cross_product(v, w);
  normalize(normal);

  return normal;
 }


VAR get_D(POINT p, VECTOR v)
  {
   return -dot_product((VECTOR)p, v);
  } 
    

void normalize(VECTOR &v)
  {
  VAR size=(VAR) (sqrt((double)(O2X(XMUL v.x*v.x + 
  			XMUL v.y*v.y +XMUL v.z*v.z))/X2O(1))*X2O(1));

  if (size>0)
    {
     v.x=X2O(v.x)/size;
     v.y=X2O(v.y)/size;
     v.z=X2O(v.z)/size;
    }
  }  


short operator==( POINT x, POINT y) 
  {
  if ((x.x==y.x) && (x.y==y.y) && (x.z==y.z)) return 1;
  return 0;
  }
  

POINT operator-( POINT x, POINT y ) 
  {
  POINT result;
  result.x=x.x-y.x;
  result.y=x.y-y.y;
  result.z=x.z-y.z;
  return result;
  }


POINT POINT::operator=(POINT v) 
  {
  x=v.x;
  y=v.y;
  z=v.z;
  t=v.t;
  return *this;
  }
  

POINT operator+(POINT u, POINT v)
  {
  POINT r;
  r.x=u.x+v.x;
  r.y=u.y+v.y;
  r.z=u.z+v.z;
  return r;
  }
   
POINT operator*(POINT u, VAR v)
  {
   POINT r;
   r.x=O2X(XMUL u.x*v);
   r.y=O2X(XMUL u.y*v);
   r.z=O2X(XMUL u.z*v);
   return r;
  }

POINT operator/(POINT u, VAR v)
  {
   POINT r;
   r.x=X2O(u.x)/v;
   r.y=X2O(u.y)/v;
   r.z=X2O(u.z)/v;
   return r;
 }  
 
 
  
//multiply mat1 with mat2, put result in 'result'.
void mul_matrix(VAR result[4][4], VAR mat1[4][4],
	      VAR mat2[4][4])
{
  int i, j, k;

  for (i=0; i<4; i++)
    for (j=0; j<4; j++) {
      result[i][j]=0;
      for (k=0; k<4; k++)
	result[i][j]+=O2X(mat1[i][k] * mat2[k][j]);
    }
}


//duplicate source matrix, put it in dest.
void dup_matrix(VAR dest[4][4],VAR source[4][4])
{
  int i, j;
  for (i=0; i<4; i++)
    for (j=0; j<4; j++)
      dest[i][j]=source[i][j];
}


POINT mul_point_matrix(POINT p, VAR matrix[4][4], short translate)
  {
  POINT r;
  r.x= O2X(p.x*matrix[0][0]+p.y*matrix[0][1]+ p.z*matrix[0][2])+matrix[0][3]*translate;
  r.y= O2X(p.x*matrix[1][0]+p.y*matrix[1][1]+ p.z*matrix[1][2])+matrix[1][3]*translate;
  r.z= O2X(p.x*matrix[2][0]+p.y*matrix[2][1]+ p.z*matrix[2][2])+matrix[2][3]*translate;
  return r;
  }
 