                      

        .MODEL small     ;small program, and stack memory reserved is 128bytes
        .STACK 256       

        .DATA
Instructions db 13,10,"Hit F1 through F6 to control rotation,",13,10,\ 
                "press a key to continue...",13,10,"$"

Credits      db 13,10,"Coded by Andy of small town Bowmanville.",13,10,\
                "(I just started learning assembler in September)",13,10,"$"

VERTSTRUC_SIZE EQU 6
ROTVSTRUC_SIZE EQU 10
POLYSTRUC_SIZE EQU 8
OBJSTRUC_SIZE  EQU 14+NUMPOLY+NUMVERT
 
CLIPVSTRUC_SIZE EQU 12
CLIPSTRUC_SIZE  EQU 10*CLIPVSTRUC_SIZE+2    

NUMVERT   EQU 12
NUMPOLY   EQU 10
NUMOBJ    EQU 2
POLYvMAX EQU 6

XMIN  EQU 40
XMAX  EQU 280
YMIN  EQU 30
YMAX  EQU 170
ZMIN  EQU 1



polystruc STRUC          ;I figure I won't need more than
        numv   db ?      ;six sides per polygon(but I can change it)
        
        one  LABEL BYTE
        REPT POLYvMAX
                db ?
        ENDM

        color  db ?
polystruc ENDS

INCLUDE sincos.dw    ;look up table for sine-cosine operations    
        
XYZstruc STRUC       ;structure for original coordinates of cube
        X dw ?
        Y dw ?
        Z dw ?
XYZstruc ENDS


XYZscrn STRUC        ;structure for rotated vertices of cube
        X dw ?       ;this structure also contains space for the  
        Y dw ?       ;screen coordinates
        Z dw ?
        SX dw ?
        SY dw ?
XYZscrn ENDS

CLIPvert STRUC
        fX dw ?
        fY dw ?
        fZ dw ?
        tX dw ?
        tY dw ?
        tZ dw ?
CLIPvert ENDS

CLIPpoly STRUC
        numvertices db ?
        clipcolor   db ? 

        vertices LABEL CLIPvert
        REPT POLYvMAX+4
                STRUC
                dw 0
                dw 0
                dw 0
                dw 0
                dw 0
                dw 0
                ENDS
        ENDM
CLIPpoly ENDS        

OBJstruc STRUC
        Xpos dw 0
        Ypos dw 0
        Zpos dw 0

        Xvel db 0
        Yvel db 0
        Zvel db 0
        
        Xa   db 0
        Ya   db 0
        Za   db 0
                
        OBJnumv db 0
        
        v1  LABEL  BYTE 
        REPT NUMVERT
                db ?
        ENDM
        
        
        numpolygons db 0
        
        p1  LABEL  BYTE 
        REPT NUMPOLY
                db ?
        ENDM
OBJstruc ENDS



        
origXYZ XYZstruc <30,30,30>      ;8 X,Y,Z coordinates of cube
        XYZstruc <30,-30,30> 
        XYZstruc <-30,-30,30>
        XYZstruc <-30,30,30>

        XYZstruc <30,30,-30>      ;8 X,Y,Z coordinates of cube
        XYZstruc <30,-30,-30> 
        XYZstruc <-30,-30,-30>
        XYZstruc <-30,30,-30>
        
        ;XYZstruc <0,0,40>

        XYZstruc <0,0,80>
        XYZstruc <0,15,60>
        XYZstruc <-10,-10,60>
        XYZstruc <10,-10,60>

rotXYZ        XYZscrn NUMVERT DUP(<>) ;8 reserved X,Y,Z ,SX,SY coordinates,
CLIPpolygons CLIPpoly NUMPOLY DUP(<>)                                      
                                      

OBJECTS  OBJstruc <0,0,200, 0,0,0, 0,0,0, 8, 0,1,2,3,4,5,6,7,?,?,?,?, 6, 0,1,2,3,4,5,?,?,?,?>
         OBJstruc <0,0,200, 0,0,0, 0,0,0, 4, 8,9,10,11,?,?,?,?,?,?,?,?, 4, 8,9,10,11,?,?,?,?,?,?>


polygons polystruc <4, 0,1,2,3, ?,?, 1>  ;polygons which point to vertices  
         polystruc <4, 7,6,5,4, ?,?, 2>  ;on each side of cube (6).
         polystruc <4, 0,3,7,4, ?,?, 3>  ;each polygon has 4 vertices
         polystruc <4, 1,5,6,2, ?,?, 4>  
         
         polystruc <4, 2,6,7,3, ?,?, 5>
         polystruc <4, 0,4,5,1, ?,?, 7>
         ;polystruc <3, 5,3,4, ?,?,?, 4>
         ;polystruc <3, 5,4,1, ?,?,?, 2>

         polystruc <3, 8,10,9, ?,?,?, 1>
         polystruc <3, 9,10,11, ?,?,?, 9>
         polystruc <3, 8,11,10, ?,?,?, 10>
         polystruc <3, 8,9,11, ?,?,?, 11>

numpolylist db 0                        
polylist    db NUMPOLY DUP(?) 
polyZmin    dw NUMPOLY DUP(?)


OBJptr dw 0
Xangle db ?        
Yangle db ?
Zangle db ?

        .FARDATA scrnbufSEG
screenbuf db 64000 DUP(?)         
        
        .CODE         
        .386

INCLUDE cli.asm

backface PROC
        ;ax=# of polygon to draw
        LOCAL vp1:BYTE,vp2:BYTE,vp3:BYTE=stacksize 
        
        push bp
        mov bp,sp
        sub sp,stacksize
        shl ax,3         ;or AX*POLYSTRUC_SIZE
        mov di,ax

        movzx ax,[polygons.one+di]
        mov cx,ROTVSTRUC_SIZE
        mul cx
        mov [vp1],al
        movzx ax,[polygons.one+di+1]
        mul cx
        mov [vp2],al
        movzx ax,[polygons.one+di+2]
        mul cx
        mov [vp3],al

        movzx si,[vp2]  
        mov ax,[rotXYZ.SX+si]
        sub ax,160
        movzx si,[vp1]
        mov bx,[rotXYZ.SX+si]
        sub bx,160
        sub ax,bx
        
        mov dx,[rotXYZ.SY+si]
        sub dx,100
        neg dx
        movzx si,[vp3]
        mov cx,[rotXYZ.SY+si]
        sub cx,100
        neg cx
        sub cx,dx
        imul cx
        push ax

        movzx si,[vp2]  
        mov ax,[rotXYZ.SY+si]
        sub ax,100
        neg ax
        movzx si,[vp1]
        mov bx,[rotXYZ.SY+si]
        sub bx,100
        neg bx
        sub ax,bx
        
        mov dx,[rotXYZ.SX+si]
        sub dx,160
        movzx si,[vp3]
        mov cx,[rotXYZ.SX+si]
        sub cx,160
        sub cx,dx
        imul cx
        pop bx
        sub bx,ax

        cmp bx,0
        jl behind  

        stc
        mov sp,bp
        pop bp
        ret

behind:
        clc
        mov sp,bp
        pop bp
        ret
backface ENDP

makelist PROC
        mov ax,0
        mov si,0

@@test:
        push ax
        push si
        call backface
        pop si
        pop ax
        jnc notonlist
        
        mov [polylist+si],al
        inc si

notonlist:
        inc ax
        cmp ax,NUMPOLY
        jne @@test

        mov ax,si
        mov [numpolylist],al
        ret
makelist ENDP


Zflip PROC
        LOCAL i:BYTE,swapflag:BYTE =stacksize
        
        push bp
        mov bp,sp
        sub sp,stacksize
        
        mov [i],0
        
findnxtMIN:        
        movzx bx,[i]
        cmp bl,[numpolylist]
        je doneZmin
        
        movzx di,[polylist+bx]
        shl di,3                         ;DI*POLYSTRUC_SIZE
        movzx cx,[polygons.numv+di]
        mov bx,32000

@@next1:
        movzx si,[polygons.one+di]
        mov ax,ROTVSTRUC_SIZE
        cwd
        mul si
        mov si,ax
        mov dx,[rotXYZ.Z+si]
        
        cmp bx,dx
        jle notless1

        mov bx,dx   ;put new smallest amount in bp
                    ;[polygons.one+di]   ;put new # representing vertex with Ycor in dx, in bx
notless1:
        inc di 
        loop @@next1
        
        movzx ax,[i]
        xchg ax,bx
        shl bx,1
        mov [polyZmin+bx],ax
        inc [i]
        
        jmp findnxtMIN

doneZmin:        
        mov [swapflag],1
        
@@Wswapflag:        
        cmp [swapflag],0
        je allswapped

        mov [i],0
        mov [swapflag],0

@@FiLTnpoly:        
        mov al,[numpolylist]
        mov bl,[i]
        inc bl
        cmp bl,al
        je binthru
        
        
        movzx bx,[i]
        shl bx,1
        mov ax,[polyZmin+bx+2]
        cmp [polyZmin+bx],ax
        jg noswap
        jl swap
 
        movzx bx,[i]
        movzx di,[polylist+bx]
        shl di,3                         ;DI*POLYSTRUC_SIZE
        movzx cx,[polygons.numv+di]
        
        ;cmp cx,0
        ;je noswap
        
        push cx
        mov bx,-32000

@@next3:
        movzx si,[polygons.one+di]
        mov ax,ROTVSTRUC_SIZE
        cwd
        mul si
        mov si,ax
        mov dx,[rotXYZ.Z+si]
        
        ;cmp bx,dx
        ;jge notless3

        add bx,dx   ;put new smallest amount in bp
                    ;[polygons.one+di]   ;put new # representing vertex with Ycor in dx, in bx
notless3:
        inc di 
        loop @@next3

        movzx eax,bx
        cwd
        pop bx
        idiv bx
        push ax

        movzx bx,[i]
        movzx di,[polylist+bx+1]
        shl di,3                         ;DI*POLYSTRUC_SIZE
        movzx cx,[polygons.numv+di]
        
        ;cmp cx,0
        ;je noswap
        
        push cx
        mov bx,-32000

@@next4:
        movzx si,[polygons.one+di]
        mov ax,ROTVSTRUC_SIZE
        cwd
        mul si
        mov si,ax
        mov dx,[rotXYZ.Z+si]
        
        ;cmp bx,dx
        ;jge notless4

        add bx,dx   ;put new smallest amount in bp
                    ;[polygons.one+di]   ;put new # representing vertex with Ycor in dx, in bx
notless4:
        inc di 
        loop @@next4

        movzx eax,bx
        cwd
        pop bx
        idiv bx
        pop bx
        cmp ax,bx
        jle noswap      
                       
swap:                  
        movzx bx,[i]
        mov al,[polylist+bx]
        mov dl,[polylist+bx+1]
        mov [polylist+bx],dl
        mov [polylist+bx+1],al
        
        shl bx,1
        mov ax,[polyZmin+bx]
        mov dx,[polyZmin+bx+2]
        mov [polyZmin+bx],dx
        mov [polyZmin+bx+2],ax
        
        mov [swapflag],1
        
noswap:
        inc [i]
        jmp @@FiLTnpoly

binthru:
        jmp @@Wswapflag

allswapped:
        mov sp,bp
        pop bp
        ret
Zflip ENDP

drawCLIPlist PROC
        mov bx,0
        
@@nextpoly:
        cmp bl,[numpolylist]
        jae nomore
        
        movzx di,[polylist+bx]
        push bx
        push di
        call Zclip
        pop di
        push di
        call clipXYZtoXY
        pop di
        push di
        call XYclip
        pop di
        call polydraw
        pop bx
        inc bx
        jmp @@nextpoly

nomore:
        ret
drawCLIPlist ENDP

AddAngles PROC
        mov bx,0

nextobj:
        cmp bx,NUMOBJ*OBJSTRUC_SIZE
        je fini

        mov al,[OBJECTS.Xvel+bx]
        add [OBJECTS.Xa+bx],al
        mov al,[OBJECTS.Yvel+bx]
        add [OBJECTS.Ya+bx],al
        mov al,[OBJECTS.Zvel+bx]
        add [OBJECTS.Za+bx],al
        add bx,OBJSTRUC_SIZE
        jmp nextobj

fini:
        ret
AddAngles ENDP

XYZtoXY PROC
        ;DI points to rotated vertex
        mov ax,[rotXYZ.X+di]
        mov cx,[rotXYZ.Z+di]
        add cx,100
        
        movsx dx,ah
        shl ax,8
        cmp cx,0
        jne notzero

        inc cx

notzero:
        idiv cx
        
        add ax,160
        mov [rotXYZ.SX+di],ax
        
        mov ax,[rotXYZ.Y+di]
        neg ax
        
        movsx dx,ah
        shl ax,8
        idiv cx
        add ax,100
        mov [rotXYZ.SY+di],ax
        ret
XYZtoXY ENDP

clipXYZtoXY PROC
        ;DI = number of Zclipped polygon
        
        mov ax,CLIPSTRUC_SIZE
        mul di
        mov di,ax
        mov ax,0
        mov bx,0
        
projectnext:
        cmp al,[CLIPpolygons.numvertices+di]
        je projected

        inc ax
        push ax
        
        mov ax,[CLIPpolygons.vertices.fX+di+bx]
        mov cx,[CLIPpolygons.vertices.fZ+di+bx]
        add cx,100
        
        movsx dx,ah
        shl ax,8
        idiv cx
        add ax,160
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        
        mov ax,[CLIPpolygons.vertices.fY+di+bx]
        neg ax
        
        movsx dx,ah
        shl ax,8
        idiv cx
        add ax,100
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        add bx,CLIPVSTRUC_SIZE
        pop ax
        
        jmp projectnext

projected:
        ret
clipXYZtoXY ENDP


rotPoint PROC
        ;BX=Xcor,CX=Ycor,BP=Zcor 
        ;
        movzx si,[Zangle]
        add si,si
        mov ax,[cosine+si]      ;Z rotation
        imul bx                 ;AX*BX= newx * cos(za)
        mov di,dx               
        shl edi,16              ;BP=    newx * cos(za)
        mov di,ax
        mov ax,[sine+si]        ;AX*CX= newy * sin(za)
        imul cx                 
        shl edx,16
        mov dx,ax
        sub edi,edx             ;BP-AX= newx*cos(za)-newy*sin(za)
        sar edi,8               ;divide by 256(cos is 256 times too big)

        mov gs,di               ;tempx= newx*cos(za)-newy*sin(za)


        mov ax,[sine+si]        ;AX*BX= newx * sin(za)
        imul bx
        mov di,dx               
        shl edi,16              ;BP=    newx * sin(za) 
        mov di,ax
        mov ax,[cosine+si]      ;AX*CX= newy * cos(za)
        imul cx
        shl edx,16
        mov dx,ax
        add edi,edx             ;BP+AX= newx*sin(za)+newy*cos(za)
        sar edi,8                  
        mov cx,di
        mov bx,gs
        
        movzx si,[Xangle]
        add si,si
        mov ax,[cosine+si]      ;X rotation
        imul cx                 ;AX*BX= newy * cos(xa)
        mov di,dx
        shl edi,16
        mov di,ax               ;BP=    newy * cos(xa)

        mov ax,[sine+si]        ;AX*CX= newz * sin(xa)
        imul bp                 
        shl edx,16
        mov dx,ax
        sub edi,edx             ;BP-AX= newy*cos(xa)-newz*sin(xa)
        sar edi,8               ;BP/256
        mov gs,di               ;gs= newy*cos(xa)-newz*sin(xa)

                             
        mov ax,[sine+si]        ;AX*BX= newy * sin(xa)
        imul cx
        mov di,dx               ;BP=    newy * sin(xa)
        shl edi,16
        mov di,ax
        mov ax,[cosine+si]      ;AX*CX= newz * cos(xa)
        imul bp
        shl edx,16
        mov dx,ax
        add edi,edx             ;BP+AX= newy*sin(xa)+newz*sin(xa)
        sar edi,8               ;BP/256
        
        mov bp,di               ;newz
        mov cx,gs               ;newy

        movzx si,[Yangle]
        add si,si
        mov ax,[cosine+si]      ;Y rotation
        imul bx                 ;AX*BX= newx * cos(ya)
        mov di,dx
        shl edi,16
        mov di,ax
                                ;BP=    newx * cos(ya)
        mov ax,[sine+si]        ;AX*CX= newz * sin(ya)
        imul bp
        shl edx,16
        mov dx,ax
        sub edi,edx             ;BP-AX= newx*cos(ya)-newz*sin(ya)
        sar edi,8               ;BP/256
        mov gs,di               ;tempx= newx*cos(ya)-newz*sin(ya)
        
        mov ax,[sine+si]        ;AX*BX= newx * sin(ya)
        imul bx
        mov di,dx
        shl edi,16
        mov di,ax               ;BP=    newx * sin(ya)
        mov ax,[cosine+si]      ;AX*CX= newz * cos(ya)
        imul bp
        shl edx,16
        mov dx,ax
        add edi,edx             ;BP+AX= newx*sin(ya)+newz*cos(ya)
        sar edi,8               ;BP/256
        mov bp,di               ;BP=newz
        mov bx,gs               ;BX=newx
                                
        ret
rotPoint ENDP

rotateAll PROC
        mov ax,0
        mov bx,0
        
@@nextobj:
        cmp bx,NUMOBJ
        je nomoreOBJ
        push bx        
        mov ax,OBJSTRUC_SIZE
        mul bx
        mov bx,ax
        mov ax,0

@@nextvert:        
        cmp al,[OBJECTS.OBJnumv+bx]
        je nomoreVRT
        
        push ax
        push bx
        mov si,ax
        add si,bx
        
        movzx si,[OBJECTS.v1+si]
        mov di,si
        mov ax,VERTSTRUC_SIZE
        mul si
        mov si,ax
        
        push si
        push di
        
        mov al,[OBJECTS.Za+bx]
        mov [Zangle],al
        mov al,[OBJECTS.Ya+bx]
        mov [Yangle],al
        mov al,[OBJECTS.Xa+bx]
        mov [Xangle],al

        mov bx,[origXYZ.X+si]
        mov cx,[origXYZ.Y+si]
        mov bp,[origXYZ.Z+si]
        
        call rotPoint
        
        pop di
        pop si
        
        mov ax,ROTVSTRUC_SIZE
        mul di
        mov di,ax
        
        mov ax,bx
        pop bx
        add ax,[OBJECTS.Xpos+bx]
        add cx,[OBJECTS.Ypos+bx]
        add bp,[OBJECTS.Zpos+bx]
        
        mov [rotXYZ.X+di],ax
        mov [rotXYZ.Y+di],cx
        mov [rotXYZ.Z+di],bp
        call XYZtoXY
        pop ax
        inc ax
        jmp @@nextvert

nomoreVRT:        
        pop bx
        inc bx
        jmp @@nextobj

nomoreOBJ:        
        ret
rotateAll ENDP



clearbuf PROC
        
        push es
        mov ax,scrnbufSEG
        mov es,ax

        mov di,OFFSET screenbuf
        mov ax,0
        mov cx,32000
        repnz stosw
        
        pop es
       
        ret
clearbuf ENDP


pageflip PROC              
        push ds
        mov ax,scrnbufSEG
        mov ds,ax
        mov ax,0a000h
        mov es,ax

        mov si,OFFSET screenbuf ;the source of the movsw is the start       
                                ;of screenbuf
        
        mov di,0        ;point DI to first byte in vid-ram                

        mov cx,32000    ;move amount of doublebytes to store in memory(32000)
                        ;32000 is half the pixels of the screen, but we're
                        ;moving double bytes here for a total of 64000 bytes

        repnz movsw     ;repeat storing wordbytes(double) and decrementing
                        ;CX until z-flagis set(when CX reaches 0)
        call clearbuf   ;since the screen has been redrawn,clear the buffer
        pop ds
        
        ret
pageflip ENDP
        
doinput PROC
        
        mov bx,[OBJptr]
        
        cmp ah,41
        je @@OBJtoggle
        cmp ah,1
        je exit
        cmp ah,59
        je @@INCX
        cmp ah,60
        je @@DECX
        cmp ah,61
        je @@INCY
        cmp ah,62
        je @@DECY
        cmp ah,63
        je @@INCZ
        cmp ah,64
        je @@DECZ
        cmp ah,72
        je @@UP
        cmp ah,80
        je @@DOWN
        cmp ah,75
        je @@LEFT
        cmp ah,77
        je @@RIGHT
        cmp ah,30
        je @@ZOUT
        cmp ah,44
        je @@ZIN
        
        ret

@@OBJtoggle:
        add bx,OBJSTRUC_SIZE
        mov [OBJptr],bx
        cmp bx,OBJSTRUC_SIZE*NUMOBJ
        jne OBJnowrap
        
        mov [OBJptr],0

OBJnowrap:
        ret

@@INCX:
        inc [OBJECTS.Xvel+bx]
        ret
@@DECX:
        dec [OBJECTS.Xvel+bx]
        ret
@@INCY:
        inc [OBJECTS.Yvel+bx]
        ret
@@DECY:
        dec [OBJECTS.Yvel+bx]
        ret
@@INCZ:
        inc [OBJECTS.Zvel+bx]
        ret
@@DECZ:
        dec [OBJECTS.Zvel+bx]
        ret
@@UP:
        add [OBJECTS.Ypos+bx],5
        ret
@@DOWN:
        sub [OBJECTS.Ypos+bx],5
        ret
@@LEFT:
        sub [OBJECTS.Xpos+bx],5
        ret
@@RIGHT:
        add [OBJECTS.Xpos+bx],5
        ret
@@ZOUT:
        add [OBJECTS.Zpos+bx],10
        ret
@@ZIN:
        sub [OBJECTS.Zpos+bx],10
        ret

doinput ENDP

scankey PROC
        mov ah,11h
        int 16h
        jz @@nokey
        mov ah,0
        int 16h
        call doinput
        ret
@@nokey:
        clc
        ret
scankey ENDP

border PROC
        mov ax,XMIN
        mov bx,YMIN
        mov cx,XMAX
        mov dx,YMIN
        mov si,200
        call linedraw
        mov ax,XMAX
        mov bx,YMIN
        mov cx,XMAX
        mov dx,YMAX
        mov si,200
        call linedraw
        mov ax,XMAX
        mov bx,YMAX
        mov cx,XMIN
        mov dx,YMAX
        mov si,200
        call linedraw
        mov ax,XMIN
        mov bx,YMAX
        mov cx,XMIN
        mov dx,YMIN
        mov si,200
        call linedraw
        ret
border ENDP

start:        
        mov ax,@DATA    ;tell DS to point to the DATA segment
        mov ds,ax       ;
        mov ax,0A000h   ;AX now contains the start of video memory
        mov es,ax       ;point ES to it
        
;        mov ah,9
;        mov dx,OFFSET Instructions
;        int 21h
;
;        mov ah,1
;        int 21h
        
        mov ax,13h      ;
        int 10h         ;
        call clearbuf

scan:
        call scankey
        
        call AddAngles  
        call rotateAll
        
        call makelist
        call Zflip
        
        call drawCLIPlist
        call border
        call pageflip 
        
        jmp scan
exit:
                        ;set video mode to 3(standard text mode)
        mov al,03h      ;
        mov ah,0        ;
        int 10h         ;

        ;mov ah,9
        ;mov dx,OFFSET Credits
        ;int 21h
        
        mov ah,04ch     ;4c-hex is the DOS int 21h code for return control
        int 21h         ;to DOS
END start               




