getoffset PROC
        mov dx,320
        mul dx
        add ax,cx
        ret
getoffset ENDP


polydraw PROC
        ;DI=# of polygon to draw
        LOCAL  pcolor:BYTE,x1start:WORD,y1start:WORD,errterm1:WORD,\ 
               errterm2:WORD,startv1:WORD,startv2:WORD,endv1:WORD,endv2:WORD,\
               x2start:WORD,y2start:WORD,x1end:WORD,x2end:WORD,y1end:WORD,\
               y2end:WORD,polypE1:BYTE,polypE2:BYTE,xdir1:WORD,xdir2:WORD,\
               ydir1:WORD,ydir2:WORD,xdiff1:WORD,xdiff2:WORD,ydiff1:WORD,\
               ydiff2:WORD,offset1:WORD,offset2:WORD,count1:WORD,\
               count2:WORD =stacksize

        push bp
        mov bp,sp
        sub sp,stacksize
        
        mov ax,CLIPSTRUC_SIZE
        mul di
        mov di,ax
        movzx cx,[CLIPpolygons.numvertices+di] ; cx=number of vertexes in poly
        mov al,[CLIPpolygons.clipcolor+di]
        mov [pcolor],al
        mov [count1],cx
        push di
        mov cx,200

@@next:
        cmp [count1],0
        je @@labas
        
        mov dx,[CLIPpolygons.vertices.fY+di]
        cmp dx,cx
        jge @@noway
        
        mov cx,dx   ;put new smallest amount in bp
        mov bx,di ;[polygons.one+di]   ;put new # representing vertex with Ycor in dx, in bx
        mov es,si

@@noway:
        add di,CLIPVSTRUC_SIZE 
        dec [count1]
        jmp @@next

@@labas:        
        pop di
        sub bx,di
        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov cx,[CLIPpolygons.vertices.fx+di+bx]
        
        mov [startv1],bx
        mov [startv2],bx

        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov [x1start],ax
        mov [x2start],ax
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov [y1start],ax
        mov [y2start],ax
        
        push bx
        sub bx,CLIPVSTRUC_SIZE
        cmp bx,0
        jl @@wrapend1
        
        mov [endv1],bx
        
        jmp nowrap1

@@wrapend1:
        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        mov [endv1],ax
        mov bx,ax        

nowrap1:
        
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov [x1end],ax
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov [y1end],ax

        pop bx
        add bx,CLIPVSTRUC_SIZE
        movzx ax,[CLIPpolygons.numvertices+di]
        mov cx,CLIPVSTRUC_SIZE
        mul cx
        cmp bx,ax
        jge @@wrapend2
        
        mov [endv2],bx
        
        jmp nowrap2

@@wrapend2:
        mov bx,0
        mov [endv2],bx

nowrap2:
        
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov [x2end],ax
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov [y2end],ax
                
        movzx cx,[CLIPpolygons.numvertices+di]
        dec cx
        mov ax,scrnbufSEG 
        mov es,ax
        
        
notdone:
        cmp cx,0
        jle allfinished

        push di
        push cx
        mov ax,[y1start]
        mov cx,[x1start]
        call getoffset
        mov [offset1],ax
        mov ax,[y2start]
        mov cx,[x2start]
        call getoffset
        mov [offset2],ax
        mov [errterm1],0
        mov [errterm2],0

        mov ax,[y1end]
        sub ax,[y1start]
        cmp ax,0
        jge posY1

        neg ax

posY1:
        mov [ydiff1],ax

        mov ax,[y2end]
        sub ax,[y2start]
        cmp ax,0
        jge posY2

        neg ax

posY2:
        mov [ydiff2],ax

        mov [xdir1],1

        mov ax,[x1end]
        sub ax,[x1start]
        cmp ax,0
        jge posX1

        neg [xdir1]
        neg ax

posX1:
        mov [xdiff1],ax

        mov [xdir2],1

        mov ax,[x2end]
        sub ax,[x2start]
        cmp ax,0
        jge posX2

        neg [xdir2]
        neg ax

posX2:
        mov [xdiff2],ax

        mov cx,[xdiff1]
        cmp cx,[ydiff1]
        jbe @@T3or4
        
        mov ax,[xdiff2]
        cmp ax,[ydiff2]
        jbe @@T2

@@T1:
        mov [count1],cx
        mov [count2],ax

        mov di,OFFSET screenbuf

@@T1wC1&C2:
        cmp [count1],0
        je doneside
        cmp [count2],0
        je doneside
        
@@T1wERRltXD1:
        cmp [count1],0
        je @@T1noxincE1
      
        mov ax,[xdir1]
        add [offset1],ax
        add [x1start],ax

@@T1noxincE1:
        dec [count1]
        mov ax,[ydiff1]
        add ax,[errterm1]
        mov [errterm1],ax
        cmp ax,[xdiff1]
        jge @@T1nopixE1

        mov al,[pcolor]
        push di
        add di,[offset1] 
        stosb
        pop di

@@T1nopixE1:
        mov ax,[errterm1]
        cmp ax,[xdiff1]
        jge @@T1errLOOP1dn
        
        cmp [count1],0
        jle @@T1errLOOP1dn
        jmp @@T1wERRltXD1

@@T1errLOOP1dn:
        mov ax,[xdiff1]
        sub [errterm1],ax

@@T1wERRltXD2:
        cmp [count2],0
        je @@T1noxincE2

        mov ax,[xdir2]
        add [offset2],ax
        add [x2start],ax

@@T1noxincE2:
        dec [count2]
        mov ax,[ydiff2]
        add ax,[errterm2]
        mov [errterm2],ax

        cmp ax,[xdiff2]
        jae @@T1nopixE2

        mov al,[pcolor]
        push di
        add di,[offset2] 
        stosb
        pop di

@@T1nopixE2:
        mov ax,[xdiff2]
        cmp [errterm2],ax
        jge @@T1errLOOP2dn

        cmp [count2],0
        jle @@T1errLOOP2dn
        jmp @@T1wERRltXD2

@@T1errLOOP2dn:
        mov ax,[xdiff2]
        sub [errterm2],ax
        
        mov bx,[offset2]
        sub bx,[offset1]
        cmp bx,0
        jge @@T1poslength

        neg bx
        mov dx,[offset2]
        jmp T1lengthok

@@T1poslength:
        mov dx,[offset1]

T1lengthok:
        push di
        add di,dx
        add bx,dx
        inc bx
        mov al,[pcolor]
        
@@T1lineND:
        stosb
        inc dx
        cmp dx,bx
        jb @@T1lineND

        pop di
        add [offset1],320
        inc [y1start]
        add [offset2],320
        inc [y2start]

        jmp @@T1wC1&C2

@@T2:
        mov ax,[xdiff1]
        mov cx,[ydiff2]
        
        mov [count1],ax
        mov [count2],cx

@@T2wC1&C2:
        cmp [count1],0
        je doneside
        cmp [count2],0
        je doneside
        
        mov di,OFFSET screenbuf

@@T2wERRltXD1:
        cmp [count1],0
        je @@T2noxincE1
      
        mov ax,[xdir1]
        add [offset1],ax
        add [x1start],ax

@@T2noxincE1:
        dec [count1]
        mov ax,[ydiff1]
        add ax,[errterm1]
        mov [errterm1],ax
        cmp ax,[xdiff1]
        jge @@T2nopixE1

        mov al,[pcolor]
        push di
        add di,[offset1] 
        stosb
        pop di

@@T2nopixE1:
        mov ax,[errterm1]
        cmp ax,[xdiff1]
        jge @@T2errLOOP1dn
        
        cmp [count1],0
        jle @@T2errLOOP1dn
        jmp @@T2wERRltXD1

@@T2errLOOP1dn:
        mov ax,[xdiff1]
        sub [errterm1],ax
        mov ax,[xdiff2]
        add [errterm2],ax
        
        mov ax,[errterm2]
        cmp ax,[ydiff2]
        jle @@T2noxincE2

        sub ax,[ydiff2]
        mov [errterm2],ax
        mov ax,[xdir2]
        add [offset2],ax
        add [x2start],ax

@@T2noxincE2:                         ;@@noxinc2
        dec [count2]
        
        mov bx,[offset2]
        sub bx,[offset1]
        cmp bx,0
        jge @@T2poslength

        neg bx
        mov dx,[offset2]
        jmp T2lengthok

@@T2poslength:
        mov dx,[offset1]

T2lengthok:
        push di
        add di,dx
        add bx,dx
        inc bx
        mov al,[pcolor]
        
@@T2lineND:
        stosb
        inc dx
        cmp dx,bx
        jb @@T2lineND
        
        pop di
        add [offset1],320
        inc [y1start]
        add [offset2],320
        inc [y2start]

        jmp @@T2wC1&C2

@@T3or4:
        mov ax,[xdiff2]
        cmp ax,[ydiff2]
        jb @@T4

        mov ax,[ydiff1]
        mov [count1],ax
        mov ax,[xdiff2]
        mov [count2],ax

@@T3wC1&C2:
        cmp [count1],0
        je doneside
        cmp [count2],0
        je doneside
        
        mov di,OFFSET screenbuf

        mov ax,[xdiff1]
        add ax,[errterm1]
        mov [errterm1],ax
        cmp ax,[ydiff1]
        jb @@T3noxincE1
      
        mov ax,[ydiff1]
        sub [errterm1],ax
        mov ax,[xdir1]
        add [offset1],ax
        add [x1start],ax

@@T3noxincE1:
        dec [count1]

@@T3wERRltXD2:
        cmp [count2],0
        je @@T3noincxE2

        mov ax,[xdir2]
        add [offset2],ax
        add [x2start],ax

@@T3noincxE2:        
        dec [count2]
        mov ax,[errterm2]
        add ax,[ydiff2]
        mov [errterm2],ax
        cmp ax,[xdiff2]
        jae @@T3nopixE2

        mov al,[pcolor]
        push di
        add di,[offset2] 
        stosb
        pop di

@@T3nopixE2:
        mov ax,[errterm2]
        cmp ax,[xdiff2]
        jge @@T3errLOOP2dn
        
        cmp [count2],0
        jle @@T3errLOOP2dn
        jmp @@T3wERRltXD2

@@T3errLOOP2dn:        
        mov ax,[xdiff2]
        sub [errterm2],ax
        mov bx,[offset2]
        sub bx,[offset1]
        cmp bx,0
        jge @@T3poslength

        neg bx
        mov dx,[offset2]
        jmp T3lengthok

@@T3poslength:
        mov dx,[offset1]

T3lengthok:
        push di
        add di,dx
        add bx,dx
        inc bx
        mov al,[pcolor]
        
@@T3lineND:
        stosb
        inc dx
        cmp dx,bx
        jb @@T3lineND

        pop di
        add [offset1],320
        inc [y1start]
        add [offset2],320
        inc [y2start]

        jmp @@T3wC1&C2

@@T4:
        mov ax,[ydiff1]
        mov cx,[ydiff2]
        
        mov [count1],ax
        mov [count2],cx

@@T4wC1&C2:
        cmp [count1],0
        je doneside
        cmp [count2],0
        je doneside
        
        mov di,OFFSET screenbuf

        mov ax,[errterm1]
        add ax,[xdiff1]
        mov [errterm1],ax
        cmp ax,[ydiff1]
        jb @@T4noxincE1
      
        sub ax,[ydiff1]
        mov [errterm1],ax
        mov ax,[xdir1]
        add [offset1],ax
        add [x1start],ax

@@T4noxincE1:
        dec [count1]
        
        mov ax,[xdiff2]
        add ax,[errterm2]
        mov [errterm2],ax
        cmp ax,[ydiff2]
        jb @@T4noxincE2

        sub ax,[ydiff2]
        mov [errterm2],ax
        mov ax,[xdir2]
        add [offset2],ax
        add [x2start],ax

@@T4noxincE2:                         ;@@noxinc2
        dec [count2]
        
        mov bx,[offset2]
        sub bx,[offset1]
        cmp bx,0
        jge @@T4poslength

        neg bx
        mov dx,[offset2]
        jmp T4lengthok

@@T4poslength:
        mov dx,[offset1]

T4lengthok:
        push di
        add di,dx
        add bx,dx
        inc bx
        mov al,[pcolor]
        
@@T4lineND:
        stosb
        inc dx
        cmp dx,bx
        jb @@T4lineND

        pop di
        add [offset1],320
        inc [y1start]
        add [offset2],320
        inc [y2start]

        jmp @@T4wC1&C2
doneside:
        pop cx
        pop di
        
        cmp [count1],0
        jne E1notDN

        dec cx
        
        mov ax,[endv1]
        mov [startv1],ax
        sub [endv1],CLIPVSTRUC_SIZE
        mov bx,[endv1]
        cmp bx,0
        jge @@nowrapE1
        movzx bx,[CLIPpolygons.numvertices+di]
        dec bx
        mov ax,CLIPVSTRUC_SIZE
        mul bx
        mov [endv1],ax
        
@@nowrapE1:
        
        mov bx,[endv1]
        
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov [x1end],ax
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov [y1end],ax
        
E1notDN:
        cmp [count2],0
        jne E2notDN

        dec cx
        mov ax,[endv2]
        mov [startv2],ax
        
        add [endv2],CLIPVSTRUC_SIZE
        mov bx,[endv2]
        
        movzx ax,[CLIPpolygons.numvertices+di]
        mov dx,CLIPVSTRUC_SIZE
        mul dx
        cmp bx,ax
        jb @@nowrapE2
        
        mov [endv2],0
        
@@nowrapE2:
        
        mov bx,[endv2]
        
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov [x2end],ax
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov [y2end],ax
        
E2notDN:
        jmp notdone
        
allfinished:
        mov sp,bp
        pop bp
        ret
polydraw ENDP

XYclip PROC
        ;DI = number of ZCLIPPEDpolygon to CLIP
        LOCAL currCPvert:WORD,Ev1:WORD,Ev2:WORD,m:WORD,\
              =stacksize

        push bp
        mov bp,sp
        sub sp,stacksize

        mov ax,CLIPSTRUC_SIZE
        mul di
        mov di,ax

        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        mov [Ev1],ax
        
        
        mov [Ev2],0
        mov [currCPvert],0

@@XMINFORv2LTcNV:
        movzx ax,[CLIPpolygons.numvertices+di]        
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        cmp [Ev2],ax
        jae @@doneXMIN

        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        cmp ax,XMIN             ;<---- XMIN
        jl @@NOTinsideXMIN

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        cmp ax,XMIN             ;<---- XMIN
        jl @@NOTinsideXMIN
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@XMINclipped

@@NOTinsideXMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jge @@NOToutsideXMIN

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jge @@NOToutsideXMIN

        jmp @@XMINclipped

@@NOToutsideXMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jl @@NOTleavingXMIN

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jge @@NOTleavingXMIN

        movsx eax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov bx,[Ev2]
        movsx ecx,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,100
        imul bx
        ;movsx dx,ah
        ;shl ax,8
        idiv cx                                             ;divmark
        mov [m],ax

        mov bx,[CurrCPvert]                              ;<-- mark
        mov [CLIPpolygons.vertices.tX+di+bx],XMIN        

        mov bx,[Ev1]
        mov ax,XMIN                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.fx+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        
        ;sar ax,8
        ;sar dx,8
        ;mov ah,dl
        mov bx,100
        idiv bx
        
        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@XMINclipped

@@NOTleavingXMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jge @@XMINclipped

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fx+di+bx],XMIN             ;<---- XMIN
        jl @@XMINclipped
                                              
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov bx,[Ev2]
        mov cx,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,100
        imul bx
        ;movsx dx,ah
        ;shl ax,8
        idiv cx
        mov [m],ax

        mov bx,[CurrCPvert]                               ;<-- mark
        mov [CLIPpolygons.vertices.tX+di+bx],XMIN        

        mov bx,[Ev1]
        mov ax,XMIN                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.fx+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        mov bx,100
        idiv bx
        
        ;sar ax,8
        ;sar dx,8
        ;mov ah,dl
        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov cx,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        mov [CLIPpolygons.vertices.tY+di+bx],cx
        add [currCPvert],CLIPVSTRUC_SIZE
        
@@XMINclipped:
        mov ax,[Ev2]
        mov [Ev1],ax
        add [Ev2],CLIPVSTRUC_SIZE
        
        jmp @@XMINFORv2LTcNV

@@doneXMIN:
        mov ax,[currCPvert]
        cwd
        mov bx,CLIPVSTRUC_SIZE
        div bx
        mov [CLIPpolygons.numvertices+di],al
                                                          ;yo
        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        mov [Ev1],ax
        
        
        mov [Ev2],0
        mov [currCPvert],0

@@XMAXFORv2LTcNV:
        movzx ax,[CLIPpolygons.numvertices+di]        
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        cmp [Ev2],ax
        jae @@doneXMAX

        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        cmp ax,XMAX             ;<---- XMAX
        jg @@NOTinsideXMAX

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        cmp ax,XMAX             ;<---- XMAX
        jg @@NOTinsideXMAX
        
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@XMAXclipped

@@NOTinsideXMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jle @@NOToutsideXMAX

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jle @@NOToutsideXMAX

        jmp @@XMAXclipped

@@NOToutsideXMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jg @@NOTleavingXMAX

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jle @@NOTleavingXMAX

        mov ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov bx,[Ev2]
        mov cx,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,100
        imul bx
        idiv cx
        mov [m],ax

        mov bx,[CurrCPvert]                              ;<-- mark
        mov [CLIPpolygons.vertices.fX+di+bx],XMAX        

        mov bx,[Ev1]
        mov ax,XMAX                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.tx+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        mov bx,100
        idiv bx
        
        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@XMAXclipped

@@NOTleavingXMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jle @@XMAXclipped

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.tx+di+bx],XMAX             ;<---- XMIN
        jg @@XMAXclipped
                                              
        mov ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov bx,[Ev2]
        mov cx,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,100
        imul bx
        idiv cx
        mov [m],ax

        mov bx,[CurrCPvert]                               ;<-- mark
        mov [CLIPpolygons.vertices.fX+di+bx],XMAX        

        mov bx,[Ev1]
        mov ax,XMAX                       ;<--- XMAX
        sub ax,[CLIPpolygons.vertices.tx+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        mov bx,100
        idiv bx

        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov cx,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        mov [CLIPpolygons.vertices.fY+di+bx],cx
        add [currCPvert],CLIPVSTRUC_SIZE
        
@@XMAXclipped:
        mov ax,[Ev2]
        mov [Ev1],ax
        add [Ev2],CLIPVSTRUC_SIZE
        
        jmp @@XMAXFORv2LTcNV

@@doneXMAX:
        mov ax,[currCPvert]
        cwd
        mov bx,CLIPVSTRUC_SIZE
        div bx
        mov [CLIPpolygons.numvertices+di],al
                                                               ;yo
        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        mov [Ev1],ax
        
        
        mov [Ev2],0
        mov [currCPvert],0

@@YMINFORv2LTcNV:
        movzx ax,[CLIPpolygons.numvertices+di]        
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        cmp [Ev2],ax
        jae @@doneYMIN

        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jl @@NOTinsideYMIN

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jl @@NOTinsideYMIN
                      
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@YMINclipped

@@NOTinsideYMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jge @@NOToutsideYMIN

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jge @@NOToutsideYMIN

        jmp @@YMINclipped

@@NOToutsideYMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jl @@NOTleavingYMIN

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jge @@NOTleavingYMIN

        mov cx,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,100
        imul bx

        cmp cx,0
        je YMINzero1

        idiv cx
        mov [m],ax

        mov bx,[Ev1]
        mov ax,YMIN                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        cwd
        mov bx,100
        idiv bx
        
        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        jmp YMINok1

YMINzero1:
        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax

YMINok1:
        mov bx,[CurrCPvert]                              ;<-- mark
        mov [CLIPpolygons.vertices.tY+di+bx],YMIN        

        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@YMINclipped

@@NOTleavingYMIN:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jge @@YMINclipped

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.fy+di+bx],YMIN             ;<---- XMIN
        jl @@YMINclipped
                                              
        mov cx,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,100
        imul bx
        cmp cx,0
        je YMINzero2

        idiv cx
        mov [m],ax
         
        mov bx,[Ev1]
        mov ax,YMIN                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.fy+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        cwd
        mov bx,100
        idiv bx

        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        jmp YMINok2

YMINzero2:
        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
YMINok2:
        mov bx,[CurrCPvert]                               ;<-- mark
        mov [CLIPpolygons.vertices.tY+di+bx],YMIN        
        
        add [currCPvert],CLIPVSTRUC_SIZE

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.fx+di+bx]
        mov cx,[CLIPpolygons.vertices.fy+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.tX+di+bx],ax
        mov [CLIPpolygons.vertices.tY+di+bx],cx
        add [currCPvert],CLIPVSTRUC_SIZE
        
@@YMINclipped:
        mov ax,[Ev2]
        mov [Ev1],ax
        add [Ev2],CLIPVSTRUC_SIZE
        
        jmp @@YMINFORv2LTcNV

@@doneYMIN:
        mov ax,[currCPvert]
        cwd
        mov bx,CLIPVSTRUC_SIZE
        div bx
        mov [CLIPpolygons.numvertices+di],al
                                                              ;yo
        movzx ax,[CLIPpolygons.numvertices+di]
        dec ax
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        mov [Ev1],ax
        
        
        mov [Ev2],0
        mov [currCPvert],0

@@YMAXFORv2LTcNV:
        movzx ax,[CLIPpolygons.numvertices+di]        
        mov bx,CLIPVSTRUC_SIZE
        mul bx
        cmp [Ev2],ax
        jae @@doneYMAX

        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jg @@NOTinsideYMAX

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jg @@NOTinsideYMAX
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@YMAXclipped

@@NOTinsideYMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jle @@NOToutsideYMAX

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jle @@NOToutsideYMAX

        jmp @@YMAXclipped

@@NOToutsideYMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jg @@NOTleavingYMAX

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jle @@NOTleavingYMAX

        mov cx,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,100
        imul bx
        cmp cx,0
        je YMAXzero1

        idiv cx
        mov [m],ax
        
        mov bx,[Ev1]
        mov ax,YMAX                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        cwd
        mov bx,100
        idiv bx
        
        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        jmp YMAXok1

YMAXzero1:
        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax

YMAXok1:
        mov [CLIPpolygons.vertices.fY+di+bx],YMAX
        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@YMAXclipped

@@NOTleavingYMAX:
        mov bx,[Ev1]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jle @@YMAXclipped

        mov bx,[Ev2]
        cmp [CLIPpolygons.vertices.ty+di+bx],YMAX             ;<---- XMIN
        jg @@YMAXclipped
                                              
        mov cx,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[Ev1]
        sub cx,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[Ev1]
        sub ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,100
        imul bx
        
        cmp cx,0
        je YMAXzero2
        
        idiv cx
        mov [m],ax

        mov bx,[Ev1]
        mov ax,YMAX                       ;<--- XMIN
        sub ax,[CLIPpolygons.vertices.ty+di+bx]
        cwd
        mov cx,[m] 
        imul cx
        cwd
        mov bx,100

        idiv bx

        mov bx,[Ev1]
        add ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        jmp YMAXok2

YMAXzero2:
        
        mov bx,[Ev1]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax

YMAXok2:
        mov bx,[CurrCPvert]                               ;<-- mark
        mov [CLIPpolygons.vertices.fY+di+bx],YMAX        
        
        add [currCPvert],CLIPVSTRUC_SIZE

        mov bx,[Ev2]
        mov ax,[CLIPpolygons.vertices.tx+di+bx]
        mov cx,[CLIPpolygons.vertices.ty+di+bx]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        mov [CLIPpolygons.vertices.fY+di+bx],cx
        add [currCPvert],CLIPVSTRUC_SIZE
        
@@YMAXclipped:
        mov ax,[Ev2]
        mov [Ev1],ax
        add [Ev2],CLIPVSTRUC_SIZE
        
        jmp @@YMAXFORv2LTcNV

@@doneYMAX:
        mov ax,[currCPvert]
        cwd
        mov bx,CLIPVSTRUC_SIZE
        div bx
        mov [CLIPpolygons.numvertices+di],al
        

        mov sp,bp
        pop bp
        ret
XYclip ENDP
     
Zclip PROC
        ;DI = number of polygon to ZCLIP
        
        LOCAL currCPvert:WORD,Ev1:WORD,Ev2:WORD,t:WORD,\
              Ev1X:WORD,Ev2X:WORD,Ev1Y:WORD,Ev2Y:WORD,\
              Ev1Z:WORD,Ev2Z:WORD =stacksize

        push bp
        mov bp,sp
        sub sp,stacksize

        mov ax,CLIPSTRUC_SIZE
        mov si,di
        mul di
        mov di,ax
        mov ax,POLYSTRUC_SIZE
        mul si
        mov si,ax
        
        mov al,[polygons.color+si]
        mov [CLIPpolygons.clipcolor+di],al
        movzx ax,[polygons.numv+si]
        dec ax
        mov [Ev1],ax
        
        
        mov [Ev2],0
        mov [currCPvert],0

@@ZFORv2LTcNV:
        movzx ax,[polygons.numv+si]        
        cmp [Ev2],ax
        jae @@doneZMIN

        mov bx,[Ev1]
        movzx ax,[polygons.one+si+bx]
        push si
        mov dx,ROTVSTRUC_SIZE
        mul dx
        mov si,ax
        mov ax,[rotXYZ.X+si]
        mov [Ev1X],ax
        mov ax,[rotXYZ.Y+si]
        mov [Ev1Y],ax
        mov ax,[rotXYZ.Z+si]
        mov [Ev1Z],ax

        pop si
        mov bx,[Ev2]
        movzx ax,[polygons.one+si+bx]
        push si
        mov dx,ROTVSTRUC_SIZE
        mul dx
        mov si,ax
        mov ax,[rotXYZ.X+si]
        mov [Ev2X],ax
        mov ax,[rotXYZ.Y+si]
        mov [Ev2Y],ax
        mov ax,[rotXYZ.Z+si]
        mov [Ev2Z],ax
        pop si
        
        cmp [Ev1Z],ZMIN             ;<---- ZMIN
        jl @@NOTinsideZMIN

        cmp [Ev2Z],ZMIN             ;<---- ZMIN
        jl @@NOTinsideZMIN
        
        mov ax,[Ev2X]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        
        mov ax,[Ev2Y]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax
        
        mov ax,[Ev2Z]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fZ+di+bx],ax

        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@ZMINclipped

@@NOTinsideZMIN:
        cmp [Ev1Z],ZMIN             ;<---- ZMIN
        jge @@NOToutsideZMIN
               
        cmp [Ev2Z],ZMIN             ;<---- ZMIN
        jge @@NOToutsideZMIN

        jmp @@ZMINclipped

@@NOToutsideZMIN:
        cmp [Ev1Z],ZMIN             ;<---- XMIN
        jl @@NOTleavingZMIN
               
        cmp [Ev2Z],ZMIN             ;<---- XMIN
        jge @@NOTleavingZMIN

        mov ax,ZMIN
        sub ax,[Ev1Z]
        cwd
        mov cx,[Ev2Z]
        sub cx,[Ev1Z]
        
        mov bx,100
        imul bx
        idiv cx
        mov [t],ax

        mov bx,[CurrCPvert]                              ;<-- mark
        mov [CLIPpolygons.vertices.fZ+di+bx],ZMIN        

        mov ax,[Ev2X]                       ;<--- XMIN
        sub ax,[Ev1X]
        cwd
        mov cx,[t] 
        imul cx
        mov bx,100
        idiv bx
        
        add ax,[Ev1X]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax

        mov ax,[Ev2Y]                       ;<--- XMIN
        sub ax,[Ev1Y]
        cwd
        mov cx,[t] 
        imul cx
        mov bx,100
        idiv bx
        
        add ax,[Ev1Y]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax

        add [currCPvert],CLIPVSTRUC_SIZE

        jmp @@ZMINclipped

@@NOTleavingZMIN:
        cmp [Ev1Z],ZMIN             ;<---- XMIN
        jge @@ZMINclipped

        cmp [Ev2Z],ZMIN             ;<---- XMIN
        jl @@ZMINclipped
                                              
        mov ax,ZMIN
        sub ax,[Ev1Z]
        cwd
        mov cx,[Ev2Z]
        sub cx,[Ev1Z]
        mov bx,100
        imul bx
        idiv cx
        mov [t],ax

        mov bx,[CurrCPvert]                               ;<-- mark
        mov [CLIPpolygons.vertices.fZ+di+bx],ZMIN        

        mov ax,[Ev2X]
        sub ax,[Ev1X]
        cwd
        mov cx,[t] 
        imul cx
        mov bx,100
        idiv bx

        add ax,[Ev1X]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax

        mov ax,[Ev2Y]
        sub ax,[Ev1Y]
        cwd
        mov cx,[t] 
        imul cx
        mov bx,100
        idiv bx

        add ax,[Ev1Y]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fY+di+bx],ax

        
        add [currCPvert],CLIPVSTRUC_SIZE

        mov ax,[Ev2X]
        mov cx,[Ev2Y]
        mov dx,[Ev2Z]
        mov bx,[currCPvert]
        mov [CLIPpolygons.vertices.fX+di+bx],ax
        mov [CLIPpolygons.vertices.fY+di+bx],cx
        mov [CLIPpolygons.vertices.fZ+di+bx],dx   
        
        add [currCPvert],CLIPVSTRUC_SIZE
        
@@ZMINclipped:
        mov ax,[Ev2]
        mov [Ev1],ax
        inc [Ev2]
        
        jmp @@ZFORv2LTcNV

@@doneZMIN:
        mov ax,[currCPvert]
        cwd
        mov bx,CLIPVSTRUC_SIZE
        div bx
        mov [CLIPpolygons.numvertices+di],al
        
        mov al,[polygons.backfacerem+si]
        mov [CLIPpolygons.usebackface+di],al
        
        mov sp,bp
        pop bp
        ret
Zclip ENDP

