/*
dvlgfx.h
--------
my old gfx headers converted to djgpp from borland c++
by dhonn lushine (ludhonn@aol.com
warning:
 these gfx routines do not preform clipping. That 
 means it will write to out of double_buffer memory locations
 if you draw stuff that is out of the screen region.
 It may cause your computer to crash and/or loss of data.
 Please perform your own clipping functions. 
caution: 
 I am not reasponsible for damages.
*/

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <go32.h>
#include <dpmi.h>
#include <sys/farptr.h>

char double_buffer[64000]; 	/*
				every thing is drawn to the double buffer
				use the blit(char color) function to display 
				and clear it
				*/

#define putpixel(x,y,c) _farpokeb(_dos_ds,0xa0000+((y)<<8)+((y)<<6)+(x),(c))	/* these are slow dont use pixel functions */
#define getpixel(x,y) _farpeekb(_dos_ds,0xa0000+((y)<<8)+((y)<<6)+(x))

#define gettimer() _farpeekl(_dos_ds,0x46c)  /* get the 18.2hz timer valus */

void setvideo(short mode)	/* use setvideo(0x13) to set 320x200x256 and setvideo(3) to set text 80x25 */
{
 __dpmi_regs r;
 r.x.ax=mode;
 __dpmi_int(0x10,&r);
}

void blit(char color)
{
 dosmemput(double_buffer,64000,0xa0000); /* display double_buffer */
 memset(double_buffer,color,64000); /* clear the double buffer to color */
}

void vsync(void)		/* waits for vertical retrace */
{
 while((inp(0x3da)&8));
 while(!(inp(0x3da)&8));
}

void linev(int y1,int y2,int x,char color)
{
        if(y1>y2)
        {
                int temp=y1;
                y1=y2;
                y2=temp;
        }
        
        while(y1<=y2)
        {
                *(double_buffer+(y1<<8)+(y1<<6)+x)=color;
                y1++;
        }
}

void lineh(int x1,int x2,int y,char color)
{

        int i;
        if(x1>x2)
        {
         i=x1;
         x1=x2;
         x2=i;
        }
	memset((double_buffer+(y<<8)+(y<<6)+x1),color,x2-x1+1);
}

void lineb(int xo,int yo,int x1,int y1,char color)
{
        int     dx,
                dy,
                x_inc,
                y_inc=320,
                error=0,
                index;

        char* vb_start=double_buffer;


        if(yo>y1)
        {
         index=yo;
         yo=y1;
         y1=index;
         index=xo;
         xo=x1;
         x1=index;
        }

        dx=x1-xo;
        dy=y1-yo;

        if(dx>=0)
	{
		x_inc=1;
        }
	else
	{
		x_inc=-1;
                dx=-dx;
        }

	vb_start=vb_start+	((unsigned int)yo<<6)+
				((unsigned int)yo<<8)+
				((unsigned int)xo);

	if(dx>dy)
	{
		for(index=0;index<=dx;index++)
		{      
			*vb_start=color;

			error+=dy;
                      
			if(error>dx)
			{
				error-=dx;                              
                                vb_start+=y_inc;
                        }
			vb_start+=x_inc;
                }
        }
	else
	{
		for(index=0;index<=dy;index++)
		{
			*vb_start=color;

                        error+=dx;

			if(error>0)
			{
				error-=dy;
				vb_start+=x_inc;
                        }
			vb_start+=y_inc;
                }
        }
}

void rect(int x1,int y1,int x2,int y2,char c)
{
	linev(y1,y2,x1,c);
	linev(y1,y2,x2,c);
	lineh(x1,x2,y1,c);
	lineh(x1,x2,y2,c);
}


void filledrect(int x1,int y1,int x2,int y2,char c)
{
	if(y1>y2)
	{
		int temp=y1;
		y1=y2;
		y2=temp;
	}
	if(x1>x2)
	{
		int temp=x1;
		x1=x2;
		x2=temp;
	}

	while(y1<=y2)
	{
                lineh(x1,x2,y1,c);
		y1++;
	}
}

void fadeblack(int delay)
{
 unsigned int i,c[3],j,k,delay2;
 int time1;
 for(k=0;k<64;k++)
 {
  vsync();
  for(i=1;i<256;i++)
  {
   outportb(0x3c7,i);
   for(j=0;j<3;j++)
   { 
    c[j]=inportb(0x3c9);
    if(c[j]>0)
     c[j]--;
    else
     c[j]=0;
   }
   outportb(0x3c8,i);
   for(j=0;j<3;j++) outportb(0x3c9,c[j]);
  }
  delay2=gettimer()+delay;
  while(delay2>gettimer()){}
 }
}

