/* Routine to setup and compute colors */
/* for 16-color mode 		       */

/* Written by Dave Stampe Mar 21 1992 */

#include <stdio.h>
#include <dos.h>
#include "rend386.h"

			/* 320x200x16 screen definition */

struct Screeninfo screeninfo =
		 { 0, 0, 319, 199, 160, 100, 16, 8};

		     /* colors to use on screen */

int screen_clear_color = 15;
int wireframe_color    = 12;
int highlight_color    = 14;
int highest_color      = 15;

		     /* use linear palette instaed of EGA palette map */

static char rst_pal[16] = {0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63};

void read_palette(char *p)   /* save all palette map reg's */
{
	int i;
	union REGS regs;

	for (i = 0; i < 16; i++)
		{
		regs.x.ax = 0x1007;
		regs.h.bl = i;
		int86(0x10,&regs, &regs);
		p[i] = regs.h.bh;
		}
}


static void
set_rgb(int i, int r, int g, int b)   /* load DAC slot eq. to palette */
{
	union REGS regs;

	regs.x.ax = 0x1010;
	regs.x.bx = rst_pal[i];
	regs.h.dh = r;
	regs.h.ch = g;
	regs.h.cl = b;
	int86(0x10,&regs,&regs);
}



set_colors()               /* setup desired DAC palette */
{
	int i;

	read_palette(rst_pal);

	set_rgb(15,10,20,30);		/* screen background */
	for (i = 1; i < 16; i++)
	set_rgb(i-1, i*4, i*3+4, i*2+4);     /* brightnesses */
	return 0;
}



reset_colors()
{
	return 0;
}



extern int poly_cosine(void *p);  /* RETURNS 128*COS(LIGHT ANGLE) */

/* USER POLYGON LIGHTING ROUTINE: DETERMINES POLY COLOR # */

/* The 16-bit color the user specifies for a polygon is broken down as
   follows:
		 H R SS CCCC BBBBBBBB

   H is the highlight flag (the polygon should be highlighted in
   some way, usually by outlining it in the highlight_color given above).

   R is a reserved bit, which should be set to zero

   SS is a two-bit field specifying one of four surface types:

      00 is a constant-color surface; the 4-bit field CCCC is ignored, and the
	 8-bit field BBBBBBBB is used as an absolute color number

      01 is a cosine-lit surface; the 4-bit field CCCC specifies one of 16
	 basic colors, and the 8-bit brightness field BBBBBBBB is multiplied
	 by the cosine of the angle between the light source and the polygon's
	 surface normal to provide a 4-bit shading value.

      10 is a pseudo-metallic surface; the CCCC field gives the starting hue,
	 and the BBBBBBBB value is ignored.  The color will cycle through
	 the different shades to give a 'metallic' effect.

      11 is a pseudo-transparent surface made up of alternating rows of
	 spaced dots; other than that, it behaves like a pseudo-metallic
	 surface.

   This routine maps the above into an 8-bit color number in the low byte
   of its return value, and passes through the top four bits.

   16-COLOR NOTES:
   The above is the standard input, but mapping to 16-colors is
   difficult.  One method is to support only brightnesses and absolute
   colors (modulo 16).

 */

int user_poly_color(POLY *p, int pcolor)
{
	int hilite = pcolor & 0xF000;	   /* highlight flag  (MSB) */
	unsigned int bright = (pcolor>>1) & 0x7F;  /* mask out albedo (7 bits) */
	unsigned int color;

	if ((pcolor & 0x0F00)==0) return ((bright&15) | hilite);  /* abs. color */

	if ((pcolor & 0x3000) == 0)  /* fixed (unlit) color */
		{
		if(bright>14) bright = 14;
		return (hilite | bright);
		}

	color = ((poly_cosine(p)+200) * bright) / 0x0A20;

	if (color < 0)  return (hilite);
	if (color > 14) return (14 | hilite);
	return (color | hilite);
}


