/* Abstract pointer routine */

/* Written by Bernie Roehl, February 1992 */

/* The idea is that you have a pointing device with (up to) 6 degrees of
   freedom and (at least) two buttons */

/* There will be one of these modules for each possible pointing device;
   you link in the one you're using */

/* Eventually this should be a TSR, and you just call down to it (similar
   to how a mouse driver works) */
   
/* This version reads the mouse; if the right-hand button is down,
   vertical  motion gets mapped to forward/backward */

#include <stdio.h>
#include <dos.h>
#include "pointer.h"

pointer_init(int port, POINTER *pointer)
	{
	union REGS r;
	int i;
	pointer->port = port;
	pointer->gesture = pointer->buttons = 0;
	pointer->x = pointer->y = pointer->z = 0;
	pointer->pan = pointer->tilt = pointer->roll = 0;
	pointer->sx = pointer->sy = pointer->sz = 1;
	for (i = 0; i < 16; ++i) pointer->flex[i] = 0;
	r.x.ax = 0;
	int86(0x33, &r, &r);
	return r.x.ax;	
	}

pointer_read(POINTER *pointer)
	{
	union REGS r;
	unsigned oldbutt;
	oldbutt = pointer->buttons;
	r.x.ax = 3;  /* read button status */
	int86(0x33, &r, &r);
	pointer->buttons = r.x.bx;
	r.x.ax = 11;  /* read motion counters */
	int86(0x33, &r, &r);
	pointer->x += ((int) r.x.cx) * pointer->sx;
	if (pointer->buttons & 0x02)
		pointer->z -= ((int) r.x.dx) * pointer->sy;
	else
		pointer->y -= ((int) r.x.dx) * pointer->sz;
	pointer->buttons &= 0x01;
	return r.x.dx | r.x.cx | (pointer->buttons ^ oldbutt);  /* return non-zero if changed */
	}

void pointer_scale(POINTER *pointer, long sx, long sy, long sz)
	{
	pointer->sx = sx; pointer->sy = sy; pointer->sz = sz;
	}

void pointer_move(POINTER *pointer, long x, long y, long z)
	{
	pointer->x = x;  pointer->y = y;  pointer->z = z;
	}

void pointer_quit(POINTER *pointer)
	{
	}
