#ifdef FIXED_POINT
#define MAPW 0x20000
#define MAPH 0x20000
#define MAXMAPX 0x1FFFF
#define MAXMAPY 0x1FFFF
#define LOCATE_MAP(x, y) ((y>>8<<9)+(x>>8))
#else
#define MAPW 512
#define MAPH 512
#define MAXMAPX 511
#define MAXMAPY 511
#define LOCATE_MAP(x, y) ((ROUND(y)<<8)+ROUND(x))
#endif
#define MAPSIZE 65536*4
#define MAXANGLE 959
#define MAX_HEIGHT 255		//height of the terrain.
#define MAX_EYE_HEIGHT 30	//height of the eye from one's foot.
#define MAX_HEIGHT_DIFF 285     //max_height+max_eye_height.
#define ANGLE_RANGE 960
#define ANGLE_VIEW 320
#define MAXRAY_D 64

struct CONTROL {
long x, y;
short angle, quit;
};

class PLAYER {
long x, y;
short angle, rayangle, eye_distance;
short fheight, pheight, ray_length;

CONTROL control;
BYTE *image_data, * height_data;

public:
void adjust_x();
void adjust_y();
void adjust_raya();
void adjust_a();

void cast_one_ray(BYTE *vir, short column);
void draw_sky(BYTE *);
void evaluate_key();

BYTE get_color(VAR, VAR);
BYTE get_draw_pos(VAR, VAR, short);

void init_player(short newx=100, short newy=100, short newangle=0);

short quit();

void ray_cast(BYTE *);

void update_key();
};


extern BYTE HEIGHT_IN_VIEW[MAX_HEIGHT+MAX_HEIGHT_DIFF+1][MAXRAY_D];  
extern BYTE RANDOM_TBL[64000]; 
extern VAR SIN[ANGLE_RANGE];
extern VAR COS[ANGLE_RANGE];
extern WORD *SCREEN_TBL;
extern BYTE *MAP_DATA;
extern BYTE *MAP_HEIGHT_DATA;

