#include<fcntl.h>
#include<unistd.h>
#include<stdlib.h>
#include<stdio.h>
/*palette setup:
  0-31 blue
  32-63 green
  64-95 brown
  96-127 grey
  128-159 yellow
  128-- image
 */
#define BLUE 0
#define LIGHT_BLUE 25
#define DARK_BLUE  14
#define GREEN 32
#define BROWN 64
#define GREY  96
#define IMAGE 128
#define COLOR_RANGE 32

#define BYTE unsigned char
void setup_pal(BYTE * pal)
  {
  short i;
  short color_step=64/COLOR_RANGE;
  short init=0;
  short end=init+COLOR_RANGE/2;
  
  //setup dark blue.
  for (i=init; i<end; i++)
    { pal[i*3]=0; pal[i*3+1]=0; pal[i*3+2]=i*color_step*2; }
  
  init=end;
  end+=COLOR_RANGE/2;
  //setup light blue
  for (i=init; i<end; i++)
    { pal[i*3]=0; pal[i*3+1]=i*color_step*2; pal[i*3+2]=63; }
  
  init=end; end+=COLOR_RANGE;
  //setup green.
  for (i=init; i<end; i++)
    { pal[i*3]=0; pal[i*3+1]=(i-init)*color_step; pal[i*3+2]=0; }
    
  init=end; end+=COLOR_RANGE;
  long j;
  //setup brown.
  for (i=init, j=0; i<end; i++, j++)
    { pal[i*3]=j*color_step; pal[i*3+1]=j*color_step*2/3; pal[i*3+2]=j*color_step/2; }
  
  init=end; end+=COLOR_RANGE;    
  //setup grey. 
  for (i=init, j=0; i<end; i++, j++)
    { pal[i*3]=j*color_step; pal[i*3+1]=j*color_step; pal[i*3+2]=j*color_step; }
  
  for (i=end; i<255; i++)
    { pal[i*3]=0; pal[i*3+1]=0; pal[i*3+2]=0;}  
 }     


void set_water_world(BYTE *image, BYTE *hindex, short width, short height)
 {
  long i;
  long max=(long)width*height;
  for (i=0;  i<max; i++)
    {
     if (random()%10>1)
     image[i]=random()%3+LIGHT_BLUE+3;
     else
     image[i]=random()%6+LIGHT_BLUE;
     hindex[i]=random()%4;
    }
 }
  
  
short write_raw(char *name, short width, short height, BYTE *image, BYTE *pal)
  {
   int handle;

   if((handle=open(name, O_CREAT|O_WRONLY|O_BINARY))==-1)     //open source file.
    {
     perror(name);
     return 0;
    }

   write(handle, &width, sizeof(short));
   write(handle, &height, sizeof(short));

   write(handle, pal, 256*3);
   write(handle, image, width*height);
   close(handle);
   return 1;
  } 
  
   main()
    {
    BYTE pal[768];
    setup_pal(pal);  
    short width=256, height=256;
    BYTE *image=new BYTE[(long)width*height];
    BYTE *hindex=new BYTE[(long)width*height];
    
    set_water_world(image, hindex, width, height);
    if(!write_raw("view.raw", width, height,  image, pal)) printf("\nwrite error.");
    if(!write_raw("height.raw", width, height, hindex, pal)) printf("\n write error.");
    return 1;
    }