//main.cc
#include<stdlib.h>
#include<conio.h>
#include<stdio.h>
#include<time.h>

#include "define.h"
#include "screen.h"
#include "field.h"
#include "draw.h"

#define VIEW_CONSTANT 20

BYTE HEIGHT_IN_VIEW[MAX_HEIGHT+MAX_HEIGHT_DIFF+1][MAXRAY_D];  
BYTE RANDOM_TBL[64000]; 
BYTE *MAP_DATA;
BYTE *MAP_HEIGHT_DATA;
VAR SIN[ANGLE_RANGE];
VAR COS[ANGLE_RANGE];

void init_data(BYTE * pal)
  {
   long i;
   //initial height_in_view
   for (i=0; i<MAX_HEIGHT+MAX_HEIGHT_DIFF+1; i++)
     {
     
     for (short j=1; j<MAXRAY_D; j++)
       {
       //get the height of perspective, find the start drawing position.
       float value=(float)(CENTERY+40)-(float)VIEW_CONSTANT*(i-MAX_HEIGHT_DIFF)/j;
       if (value>MAXY) value=MAXY;
       if (value<0) value=0;
   
       HEIGHT_IN_VIEW[i][j]=(short)value;
       }
     }
   
   //setup random table.
   for (i=0; i<64000; i++)
     RANDOM_TBL[i]=random()%5;
   
   //precalculate sin, cos value.
   double angle_ratio=6.2831852/ANGLE_RANGE;
   for (i=0; i<ANGLE_RANGE; i++)
     {
     SIN[i]=(VAR)(sin(angle_ratio*i)*X2O(1)+X2O(1)/512);
     COS[i]=(VAR)(cos(angle_ratio*i)*X2O(1)+X2O(1)/512);
     }
   
   calculate_screen_tbl();
   
   MAP_DATA=new BYTE[MAPSIZE];   
   MAP_HEIGHT_DATA=new BYTE[MAPSIZE];
   
   getraw("height.raw", MAP_HEIGHT_DATA, pal);
   getraw("ground.raw", MAP_DATA, pal);
  }

main()
  {
   PLAYER cur;
   BYTE pal[768];
   
   init_data(pal);
   
   setmode320x200x256();
   modDAC(0, pal, 256);
   
   BYTE *vir=new BYTE[BPL*SCREEN_HEIGHT];
   cur.init_player();
   clock_t start, end;

   start=clock();
   long frame=0;
 
   while (!cur.quit()) 
     {
      frame++;
      cur.draw_sky(vir);  
      cur.ray_cast(vir);
      cur.evaluate_key();
      cur.update_key();
      memtoscn256(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, vir);
     }
   end=clock();
  
   printf("%d frames, %d fps.", frame, frame*CLOCKS_PER_SEC/(end-start));

   setmode(0x03);
   }
      
   
  

