/*the actually raycast routines.
                                --programmed by Pin Fei Sun
*/
#include <pc.h>
#include<conio.h>
#include<stdlib.h>
#include<stdio.h>
#include<string.h>

#include"define.h"
#include"screen.h"
#include"field.h"
#include"draw.h"

#define draw_vline(x, y, z) \
		 __asm__ __volatile__ (  \
		 "loop1: \
		 movb  %%al, (%0); \
	         subl  $320, %0; \
	         dec  %1; \
	         jnz loop1" \
	          : "=r"(x) \
	          : "r"(y), "0"(x), "a"(z)  \
	          : "%eax")
	
//ray_length+eye_distance<MAXRAY_D, fheight<=MAX_HEIGHT_DIFF
void  PLAYER::init_player(short newx, short newy, short newangle)
  {
  x=INT_TO_VAR(newx);
  y=INT_TO_VAR(newy);
  angle=newangle;
  eye_distance=1;
  fheight=30;
  ray_length=62;
  image_data=MAP_DATA;
  height_data=MAP_HEIGHT_DATA;
  }
 
  
void PLAYER::draw_sky(BYTE *vir)
  {
  memset(vir, 0, 64000);
  }
  
void PLAYER::evaluate_key()
   {
      short bk_key=0;
      control.x=0; control.y=0; control.angle=0; control.quit=0;
      if (kbhit())
        bk_key=getch();
      switch(bk_key)
	  {
	  case 56: control.x=SIN[angle]; control.y=COS[angle]; break;
	  case 50: control.x=-SIN[angle];control.y=-COS[angle];break;
	  case 52: control.angle=10; break;
	  case 54: control.angle=-10; break;
	  case 'q': control.quit=1; break;
	  default:;
	  }

   }


short PLAYER::quit()
  {
   if (control.quit) return 1;
   return 0;
  }

void PLAYER::adjust_x()
  {
  #ifdef FIXED_POINT
   x=x&MAXMAPX;
  #else
  if (x<0) x+=MAPW;
  if (x>MAXMAPX) x-=MAPW;
  #endif
  }
  

void PLAYER::adjust_y()
  {
  #ifdef FIXED_POINT
    y=y&MAXMAPY;
  #else
  if (y<0) y+=MAPH;
  if (y>MAXMAPY) y-=MAPH;
  #endif
  }


void PLAYER::adjust_a()
  {
  if (angle<0) angle+=ANGLE_RANGE;
  if (angle>MAXANGLE) angle-=ANGLE_RANGE;
  }  

void PLAYER::adjust_raya()
  {
  if (rayangle<0) rayangle+=ANGLE_RANGE;
  if (rayangle>MAXANGLE) rayangle-=ANGLE_RANGE;
  }
  

void PLAYER::update_key()
  {
  short tmp;
  VAR tmx, tmy;
  x+=control.x; y+=control.y; angle+=control.angle;
  adjust_a();
  adjust_x();
  adjust_y();
  
  fheight=height_data[LOCATE_MAP(x, y)]+15;
  }


BYTE PLAYER::get_color(VAR rayx, VAR rayy)
  {
  return image_data[LOCATE_MAP(rayx, rayy)];
  }



BYTE PLAYER::get_draw_pos(VAR rayx, VAR rayy, short ray_distance)
  {
  BYTE h;
  h=height_data[LOCATE_MAP(rayx, rayy)];

  short difference=h-fheight+MAX_HEIGHT_DIFF;
  return HEIGHT_IN_VIEW[difference][ray_distance];
  }



void PLAYER::cast_one_ray(BYTE *vir, short column)
  {
  VAR rayx, rayy, rayxstep, rayystep;
  short ray_distance=1;
  
  register BYTE i=ray_length;  
  
  //calculate initial ray position.
  rayx=x+(SIN[rayangle]);
  rayy=y+(COS[rayangle]);

  #ifdef FIXED_POINT
    rayx=rayx&MAXMAPX;
    rayy=rayy&MAXMAPY;
  #else
  if (x<0) x+=MAPW;
  if (x>MAXMAPX) x-=MAPW;
  if (rayy<0) rayy+=MAPH;
  if (rayy>MAXMAPY) rayy-=MAPH;
  #endif

      //calculate steps to add for current rays
  rayxstep=SIN[rayangle];
  rayystep=COS[rayangle];
 

  BYTE draw_pos;    
  BYTE max_pos=199;
  
  long pos=(long)vir+SCREEN_TBL[max_pos]+column;  
  BYTE color;
  long length;

  while(i) 
    {

      //get height, returned must be prebuilted to be <=MAXY.
      //randomize it next.
      draw_pos=get_draw_pos(rayx, rayy, ray_distance);
      color=get_color(rayx, rayy);
      
      length=max_pos-draw_pos;
      if (length>0)
	 {
//	 draw_vline(pos, length, color);

//C routine of drawing.
         while (length)
         {
         *(BYTE *)pos=color;
  	 pos-=SCREEN_WIDTH;
  	 length--;
  	 }         

         max_pos=draw_pos;
        } 
      
      rayx+=rayxstep;
      rayy+=rayystep;

      #ifdef FIXED_POINT
      rayx=rayx&MAXMAPX;
      rayy=rayy&MAXMAPY;
      #else
      if (x<0) x+=MAPW;
      if (x>MAXMAPX) x-=MAPW;
      if (rayy<0) rayy+=MAPH;
      if (rayy>MAXMAPY) rayy-=MAPH;
      #endif
      ray_distance++;
      i--;

     }
}  
    


void PLAYER::ray_cast(BYTE *vir)
  {
  short half_view=ANGLE_VIEW/2;
  rayangle=angle+half_view;	//find left ray.
  adjust_raya();
  short i;
  
  for (i=0; i<ANGLE_VIEW; i++)
    {

    //cast the ray.
    cast_one_ray(vir, i);
    //move to another ray.
    rayangle--;    
    adjust_raya();
    }
  }
  
  
  
  
  