/*all the video handling stuff
                              --programmed by Pin Fei Sun
*/

#include<dos.h>
#include<stdio.h>
#include<sys\movedata.h>
#include <go32.h>

#include "define.h"
#include "screen.h"

long END_VRAM, ST_VRAM;	//end of video ram, start of video ram(for bank switch
			//purpose.
short BANK_INC, GRAN;	//bank to increase, granulity.


short bankSwitch(short v)
  {
  REGS in, out;
  in.w.ax=0x4F05;
  in.w.bx=0;
  in.w.dx=v;
  int86(0x10, &in, &out); 
  
  if (out.w.ax!=0x004F)
    return 0;
    
  ST_VRAM=GRAN-(0xB0000-END_VRAM);
  END_VRAM=0xB0000-(0xB0000-ST_VRAM)%SCREEN_WIDTH;
  BANK_INC=(END_VRAM-ST_VRAM)/GRAN;
  return 1;
  }



/************************
  modify content in DAC.
  initial = index of first register to be modified.
  buf = buffer contains data in a sequence same as how the hardware
	works.(RED, GREEN, BLUE).
  numbers = number of register to be modified.
  ************************/
void modDAC(unsigned char initial, BYTE  *buf, int numbers)
{
int i;
outportb(0x3C8, initial);
int sub=numbers*3;

for(i=0;i<sub;i++)
outportb(0x3C9, buf[i]);

}


//move data in mem to screen block start at (x, y) with width and height
//specified.
void memtoscn256(int x, int y, int width, int height, BYTE   *mem)
{
unsigned source_selector=_my_ds();
unsigned source_offset= (unsigned)mem;
unsigned dest_selector=_go32_conventional_mem_selector();
unsigned dest_offset=0xA0000+y*SCREEN_WIDTH+x;
int lwidth=width/4;

for (long i=0; i<height; i++)
   {
   _movedatal(source_selector, source_offset, dest_selector, dest_offset, lwidth);
   dest_offset+=SCREEN_WIDTH;
   source_offset+=width;
   }
   
}



void memtoscn256b(int x, int y, int width, int height, BYTE   *mem)
{
//set up selectors and offsets.
unsigned source_selector=_my_ds();
unsigned source_offset= (unsigned)mem;
unsigned dest_selector=_go32_conventional_mem_selector();

//setup start bank, and screen offset
long offset=y*SCREEN_WIDTH+x;
short bank=offset/GRAN;
offset=offset%GRAN;
unsigned dest_offset=0xA0000+offset;

int lwidth=width/4;

bankSwitch(bank);

ST_VRAM=dest_offset;
END_VRAM=0xB0000-(0xB0000-ST_VRAM)%SCREEN_WIDTH;
BANK_INC=(END_VRAM-ST_VRAM)/GRAN;


for (long i=0; i<height; i++)
   {
   //paint the screen one line at a time.
   _movedatal(source_selector, source_offset, dest_selector, dest_offset, lwidth);
   dest_offset+=SCREEN_WIDTH;
   //update bank when needed.
   if (dest_offset>=END_VRAM)
     {
      bank+=BANK_INC;
      bankSwitch(bank); 
      dest_offset=ST_VRAM;
     }
     
   source_offset+=width;
   }
}



void setmode(unsigned char mode)
  {
   REGS in;
   REGS out;
   in.x.ax=mode;
   int86(0x10, &in, &out);
  }
  

void setmode320x200x256()
{
  setmode(0x13); 
}



short setmode640x480x256()
  {
     REGS in;
     REGS out;
     in.w.ax=0x4F02;
     in.w.bx=0x101;
   
     int86(0x10, &in, &out);
     
     if (out.w.ax!=0x004F)
     return 0;
   
     GRAN=0x1000;  //4k

     return 1; 
   }



