#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <conio.h>
#include "C:\WATCOM\LEARN\HOZIELIB\graphics.h"
#include "keybrd.h"
#include "wadio.h"
#include "globals.h"
#include "doombsp.h"
#include "jmouse.h"

#define LSlowTrans

void    parse_args( int  argc, char *argv[]);
void    TransverseWorld( SavedNodeT_Ref current_node);
void    ShowVisibleMap();
void    DrawPlayer();
void    Draw();

extern char     NumWalls[320];
extern WallRec   Walls[320][64];

float    Sin[1024],Cos[1024];
short    dummy;

void Startup_Mouse(){
        MOUSE_INT = COM1_INT;
        MOUSE_PORT = COM1_BASE;
        
        if (Init_Mouse())   printf("Mouse Installed.\n");
           else printf("Mouse ignored.\n");
}


int     BuildMathTables( ){
 float  radinc = 6.2831853 / NumAngles;
 float  rad    = 1e-7;
 int    i;
        for (i=0; i < NumAngles; i++, rad+=radinc){
            Sin[i] = (float)(  sin(rad) );
            Cos[i] = (float)(  cos(rad) );
            Tan[i] = (float)(  tan(rad) );
        }
        for (i=1; i <= MaxZ+1; i++)
                ztable[i-1] = Scale / i;
        return 1;
}



void    main(int argc, char *argv[]){

  SetVmode(0x03);
  parse_args( argc, argv);
  
  #ifndef DEBUG
        printf("Running HOZIE DOOM version %s.\n",VER);
  #endif

        pStep=4;
        AngInc=256;
        HeroHeight=40;

        Startup_Mouse();

        if (!BuildMathTables()) WadError("Couldn't Initilize Math Tables");
        memset( VisSegs, 0, sizeof(VisSegs));
        free(Dir);
        showmap = 0;
        SetVmode(0x13);
//        LoadDoomPal();
        InitKey();
        t0 = *Time;

//px =  1834; py=-1173; pang =  8192;

while (!keys[ESC]){
        pCos = Cos[ (unsigned short)pang >> AngDif];
        pSin = -Sin[ (unsigned short)pang >> AngDif];
        LeftAng = (unsigned short)pang + Deg30 + 1024;
        memset( &ColDone, 0, sizeof(ColDone)); CurrentSector=1; StripsDone=0;
        memset( &NumWalls, -1, sizeof(NumWalls) );
        if (showmap){
           memset( &MyScreen[0], 0, 64000);
           ShowVisibleMap();
           DrawPlayer();
        }
        else{
//           memset( &MyScreen[0], 0x14, 32000);
//           memset( &MyScreen[32000], 0x17, 32000);
           TransverseWorld( &Nodes[NumNodes-1]);
           Draw();
           NumFrames++;
        }
        
        memcpy( ScreenPtr, MyScreen, 64000);

        if (keys[INS])
                HeroHeight += 2;

        if (keys[DEL])
                HeroHeight -= 2;

        if (keys[L_SHIFT] || keys[R_SHIFT]){
                pStep = 16;
                AngInc = 1024;
        }
        else {
                pStep = 4;
                AngInc = 256;
        }

        if (keys[UP] || mouse_left ) {px += (short)(pCos * pStep);
                       py -= (short)(pSin * pStep);
                       }
        if ( keys[DOWN]){px-= (short)(pCos * pStep);
                        py+= (short)(pSin * pStep);
                       }
        
    if (keys[ALT]){
        if (keys[LEFT]){
           px += (short) pStep * Cos[ (unsigned short)(pang+Deg90) >> AngDif];
           py += (short) pStep * Sin[ (unsigned short)(pang+Deg90) >> AngDif];
        }
        if (keys[RIGHT]){
           px += (short) pStep * Cos[ (unsigned short)(pang-Deg90) >> AngDif];
           py += (short) pStep * Sin[ (unsigned short)(pang-Deg90) >> AngDif];
       }
    }
    else{
        if ( keys[LEFT])
           pang+= AngInc;
        if (keys[RIGHT])
           pang-= AngInc;
    }

//       if (mouse_dy > 0) mouse_dy <<= 2;
       if (mouse_dy < 0) mouse_dy >>= 1;
       px += (int)(mouse_dy*-pCos);
       py += (int)(mouse_dy*pSin);

       if (mouse_dx > 0){
           mouse_dx <<= 5;
           pang -= mouse_dx;
       }
       else if (mouse_dx < 0){
           mouse_dx <<= 4;
           pang -= mouse_dx;
       }

       mouse_dx=mouse_dy = 0;

        if (keys[TAB]){
           showmap = !showmap;
           for (dummy=1; dummy <= 10; dummy++)
               WaitRetrace();
        }

}
        SetVmode(0x03);
        UninstallKey();
        Clean_Up_Mouse();
        EndIt();
}
