/***************************************************************************
*
*               this simply rotates the y coordinates , clips and                
*               then (vertically) scan converts the polygon using 
*               16.16 fixedpoint.
****************************************************************************/

#include "doombsp.h"
#include "globals.h"

char     NumWalls[320];
WallRec   Walls[320][64];

#define FIXSHIFT        16
#define FIXMUL          (1<<FIXSHIFT)

void    DoWall( ){
  int       x,dx,n;
  float     fTopSlope,fBottomSlope,fdy, fSy1,fSy2,fSy3,fSy4;
  long      TopSlope,BottomSlope,dy, Sy1,Sy2,Sy3,Sy4;
  WallRec       *wall;
  char    *texture_base;

        if (tn != TRANSPARENT)
                texture_base = Textures[tn].texture;
        else
                texture_base = NULL;

        num_polygons++;
          fSy1 = yCenter - wt*z1;
          fSy4 = yCenter - wb*z1;
          fSy2 = yCenter - wt*z2;
          fSy3 = yCenter - wb*z2;

          if (Sx1 < 0){
             fSy1 += (0-Sx1) * (fSy2-fSy1) / (Sx2-Sx1);
             fSy4 += (0-Sx1) * (fSy3-fSy4) / (Sx2-Sx1);
             Sx1  = 0;
          }
          if (Sx2 > 319){
             fSy2 -= (Sx2-319) * (fSy2-fSy1) / (Sx2-Sx1);
             fSy3 -= (Sx2-319) * (fSy3-fSy4) / (Sx2-Sx1);
             Sx2 = 319;
          }

          dx = Sx2-Sx1;
          fdy = fSy2-fSy1;

          if (dx != 0){
             fTopSlope = fdy/dx;
             fBottomSlope = (fSy3-fSy4)/dx;
          }
          else return;

          Sy1 = fSy1 * FIXMUL;
          Sy2 = fSy2 * FIXMUL;
          Sy3 = fSy3 * FIXMUL;
          Sy4 = fSy4 * FIXMUL; 
          TopSlope = fTopSlope * FIXMUL;
          BottomSlope = fBottomSlope * FIXMUL;
          dy = fdy * FIXMUL;
          

//I don't like the Sy1<199 & Sy4 > 0 below!!!!!!!!!1

          for (x=Sx1; x<=Sx2; x++){
              if ( (!ColDone[x]) && (Sy1 < (199 << FIXSHIFT) ) && (Sy4 > 0)){
                 NumWalls[x]++;
                 n = NumWalls[x];
                     wall = &Walls[x][n];

                 wall-> Type = WallType;
                 wall-> texture = texture_base;
                 wall-> TextNum = tn;
                 wall-> FloorNum = fn;
                 wall-> CeilingNum = cn;
                 wall-> tx = tStartx;
                 wall-> ty = tStarty;

                 if ( Sy1 < 0)
                    wall->Start = 0;
                 else wall->Start = (char)(Sy1 >> FIXSHIFT);

                 if ( Sy4 > (200 << FIXSHIFT))
                    wall->Stop  = 200;
                 else wall->Stop  = (char)(Sy4 >> FIXSHIFT);
                 VisSegs[ SegIndex] = 1;
              }
              Sy1 += TopSlope;
              Sy4 += BottomSlope;
          }
}         


#undef FIXSHIFT        
#undef FIXMUL          
