#include        <stdlib.h>
#include        <dos.h>
#include        <i86.h>
#include        "dpmi.h"

/************ All FUNCTIONS RETURING int RETURN 0 ON FAILURE, 1 ON SUCCESS UNLESS NOTED ********/

DPMI_SELECTOR DPMI_seg2descriptor( DPMI_SEGMENT seg){
        union REGS r;

        r.w.ax = 0x02;
        r.w.bx = seg;
        int386( 0x31, &r, &r);
        if (r.w.cflag) return 0;
        return r.w.ax;
}

long    DPMI_get_linear_segment_address( DPMI_SELECTOR sel){
        union REGS r;

        r.w.ax = 0x06;
        r.w.bx = sel;
        int386( 0x31, &r, &r);
        if (r.w.cflag) return 0xFFFFFFFF;
        return ( (r.w.cx << 16) + (r.w.dx) );
}

DPMI_SELECTOR   DPMI_alias_code_segment( DPMI_SELECTOR codeseg){
        union REGS r;

        r.w.ax = 0x0A;
        r.w.bx = codeseg;
        int386( 0x31, &r, &r);
        if (r.w.cflag) return 0;
        return r.w.ax;  
}

int     DPMI_dos_malloc( int    num_bytes, DPMI_SEGMENT *segment, DPMI_SELECTOR *selector){
        union REGS r;

        r.w.ax = 0x100;
        r.w.bx = (num_bytes+0xF) >> 4;
        int386( 0x31, &r, &r);
        if (r.w.ax==7 || r.w.ax==8) return 0;
        *segment = r.w.ax;
        *selector = r.w.dx;
        return 1;
}

void    DPMI_dos_free( short selector){
        union   REGS r;

        r.w.ax = 0x101;
        r.w.dx = selector;
        int386( 0x31, &r, &r);
}

void    DPMI_get_rmode_interrupt_vector( char int_num, DPMI_SEGMENT *seg, DPMI_OFFSET *ofs){
        union REGS r;

        r.w.ax = 0x200;
        r.h.bl = int_num;
        int386( 0x31, &r, &r);
        *seg = r.w.cx;
        *ofs = r.w.dx;
}

int     DPMI_set_rmode_interrupt_vector( char int_num, DPMI_SEGMENT seg, DPMI_OFFSET ofs){
        union REGS r;

        r.w.ax = 0x201;
        r.h.bl = int_num;
        r.w.cx = seg;
        r.w.dx = ofs;
        int386( 0x31, &r, &r);
        if (r.w.cflag) return 0;
        return 1;
}

void    DPMI_get_pmode_interrupt_vector( char int_num, DPMI_SELECTOR *sel, DPMI_POFFSET *ofs){
        union REGS r;

        r.w.ax = 0x204;
        r.h.bl = int_num;
        int386( 0x31, &r, &r);
        *sel = r.w.cx;
        *ofs = r.x.edx;
}

int     DPMI_set_pmode_interrupt_vector( char int_num, DPMI_SELECTOR sel, DPMI_POFFSET ofs){
        union REGS r;

        r.w.ax = 0x205;
        r.h.bl = int_num;
        r.w.cx = sel;
        r.x.edx = ofs;
        int386( 0x31, &r, &r);
        if (r.w.cflag) return 0;
        return 1;
}

float   DPMI_get_ver(){
        union REGS r;

        r.w.ax = 0x400;
        int386( 0x31, &r, &r);
        return ( r.h.ah + r.h.al*0.10);
}

void   *DPMI_malloc(long size, long *Handle){
       union REGS r;

       r.w.ax = 0x501;
       r.w.bx = size >> 16;
       r.w.cx = size & 0xFFFF;
       int386( 0x31, &r, &r);       
       if (r.w.cflag) return NULL;
       *Handle = ((r.w.si<<16) + (r.w.di));
       return (void *)( (r.w.bx<<16) + (r.w.cx));
}

void   DPMI_free(long Handle){
       union REGS r;

       r.w.ax = 0x502;
       r.w.si = Handle >> 16;
       r.w.di = Handle & 0xFFFF;
       int386( 0x31, &r, &r);
}
