 #ifndef __GLOBALS_H

#define __GLOBALS_H

#include <stdio.h>
#include "wadio.h"

#define NumAngles       1024
#define AngDif          6

#define xCenter         160
#define yCenter         100

#define MinZ            0.5
#define MaxZ            9999
#define Scale           159.0

#define UPPER           0x0
#define MAIN            0x1
#define LOWER           2
#define TRANSPARENT     0xFFFF


typedef struct  _Wallr{
        char  Start,Stop;        
        char  Type;
        char  *texture;
unsigned short TextNum;          // if TextNum == -1 wall is transpanent, i.e.
                                // is only used for floors and ceilings
unsigned short CeilingNum;       // if bit 15 set then a ceiling is defined here
                                //  ...other 15 are the Index
unsigned short FloorNum;         // if bit 15 set then a floor is defined here
        char  tx,ty;            
        } WallRec;

typedef struct __TEXTURET{
        char             *texture;
        unsigned short   width;
        unsigned short   height;
} TEXTURET;

//----------------------GLOBAL VARIABLES--------------------------------
extern unsigned long  *Time;
extern unsigned long  t0,t1;
extern unsigned int   NumFrames;

extern int         pStep, AngInc, HeroHeight;
extern short       px,py,pang;
extern short       xMin, xMax, yMin, yMax, absMinx, absMiny;
extern float       xScale, yScale;

extern ThingT      *Things;
extern LineT       *Lines;
extern VertexT     *Vertex;
extern SavedNodeT  *Nodes;
extern SideDefT    *Sides;
extern SegT        *Segs;
extern SSectorT    *SSectors;
extern SectorT     *Sectors;
extern char        *Reject;
extern BlockMapHT  BlockMapHeader;
extern unsigned short *BlockOfs;
extern short       *BlockMap;

extern short       NumThings, NumLines, NumVerticies, NumSegs, NumNodes;
extern short       NumSides, NumSSectors, NumSectors, NumBlocks;
extern long        RejectSize, BlockMapSize;
extern long        NumTextures;
extern TEXTURET    Textures[MAX_TEXTURES];

extern float   Tan[1024],ztable[MaxZ],pCos,pSin;
extern char    MineScreen[200][320], VisSegs[MaxSegs];
extern char     *MyScreen;
extern int     showmap ;
extern unsigned short    LeftAng;

extern unsigned long num_polygons;

#endif
