#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <i86.h>
#include <conio.h>
#include "graphics.h"

char *ScreenPtr = (char *)0xA0000;

void SetVmode( char modenum){
    union REGS r;

        r.h.ah = 0x00;
        r.h.al = modenum;
        int386( 0x10, &r, &r);
}        
              
void SetPal( char index, PalRecPtr pal){
    outp( 0x3C8, index);
    outp( 0x3C9, pal->r);
    outp( 0x3C9, pal->g);
    outp( 0x3C9, pal->b);
}

void GetPal( char index, PalRecPtr pal){
    outp( 0x3C7, index);
    pal->r = inp( 0x3C9);
    pal->g = inp( 0x3C9);
    pal->b = inp( 0x3C9);
}


void WaitRetrace(){
       while ( inp(0x3DA) & 0x08 );
       while ( !(inp(0x3DA) & 0x08) );
}

void LoadPal (char Name[128])
{
short            i;
FILE            *InFile;
PalRec          Pallete[256];

InFile = fopen(Name, "rb");
fseek(InFile, -768, SEEK_END);
fread(Pallete, 1, 768, InFile);
for (i = 0; i < 256; i++) {
        SetPal(i, &Pallete[i]);
        }        
}

void GrayScale()
{
short   i;
PalRec   Pal;

for (i = 0; i < 256; i++)
        {
        GetPal(i, &Pal);
        Pal.r = (int)((Pal.r + Pal.g + Pal.b) / 3);
        Pal.g = Pal.r;
        Pal.b = Pal.r;
        SetPal(i, &Pal);
        }
}

void Line ( char *Where, short x1, short y1, short x2, short y2, char color){
#define lfs 16
#define LScreen(x,y) Where[ ((y)<<6) + ((y)<<8) + (x) ]
//--------Below is a nice way to avoid having to round the 16.16 number
#define HalfLinePixel (1 << (lfs-1) )
     register long incX,incY;
     register long x = x1;
     register long y = y1;
     long dx = x2 - x1;
     long dy = y2 - y1;

     if ( (dx==0) && (dy==0) ) return;

     if (abs(dx) > abs(dy) ) {
        y <<= lfs;
        y += HalfLinePixel;
        if (y1 < y2) incY = abs( (dy << lfs) / dx);
           else incY = -abs( (dy << lfs) / dx);
        if (x1 < x2) incX = 1;
           else incX = -1;
        while (x != x2){
           LScreen(x,y >> lfs) = color;
           x += incX;
           y += incY;
        }
        LScreen(x,y >> lfs) = color;
     }
     else{
        x <<= lfs;
        x += HalfLinePixel;
        if (x1 < x2) incX = abs( (dx << lfs) / dy);
           else incX = -abs( (dx << lfs) / dy);
        if (y1 < y2) incY = 1;
           else incY = -1;
        while (y != y2){
           LScreen( x >> lfs, y) = color;
           x += incX;
           y += incY;
        }
        LScreen( x >> lfs, y) = color;
     }
}

void Rectangle ( char *Where, short xmin,short ymin, short xmax, 
                short ymax, short color){
    int  dx = xmax - xmin;
    char *Base, *Stop;

    Base = Stop = Where + xmin;
    Base += (ymin<<6) + (ymin<<8);
    Stop += (ymax<<6) + (ymax<<8); 

    for (; Base <= Stop; Base+=320)
         memset( Base, color, dx);
}
