.386p

; .MODEL FLAT

MOUSE_PORT      EQU     3F8h

MOUSE_MIN_X     EQU     0
MOUSE_MIN_Y     EQU     0
MOUSE_MAX_X     EQU     319
MOUSE_MAX_Y     EQU     199

_DATA   SEGMENT DWORD PUBLIC 'DATA'
        PUBLIC  _mouse_bytes
        PUBLIC  _mouse_x
        PUBLIC  _mouse_y
        PUBLIC  _mouse_dx
        PUBLIC  _mouse_dy
        PUBLIC  _mouse_left
        PUBLIC  _mouse_right
_mouse_temp     LABEL BYTE
                db      ?
_mouse_byte_num LABEL BYTE
                dd      0
_mouse_bytes    LABEL BYTE
                db      3 dup(0)
_mouse_x        LABEL BYTE
                dw      160
_mouse_y        LABEL BYTE
                dw      100
_mouse_dx       LABEL BYTE
                dw      0
_mouse_dy       LABEL BYTE
                dw      0
_mouse_left     LABEL BYTE
                db      0
_mouse_right    LABEL BYTE
                db      0
_DATA   ENDS

SCALE_DX macro
        sar     ax,2
        endm

SCALE_DY macro
        sar     ax,2
        endm

_TEXT   SEGMENT BYTE PUBLIC 'CODE'
        ASSUME CS:_TEXT
        PUBLIC Mouse_ISR_

Mouse_ISR_:
        pushad
        push    ds

        mov     bx, _DATA
        mov     ds, bx

        ASSUME ds:_DATA

        mov     dx, MOUSE_PORT
        in      al, dx                  ;read new mouse input
        test    al, 01000000b
        jz      NOT_NEW                 ;is a new sequence?
        mov     DWORD PTR _mouse_byte_num, 0
NOT_NEW:
        mov     ebx, DWORD PTR _mouse_byte_num
        mov     BYTE PTR _mouse_bytes[ebx],al   ;store new data in array
        inc     DWORD PTR _mouse_byte_num

        cmp     DWORD PTR _mouse_byte_num, 000000003h
        jne     MORE_LEFT
;
;              here means that there are no more packets left
;
        xor     eax,eax                 ;clear what
        xor     ebx,ebx                 ;we're gonna need

        mov     bl, BYTE PTR _mouse_bytes
        and     bl,03h
        shl     bl,6                    ;top 2 dx bits
        mov     bh, BYTE PTR _mouse_bytes+1
        and     bh,2fh                  ;bh = bottom 6 dx bits
        or      bl,bh                   ;bl = dx
        xor     bh,bh                   ;zero out bh -> bx=dx
        mov     WORD PTR _mouse_dx, bx
     
        mov     al,bl
        cbw
      cmp ax,0
      jge ADD_X
      SCALE_DX
ADD_X:
        add     WORD PTR _mouse_x, ax
;
;                    **CHECK X BOUNDS**
;
        cmp     WORD PTR _mouse_x, MOUSE_MIN_X
     jge        X_GT_0
        mov     WORD PTR _mouse_x, 0
X_GT_0:
        cmp     WORD PTR _mouse_x, MOUSE_MAX_X
     jle        X_LT_MAX
        mov     WORD PTR _mouse_x, MOUSE_MAX_X
X_LT_MAX:
;
;                       **Get the DY portion of the packet**
;
        mov     bl, BYTE PTR _mouse_bytes
        and     bl, 0Ch
        shl     bl, 4                           ;got top 2 bits of dy
        mov     bh, BYTE PTR _mouse_bytes+2
        and     bh, 2Fh                         ;bh = bottom 6 bits of dy
        or      bl, bh                          ;bl = dy
        xor     bh, bh                          ;bx = dy
        mov     WORD PTR _mouse_dy, bx
        
        mov     al,bl
        cbw
      cmp ax,0
      jge ADD_Y
      SCALE_DY
ADD_Y:
        add     WORD PTR _mouse_y, ax
;
;                               **CHECK Y BOUNDS**
;
        cmp     WORD PTR _mouse_y, MOUSE_MIN_Y
      jge       Y_GT_0
        mov     WORD PTR _mouse_y, 0
Y_GT_0:
        cmp     WORD PTR _mouse_y, MOUSE_MAX_Y
      jle       Y_LT_MAX
        mov     WORD PTR _mouse_y, MOUSE_MAX_Y
Y_LT_MAX:
;
;                       **Get mouse button states**
;
        mov     bl, BYTE PTR _mouse_bytes
        mov     bh, bl
        and     bl, 20h
        and     bh, 10h
        shr     bl, 5
        shr     bh, 4
        mov     BYTE PTR _mouse_left, bl
        mov     BYTE PTR _mouse_right, bh
;
;               end updating important variables
;
MORE_LEFT:
        mov     al,20h
        mov     dx,20h                          ;PIC port number
        out     dx,al                           ;acknowlege end of interrupt

        pop     ds
        popad
        iretd
_TEXT   ENDS

        END
