#include <dos.h>
#include <conio.h>
#include <i86.h>
#include "jmouse.h"


void __interrupt __far   Mouse_ISR(void);

int     Mouse_Handler_Installed=0;
volatile char mouse_left, mouse_right;
volatile int  mouse_dx, mouse_dy;
volatile char MOUSE_INT;
volatile int  MOUSE_PORT;


static void (__interrupt __far *Old_Mouse_Handler)();
static void volatile    (MOUSE_FAR  *Mouse_User_Handler)(void);
static volatile signed char mouse_bytes[3], mouse_t;
static volatile int    mouse_byte_num;
static volatile int    com1_mouse_byte_num=0, com2_mouse_byte_num=0;
static char	old_mask, old_int_on;

//*************************** ROUTINES *********************

void __interrupt __far   Mouse_ISR(void){
	mouse_t = inp( MOUSE_PORT);
	if (mouse_t & 0x40) mouse_byte_num=0;

	mouse_bytes[ mouse_byte_num] = mouse_t;
	mouse_byte_num++;

	if (mouse_byte_num == 3){
		mouse_t = ( (mouse_bytes[0] & 0x03)<<6) + (mouse_bytes[1]&0x2F);
		mouse_dx = mouse_t;
		mouse_t = ( (mouse_bytes[0] & 0x0C)<<4) + (mouse_bytes[2]&0x2F);
		mouse_dy = mouse_t;
		mouse_left = (mouse_bytes[0] & 0x20)>>5;
		mouse_right =(mouse_bytes[0] & 0x10)>>4;               
	}
	outp( 0x20, 0x20);
}

int     Init_Mouse( ){
	if (Mouse_Handler_Installed) return 1;

//        Get_Mouse_Int();
	if (MOUSE_INT == NO_MOUSE) return 0;

	mouse_left=mouse_right=mouse_dx=mouse_dy=0;

	Old_Mouse_Handler = _dos_getvect( MOUSE_INT);
	_dos_setvect( MOUSE_INT, Mouse_ISR);

	Mouse_Handler_Installed=1;
	return 1;
}

void    Clean_Up_Mouse(){
	if (!Mouse_Handler_Installed) return;
	outp(MOUSE_PORT+1,old_int_on);
	outp(0x21,old_mask);
	_dos_setvect( MOUSE_INT, Old_Mouse_Handler);
	Mouse_Handler_Installed=0;
}


/******************************* MOUSE DETECTION STUFF**********************************/

static void    Init_Com(int com_num){
	union REGS r;
        int   base, mask;
	char  t;	/* to keep inp() from being "optimized" out */

	com_num--;

#ifdef  __386__
	r.w.ax = 0xF3;
	r.w.dx = com_num;
        int386( 0x14, &r, &r);
#else
	r.x.ax = 0xF3;
	r.x.dx = com_num;
        int86( 0x14, &r, &r);
#endif
	if (com_num==0){
	   base = COM1_BASE;
	   mask = 0xEF;
	}
	else{
	   base = COM2_BASE;
	   mask = 0xF7;
	}
        t = inp( base+5);       /* read line status */
	t = inp( base+2);       /* read int id */
	t = inp( base);         /* read data */
	old_mask = inp(0x21);   /* save old PIC mask */
	outp(0x21, mask & old_mask);	/* make sure we can see interrupt */
	old_int_on = inp(base+1); /* save this */
        outp( base+1, 1);       /* set COM for interrupt on data-recieved */

        mask = t;               /* keep inp(base+x) from being optimized out */
}


static void __interrupt __far   COM1_ISR(void){
	mouse_t = inp( COM1_BASE);
	if (mouse_t & 0x40) com1_mouse_byte_num=0;

	com1_mouse_byte_num++;

	if (com1_mouse_byte_num == 3){
		MOUSE_INT  = COM1_INT;
		MOUSE_PORT = COM1_BASE;
	}
	outp( 0x20, 0x20);
}

static void __interrupt __far   COM2_ISR(void){
	mouse_t = inp( COM2_BASE);
        if (mouse_t & 0x40) com2_mouse_byte_num=0;

	com2_mouse_byte_num++;

	if (com2_mouse_byte_num == 3){
		MOUSE_INT  = COM2_INT;
		MOUSE_PORT = COM2_BASE;
	}
	outp( 0x20, 0x20);
}


static  void Get_Mouse_Int(){
	void (__interrupt __far *Old_Com1_ISR)();
	void (__interrupt __far *Old_Com2_ISR)();
	unsigned int     i;

	Old_Com1_ISR = _dos_getvect( COM1_INT);
	Old_Com2_ISR = _dos_getvect( COM2_INT);
	_dos_setvect( COM1_INT, COM1_ISR);
	_dos_setvect( COM2_INT, COM2_ISR);

	Init_Com(1);
	Init_Com(2);

	MOUSE_INT = NO_MOUSE;

	for (i=0xFFFF; i!=0; i--){ inp(0x388);
		if (MOUSE_INT != NO_MOUSE) break;}

	_dos_setvect( COM1_INT, Old_Com1_ISR);
	_dos_setvect( COM2_INT, Old_Com2_ISR);
}
void crap(){

        int   base, mask;
	char  t;	/* to keep inp() from being "optimized" out */

        t = inp( base+5);       /* read line status */
	t = inp( base+2);       /* read int id */
	t = inp( base);         /* read data */
	old_mask = inp(0x21);   /* save old PIC mask */
	outp(0x21, mask & old_mask);	/* make sure we can see interrupt */
	old_int_on = inp(base+1); /* save this */
	outp( base+1, 1);       /* set COM for interrupt on data-recieved */
	mask = t;		/* keep inp(base+x) from being optimized out */

}
