#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "keybrd.h"
#include "C:\WATCOM\LEARN\HOZIELIB\DPMI.H"

#define MAX_STRING_STATES 10
#define PAUSED_STATE    0x1
#define EXTENDED_STATE  0x2
#define SHIFT_STATE     0x4

                #define COOL_PORTS
                #ifdef COOL_PORTS
                       extern char INP( short port);
                        #pragma aux INP=                \
                                "in     al,dx"          \
                                parm    [dx]            \
                                value   [al];
                       extern void OUTP( short port, char val);
                        #pragma aux OUTP=               \
                                "out    dx,al"          \
                                parm    [dx][al];                  
                #else
                        #include <conio.h>
                
                        #define OUTP outp
                        #define INP  inp
                #endif

static DPMI_SELECTOR  OldIntSel;
static DPMI_POFFSET    OldIntOfs;
static void far   *MyKeyAd;
static char        KeyInstalled=0;

static volatile int special_string_state;
static volatile int key_flags;
volatile char  key, paused;
volatile int special_string_set;
volatile char  keys[128];

void __interrupt KeyHandler(void)
{
   register char key_temp;

   key = INP( 0x60);
   key_temp = INP(0x61) | 0x82;
   OUTP( 0x61, key_temp );
   key_temp &= 0x7F;
   OUTP( 0x61, key_temp);

   if (key_flags & PAUSED_STATE){
           if ( key==197 )
                key_flags &= ~PAUSED_STATE;
   }                     
   else if (key == 0xE1){
        key_flags |= PAUSED_STATE;
        keys[PAUSED] ^= 1;
   }     
   else if (key != 0xE0){                
           if ((key & 0x80)) {
            keys[ (key & 0x7F)] = 0;            
           }
           else {
            if (key==L_SHIFT){
             if (!(key_flags & EXTENDED_STATE))
                keys[L_SHIFT] = 1;
            }
            else keys[ key ] = 1;
           }
           key_flags &= ~EXTENDED_STATE;
   }
   else{
        key_flags |= EXTENDED_STATE;
   }

   OUTP( 0x20, 0x20);
}

void    InitKey(){
    if (KeyInstalled) return;
    DPMI_get_pmode_interrupt_vector( 0x09, &OldIntSel, &OldIntOfs);    
    MyKeyAd = (void far *) KeyHandler;
    DPMI_set_pmode_interrupt_vector( 0x09, (DPMI_SELECTOR)FP_SEG(MyKeyAd), (DPMI_POFFSET)FP_OFF(MyKeyAd) );
    LockVMem( (Word) &KeyHandler>>16, (Word)&KeyHandler & 0xFFFF,0,512);
    LockVMem( (Word) &keys>>16, (Word)&keys & 0xFFFF,0,sizeof(keys));
    memset( &keys[0], 0, sizeof(keys) );
    special_string_state = MAX_STRING_STATES;
    special_string_set=key_flags=0;
    KeyInstalled = 1;
}

void    UninstallKey(){
    if (!KeyInstalled) return;
    DPMI_set_pmode_interrupt_vector( 0x09, (DPMI_SELECTOR)OldIntSel, (DPMI_POFFSET)OldIntOfs);
    KeyInstalled = 0;
}                

extern void LockVMem( Word StartSel,  Word StartOfs, Word MSWSize, Word LSWSize);
        #pragma aux LockVMem =          \
                "mov    ax,600h"        \
                "int    31h"            \
                parm    [bx][cx][si][di];
