#include <string.h>
#include <stdio.h>
#include <conio.h>
#include "wadio.h"

#define DOOM1_FORMAT 1
#define DOOM2_FORMAT 2

char   map_name[3]="01";

static int     GOT_IWAD, MAP_LOADED;

void    PARM_FILE(int  c, char *argv[]){
              
              if (GOT_IWAD)
                return;
              c++;
              
              if (InitWad(argv[c])){
                  printf("Adding wad %s\n",argv[c]);
                  GOT_IWAD = 1;                 
              }
}

void    PARM_WARP( int c, char *argv[]){
    c++;
    map_name[0] = argv[c][0];
    map_name[1] = argv[c][1];
}


char    *parm_strings[] = {
                "FILE",
                "WARP",
                NULL
        };

void    *parm_functions[] = {
                PARM_FILE,             
                PARM_WARP,
                NULL
        };
                

void    parse_args( int  argc, char *argv[]){  
    
  int   parm_count;
  int   i;
  void  (*this)(int c, char *argv[]);
  
        GOT_IWAD = 0;
        MAP_LOADED = 0;
        
        for (parm_count=1; parm_count<argc; parm_count++)
          if( argv[parm_count][0]=='-' || argv[parm_count][0]=='/'){
                i=0;
                while (parm_strings[i]){
                        if (!stricmp(&argv[parm_count][1],parm_strings[i])){
                               this = parm_functions[i];
                               (*this)(parm_count, argv);
//                               (*parm_functions)[i]();
                        }
                i++;
                }
          }
                                          

        if (!GOT_IWAD){
                printf("Using default wad file.\n");
                if (!InitWad(DOOM2WAD))
                        WadError("Couldn't initilize default wad file.");
        }

       GET_MAP(); 
       if (!MAP_LOADED)
            WadError("Couldn't Load Map.");
                
}


void    GET_MAP(){
        char *s = "MAP01";

        s[3] = map_name[0];
        s[4] = map_name[1];
        if (LoadMap(s)){
            printf("Warping to %s\n",s);
            MAP_LOADED = 1;        
        }
        else WARP_1();
        
}
                   /* USE ORIGINAL DOOM MAP FORMAT */
void    WARP_1(){
        char *s = "E1M1";

        s[1] = map_name[0];
        s[3] = map_name[1];
        if (LoadMap(s)){
            printf("Warping to %s\n",s);
            MAP_LOADED = 1;
        }
        else printf("Bad map number\n");
        
}

