/**************************************************************************
*               this little module takes information outta
*               wall (aliasing Walls[x][n] throughout the
*               loop) and draws vertical lines at the
*               appropriate times.  ColBase is &MyScreen[x].
*               In doom the floors can only go from the bottom of a "far"
*               main (transparent) wall to a closer top of a lower wall.
*               Likewise a ceiling can only go from the top of a transparent
*               main wall to the bottom of a closer upper wall.
***************************************************************************/

#include "globals.h"

extern char     NumWalls[320];
extern WallRec   Walls[320][64];

/*      alternative here is to have ebx = ColBase[ ENDY*320]    */
extern void     Vline(char *ColBase, int starty, int endy, char color);
	#pragma aux Vline =             \
		"sub    cl,al"          \
		"je     Done"           \
		"lea    eax,[eax+eax*4]"\
		"shl    eax,6"          \
		"add    eax,esi"        \
       "NotDone: mov    [eax],ch"       \
		"add    eax,320"        \
		"dec    cl"             \
		"jne    NotDone"        \
	"Done:"                         \
		parm    [esi][eax][cl][ch] \
		modify  [eax cl];

#define FLOOR_COLOR 8
#define CEILING_COLOR 1

void    Draw(){
  signed char   n;
  int    x;
  char   *ColBase = MyScreen + 320;
  char   ft,cb;
  int    CeilingWaiting, FloorWaiting;
  WallRec *wall;


  for (x=319; x>=0; x--){
    CeilingWaiting = FloorWaiting = 0;
    ColBase --;
    n=NumWalls[x];
       wall = &Walls[x][n];
      for (; n>=0; n--){


	  if (FloorWaiting)
	   if (wall->Stop > ft)
	     if (wall->Type == MAIN){
                Vline( ColBase, ft, wall->Stop, FLOOR_COLOR);

		FloorWaiting = 0;
	     }

	  if (CeilingWaiting)
	   if (wall->Start < cb)
	     if (wall->Type == MAIN){
                Vline( ColBase, wall->Start, cb, CEILING_COLOR);

		CeilingWaiting = 0;
	     }

	  if (wall->FloorNum >= 0x8000){
	     ft = wall->Stop;
	     FloorWaiting = 1;
	  }

	  if (wall->CeilingNum >= 0x8000){
	     cb = wall->Start;
	     CeilingWaiting = 1;
	  }


	   if (wall->TextNum == TRANSPARENT)
	       goto Bloop;

           Vline( ColBase, wall->Start, wall->Stop, wall->TextNum+40);

Bloop:     wall--;

      }

      wall++;

	if (FloorWaiting)
       if (wall->Stop !=  200){
                Vline( ColBase, ft, 200, FLOOR_COLOR);
      }
      if (CeilingWaiting)
       if (wall->Start != 0){
                Vline( ColBase, 0, cb, CEILING_COLOR);
	     }

  }
}

