#include <string.h>
#include "globals.h"
#include "doombsp.h"

void    DoWall();

char    ColDone[320];
char    CurrentSector;
short   ph;
int     StripsDone;

long      wx1,wy1, wx2,wy2, wt,wb;
float     z1,z2;
long      Sx1,Sx2;
short     SegIndex;

char      tStartx,tStarty,WallType;
unsigned short     tn,fn,cn;


int     SegOnRight( SegIndex){

        if ( ((wx1-wx2)*(py-wy2)) >= ((wy1-wy2)*(px-wx2)) )
           return 1;
        else return 0;
}


void    DumpSSector( short SSectorIndex){
  SSectorT  *SSector = &SSectors[ SSectorIndex];
  SegT      *TheSeg;
  VertexT   *TheVertex;
  LineT     *TheLine;
  SideDefT  *TheSide;
  SectorT   *TheSector, *FarSector;
  short     StopSeg;
  char      WhichSide, DidUpper, DidLower;
  short     FloorH, CeilingH,x;
  long      tSx1,tSx2;
  float     rz1,rz2,rx1,rx2, pTan;

  SegIndex = SSector->StartSeg;
  StopSeg  = SSector->NumSegs + SegIndex;

 for (; SegIndex < StopSeg; SegIndex++){
  TheSeg = &Segs[ SegIndex];

  TheVertex = &Vertex[ TheSeg->vStart];
  wx1 = TheVertex->x;
  wy1 = TheVertex->y;
  TheVertex = &Vertex[ TheSeg->vEnd];
  wx2 = TheVertex->x;
  wy2 = TheVertex->y;

  if (SegOnRight(SegIndex)){
       wx1 -= px;
       wx2 -= px;
       wy1 -= py;
       wy2 -= py;

       rz1 = wx1*pCos - wy1*pSin;
       rz2 = wx2*pCos - wy2*pSin;
       if ((rz1 < MinZ) && (rz2 < MinZ))
          goto NoDraw;
       rx1 = wy1*pCos + wx1*pSin;
       rx2 = wy2*pCos + wx2*pSin;


       pTan = Tan[ (unsigned short)(TheSeg->angle-pang) >> AngDif];

       if (rz1 < MinZ){
          rx1 += (MinZ-rz1) * pTan;
          rz1 = MinZ;
       }
       if (rz2 < MinZ){
          rx2 += (MinZ-rz2) * pTan;
          rz2 = MinZ;
       }
       if (rz1 > MaxZ)
          z1 = ztable[MaxZ];
       else z1 = ztable[ (short)rz1];
       if (rz2 > MaxZ)
          z2 = ztable[MaxZ];
       else z2 = ztable[ (short)rz2];

       Sx1 = xCenter - (short)rx1*z1;
       Sx2 = xCenter - (short)rx2*z2;
       if (Sx1 > 319) goto NoDraw;
       if (Sx2 < 0) goto NoDraw;

       TheLine = &Lines[ TheSeg->LineNum];
       WhichSide = TheSeg->Dir;
       TheSide = &Sides[ TheLine->SideDef[WhichSide] ];
       TheSector = &Sectors[ TheSide->SectorIndex];
       FloorH = TheSector->FloorHeight;
       CeilingH = TheSector->CeilingHeight;
       if (CurrentSector){
          ph = HeroHeight + FloorH;
          CurrentSector = 0;
       }
       tStartx = TheSide->xofs;
       tStarty = TheSide->yofs;

   if ( TheLine->SideDef[1] == -1){          //if one sided
          wt = CeilingH - ph;
          wb = FloorH - ph;
          WallType = MAIN;
          fn = 0x8000;
          cn = 0x8000;

          if (TheSide->WallT != -1){
             tn = TheSide->WallT;
//             tn = 4;
             DoWall( );
             for (x=Sx1; x<=Sx2; x++){
                 if (!ColDone[x])
                    StripsDone++;
                 ColDone[x] = 1;
             }
          }
          else{
             tn = TRANSPARENT;
             DoWall( );
          }
   }   // END IS ONE SIDED

   else{
//-----------------------IS 2 SIDED WITH POSSIBLE DISCONTINUITIES
       FarSector = &Sectors[ Sides[ TheLine->SideDef[1-WhichSide] ].SectorIndex ];
       tSx1=Sx1;  tSx2=Sx2;

//------------------------THIS IS THE UPPER STUFF----------------------------

       if (CeilingH > FarSector->CeilingHeight){

          wt = TheSector->CeilingHeight - ph;
          wb = FarSector->CeilingHeight - ph;
          WallType = UPPER;
if (FarSector->CeilingHeight == FarSector->FloorHeight)
fn = 0x8000;
else
          fn = 0;
          cn = 0x8000;
          if ( TheSide->UpperT != -1)
//               tn = 9;
             tn = TheSide->UpperT;
          else tn = TRANSPARENT;
          DoWall( );
          if (FarSector->CeilingHeight == FarSector->FloorHeight){
             for (x=Sx1; x<=Sx2; x++){
                 if (!ColDone[x])
                    StripsDone++;
                 ColDone[x] = 1;
             }
             continue;
          }

          Sx1 = tSx1; Sx2 = tSx2;
          DidUpper = 1;
       }
       else DidUpper = 0;

//------------------------THIS IS THE LOWER STUFF--------------------------
DidLower = 0;
   if ( TheSide->LowerT != -1)
       if (FloorH < FarSector->FloorHeight){
          wt = FarSector->FloorHeight - ph;
          wb = TheSector->FloorHeight - ph;
          WallType = LOWER;
          fn = 0x8000;
          cn = 0;
          if ( TheSide->LowerT != -1)
//             tn = 7;
             tn = TheSide->LowerT;
//          else tn = TRANSPARENT;
          DoWall( );
          Sx1 = tSx1; Sx2 = tSx2;
          DidLower = 1;
      }
//      else DidLower = 0;

//----------------------------TWO SIDED WALL STUFF--------------------------

      WallType = MAIN;
      if (DidUpper){
         wt = FarSector->CeilingHeight - ph;
         cn = 0;
      }
      else{
         wt = CeilingH - ph;
         cn = 0x8000;
      }
      if (DidLower){
         fn = 0;
         wb = FarSector->FloorHeight - ph;
      }
      else{
         wb = FloorH - ph;
         fn = 0x8000;
      }

      if (TheSide->WallT != -1){
//             tn = 4;
             tn = TheSide->WallT;
             DoWall( );
             for (x=Sx1; x<=Sx2; x++){
                 if (!ColDone[x])
                    StripsDone++;
                 ColDone[x] = 1;
             }
      }
      else{
             tn = TRANSPARENT;
             DoWall( );
      }

   } //END IS TWO SIDED!


  } //Segonright;
 NoDraw:
        Sx1=Sx1;
 } //Big For
}
