#include <dos.h>
#include <conio.h>
#include "timer.h"

volatile unsigned int time;
#ifdef MY_SOUND
    volatile int PlaySnd; 
#endif

long        lag, count;
int         _Timer_Installed = 0;

void (__interrupt __far *Old_Timer_Int)();


void __interrupt __far My_Timer(){
    time++;
    
#ifdef MY_SOUND
    PlaySnd = 1;    
#endif    
        
    lag += count;

    if (lag >= STANDARD_FREQ){
        lag -= STANDARD_FREQ;
        _chain_intr( Old_Timer_Int );
    }
    else
       outp( 0x20, 0x20);

}

void Init_Timer( short freq ){
    count = 0x1234DD / freq;    
    lag = 0;
    time = 0;
    
    Old_Timer_Int = _dos_getvect( TIMER_INTERRUPT );
    _dos_setvect( TIMER_INTERRUPT, My_Timer );

    outp( 0x43, 0x34);
    outp( 0x40, count & 255);
    outp( 0x40, count >> 8 );
    _Timer_Installed = 1;
}

void Clean_Up_Timer(){
    if (!_Timer_Installed) return;    
    outp( 0x43, 0x34);
    outp( 0x40, 0);
    outp( 0x40, 0);
    _dos_setvect( TIMER_INTERRUPT, Old_Timer_Int );
}
  
