#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "wadio.h"
#include "globals.h"
#include "..\hozielib\graphics.h"

#define DISTRIBUTE

unsigned long num_bytes=0;

FILE        *WadFile;
IDHeaderT   WadHeader;
LumpEntryT  *Dir;

static   int     MapBase;
static   PatchPtr patches;
static   Saved_SideDefT *Saved_Sides;
static   PicT    Pic;
static   PostT   Post;

void    WadError( char MError[]){
        printf("%s",MError);
        exit(1);
}

void    EndIt(){
        float frames = NumFrames;
        printf("%s%d\n","Things        : ",NumThings   );
        printf("%s%d\n","Lines         : ",NumLines    );
        printf("%s%d\n","Sides         : ",NumSides    );
        printf("%s%d\n","Verticies     : ",NumVerticies);
        printf("%s%d\n","Segs          : ",NumSegs     );
        printf("%s%d\n","SSectors      : ",NumSSectors );
        printf("%s%d\n","Nodes         : ",NumNodes    );
        printf("%s%d\n","Sectors       : ",NumSectors  );
        printf("%s%d\n","Reject Size   : ",RejectSize );
        printf("%s%d\n","Block Map Size: ",BlockMapSize);
        printf("Play ended at %d , %d < %d\n",px,py,pang);
        t1 = *Time;
        printf("HOZIE DOOM version %s active for %f seconds.\n",VER,(t1-t0)/18.2);         
        printf("Averaging %f frames per second.\n",NumFrames/((t1-t0)/18.2));
        printf("Rendering %d polygons for an average of %f polygons/frame\n",num_polygons,(num_polygons/frames));
#ifdef DISTRIBUTE
        printf("\nBy Jose Flores\njflores@mail.utexas.edu\nhttp://www.ece.utexas.edu/~flores\n\n");
#endif
}

int     InitWad( char WadName[]){
    WadFile = fopen( WadName,"rb");
    if (!WadFile) return(0);
    fread( &WadHeader, 1, sizeof(WadHeader), WadFile);
    fseek(WadFile, WadHeader.DirOfs, SEEK_SET);
    Dir = (LumpEntryT *)malloc( sizeof(LumpEntryT)*MaxLumps);
    if (!Dir) return(0);
    fread( Dir, 1,sizeof(LumpEntryT) * WadHeader.NumLumps, WadFile);
    return 1;
}


int     FindLump( char LumpName[9]){
        int test, i=WadHeader.NumLumps;

        for (; i>=0; i--){
            test=memicmp(Dir[i].Name,LumpName,8  );
            if (!test) return i;
        }
        return -1;
}

void    LoadDoomPal(){
        PalArray   tpal;
        int        i = FindLump("PLAYPAL");

        if (i==-1) WadError("Couldn't load DOOM pallette!");
        fseek( WadFile, Dir[i].Ofs + (7*768), SEEK_SET);
        fread( &tpal, 1, 3*256, WadFile);
        memset(&tpal,256,9);
        for (i = 0; i < 256; i++) {
          SetPal(i, &tpal[i]);
        }
}

char    *LoadFlat( char Name[9]){
        char       *Buf;
        int        i = FindLump(Name);

        if (i==-1) return NULL;
        Buf = (char *)malloc(64*64);
        if (!Buf) return NULL;
        fseek( WadFile, Dir[i].Ofs, SEEK_SET);
        fread( Buf, 1, 64*64, WadFile);
        return Buf;
}

char    *LoadPic(char Name[9])
{       char    Buf[200],dummy;
        short   x,j;
        char    *myptr,*tBuff;
        int        i = FindLump(Name);

        if (i==-1)  WadError("Couldn't Load a bit map!!!");
        fseek( WadFile, Dir[i].Ofs, SEEK_SET);
        fread( &Pic, 1, sizeof(Pic)-sizeof(Pic.Col), WadFile);
        tBuff = (char *)malloc(Pic.Width * Pic.Height);
        if (!tBuff) WadError("Couln't allocate memory for bitmap!!!");
        memset( tBuff, 0xFF, Pic.Width * Pic.Height);
        fread( &Pic.Col, 1, Pic.Width*4, WadFile);
        for (x=0; x < Pic.Width; x++){
            fseek( WadFile, Dir[i].Ofs + Pic.Col[x], SEEK_SET);
            do{
                fread( &Post, 1, sizeof(Post), WadFile);                
                if (Post.StartY != 0xFF){
                    fread( &Buf, 1, Post.NumPixels, WadFile);
                    myptr = tBuff + (x * Pic.Height) + Post.StartY;                    
                    for (j=0; j < Post.NumPixels; j++){
                        *myptr = Buf[j];
                        myptr ++;
                    }
                fread( &dummy,1,1,WadFile);
                continue;
                }
                else break;
            }while (1);                    
        }
        return tBuff;
}

static void     Load_Patch( char name[9], char *texture, TextureT *tex,
                                        PatchDescriptorT   patch){
    int         tx,ty,px,py;
    char        *buf = LoadPic(name), *dont_understand=buf;
    int         pw=Pic.Width,
                 ph = Pic.Height,
                 tw = tex->width,
                 th = tex->height;
    

    if (!buf) WadError("Couldn't load patch!\n");

    px=0;    
    for (tx=patch.xofs; tx<tw; tx++, px++){
    if (px>=pw) break; //px=0;
    py=0;
      for (ty=patch.yofs; ty<th; ty++, py++){
         if (py>=ph) break; //py=0;
         if ( buf[ (px*ph)+py] != 0xFF)
                texture[ (tx*th)+ty] = buf[ (px*ph)+py];
      }    
    }

    free(dont_understand);             
}
    
static int      Get_Patches(){        
    int      i=FindLump("PNAMES");    
    long     NumPatches;

    if (i==-1) return 0;
    fseek( WadFile, Dir[i].Ofs, SEEK_SET);
    fread( &NumPatches, 1, sizeof(NumPatches), WadFile);
    patches = (PatchPtr)malloc( NumPatches*sizeof(PatchT) );
    if (!patches) return 0;
    fread( patches, 1, NumPatches*sizeof(PatchT), WadFile);

    return 1;
}

static int    Load_Texture( TextureT *tex, int texture_index){
        PatchDescriptorT   patch;
        long    wad_pos;
        int     i;

printf("%d.  %.8s  %d\n",texture_index,tex->name,tex->numpatches);
        Textures[texture_index].width   = tex->width;
        Textures[texture_index].height  = tex->height;        
        Textures[texture_index].texture = (char *)malloc(tex->width*tex->height);
num_bytes += tex->width*tex->height;
        if (!Textures[ texture_index].texture) WadError("Couldn't allocate memory for texture!");
        memset( Textures[texture_index].texture, 0xFF, tex->width * tex->height);
        
        for (i=0; i<tex->numpatches; i++){
                fread( &patch, 1, sizeof(patch), WadFile);
                wad_pos = ftell(WadFile);
printf("          patch->  %.8s\n", patches[patch.pname]);  
                Load_Patch( patches[patch.pname],
                            Textures[texture_index].texture,
                            tex , patch);
                fseek( WadFile, wad_pos, SEEK_SET);
        }
    return 1;
}        

static int     Get_Textures(){
        
    TextureT tex;
    long     *ofs,TextOfs;    
    int      side, used, i=FindLump("TEXTURE1");

    if (i==-1) return 0;

    if (!Get_Patches() ) return 0;
    TextOfs = Dir[i].Ofs;
    fseek( WadFile, TextOfs, SEEK_SET);
    fread( &NumTextures, 1, sizeof(NumTextures), WadFile);
    ofs = (long *)malloc( NumTextures*4);
    if (!ofs) return 0;
    fread( ofs, 1, NumTextures*4, WadFile);
    memset( Textures, 0, sizeof(Textures) );

    for (i=0; i<NumTextures; i++){
        fseek( WadFile, TextOfs+ofs[i], SEEK_SET);
        fread( &tex, 1, sizeof(tex), WadFile);

        used = 0;

        for (side=0; side< NumSides; side++){
            if ( !memicmp( Saved_Sides[side].UpperT, tex.name, 8) ){
                used = 1;
                Sides[side].UpperT = i;
            }    
            if ( !memicmp( Saved_Sides[side].LowerT, tex.name, 8) ){
                used = 1;
                Sides[side].LowerT = i;
            }
            if ( !memicmp( Saved_Sides[side].WallT, tex.name, 8) ){
                used = 1;
                Sides[side].WallT = i;
            }    
        }
/*
       if (used)          
          Load_Texture( &tex, i);
*/
    }

/*              **MAKE SURE EVERYTHINGS OK**    */

    for (side=0; side<NumSides; side++){
       if ( Sides[side].UpperT==NULL )
        if ( Saved_Sides[side].UpperT[0]!='-')
             WadError("Upper Texture not found!!");
       if ( Sides[side].LowerT==NULL )
        if ( Saved_Sides[side].LowerT[0]!='-')
             WadError("Lower Texture not found!!");   
       if ( Sides[side].WallT==NULL )
        if ( Saved_Sides[side].WallT[0]!='-')
             WadError("Wall Texture not found!!");   
    }

    free(ofs);
    free(patches);    
    free(Saved_Sides);
    return 1;
}  


static void   GetWorldExtrems(){
 short xt,yt,Index;

     xMin = yMin = 32767;
     xMax = yMax = -32768;
     for (Index=0; Index < NumVerticies; Index++){
         xt = Vertex[ Index].x;
         yt = Vertex[ Index].y;
         if (xt < xMin) xMin = xt;
         if (xt > xMax) xMax = xt;
         if (yt < yMin) yMin = yt;
         if (yt > yMax) yMax = yt;
     }
     absMinx = -xMin;
     absMiny = -yMin;
     xScale = (float) (319.0 / (xMax-xMin));
     yScale = (float) (199.0 / (yMax-yMin));
}

static void    GetPlayer1Start()
{
 ThingT  Thing;
 int    c = MapBase + 1;
        NumThings = Dir[c].Size / sizeof(ThingT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        do{
           fread( &Thing,1,sizeof(Thing),WadFile);
        } while ( Thing.kind != Player1Start);
        px = Thing.x;
        py = Thing.y;
        pang = Deg2Bams(Thing.angle);
}

static void    ReadLines(){
 int    c = MapBase + 2;
        NumLines = Dir[c].Size / sizeof(LineT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Lines) Lines = (LineT *)malloc(Dir[c].Size);
        if (!Lines) WadError("Not Enough Memory for LineDefs");
        fread( Lines, 1, Dir[c].Size, WadFile);
}

static void    ReadSideDefs(){
 int         c = MapBase + 3;

        NumSides = Dir[c].Size / sizeof(Saved_SideDefT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Saved_Sides) Saved_Sides = (Saved_SideDefT *)malloc(Dir[c].Size);
        if (!Saved_Sides) WadError("Not Enough Memory for SAVED SideDefs");
        fread( Saved_Sides, 1, Dir[c].Size, WadFile);
        if (!Sides) Sides = (SideDefT *)malloc(NumSides*sizeof(SideDefT));
        if (!Sides) WadError("Not Enough Memory for SideDefs");
        for (c=0; c<NumSides; c++){
                Sides[c].xofs = Saved_Sides[c].xofs;
                Sides[c].yofs = Saved_Sides[c].yofs;
                Sides[c].UpperT = -1;           /* default is TRANSPARENT */
                Sides[c].LowerT = -1;
                Sides[c].WallT = -1;
                Sides[c].SectorIndex = Saved_Sides[c].SectorIndex;
        }
}

static void    ReadVerticies(){
 int    c = MapBase + 4;                               
        NumVerticies = Dir[c].Size / sizeof(VertexT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Vertex) Vertex = (VertexT *)malloc(Dir[c].Size);
        if (!Vertex) WadError("Not Enough Memory for Verticies");
        fread( Vertex, 1, Dir[c].Size, WadFile);
}

static void    ReadSegs(){
 int    c = MapBase + 5;
        NumSegs = Dir[c].Size / sizeof(SegT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Segs) Segs = (SegT *)malloc(Dir[c].Size);
        if (!Segs) WadError("Not Enough Memory for Segs");
        fread( Segs, 1, Dir[c].Size, WadFile);
}

static void    ReadSSectors(){
 int    c = MapBase + 6;
        NumSSectors = Dir[c].Size / sizeof(SSectorT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!SSectors) SSectors = (SSectorT *)malloc(Dir[c].Size);
        if (!SSectors) WadError("Not Enough Memory for SSectors");
        fread( SSectors, 1, Dir[c].Size, WadFile);
}

static void    ReadNodes(){
 int    c = MapBase + 7;
        NumNodes = Dir[c].Size / sizeof(SavedNodeT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Nodes) Nodes = (SavedNodeT *)malloc(Dir[c].Size);
        if (!Nodes) WadError("Not Enough Memory for Nodes");
        fread( Nodes, 1, Dir[c].Size, WadFile);
}

static void    ReadSectors(){
 int    c = MapBase + 8;
        NumSectors = Dir[c].Size / sizeof(SectorT);
        fseek( WadFile, Dir[c].Ofs, SEEK_SET);
        if (!Sectors) Sectors = (SectorT *)malloc(Dir[c].Size);
        if (!Sectors) WadError("Not Enough Memory for Sectors");
        fread( Sectors, 1, Dir[c].Size, WadFile);
}

static void    ReadReject(){
  int    c = MapBase + 9;
         RejectSize = Dir[c].Size;
         fseek( WadFile, Dir[c].Ofs, SEEK_SET);
         Reject = (char *)malloc(Dir[c].Size);
         fread( Reject, 1, Dir[c].Size, WadFile);
}

static void    ReadBlockMap(){
  int    c = MapBase + 10;
  long   togo;
         BlockMapSize = Dir[c].Size;
         fseek( WadFile, Dir[c].Ofs, SEEK_SET);
         fread( &BlockMapHeader, 1, sizeof(BlockMapHeader), WadFile);
         NumBlocks = BlockMapHeader.xBlocks * BlockMapHeader.yBlocks;
         BlockOfs = (unsigned short *)malloc( NumBlocks * sizeof(short));
         if (!BlockOfs) WadError("Not enough memory for BlockOffset.");
         fread( BlockOfs, 1, NumBlocks * sizeof(short), WadFile);
         fread( &NumBlocks, 1, sizeof(short), WadFile);
         togo = Dir[c].Size - BlockOfs[0]*2;
         BlockMap = (short *)malloc( togo);
         if (!BlockMap) WadError("Not enough memory for BlockMap.");
         fread( BlockMap, 1, togo, WadFile);
}

int     LoadMap( char   *MapName){
int slen = strlen(MapName);
if (slen > 5) slen=5;
    for (MapBase=0; MapBase < WadHeader.NumLumps; MapBase++)
        if ( memcmp( Dir[ MapBase].Name, MapName, slen) == 0)
           break;
    if ( MapBase >= WadHeader.NumLumps) return(0);
    GetPlayer1Start();
    ReadLines();
    ReadSideDefs();
printf("\nGetting textures\n");
Get_Textures();
printf("Got textures\n");
    ReadVerticies();
    ReadSegs();
    ReadSSectors();
    ReadNodes();
    ReadSectors();
    ReadReject();
    ReadBlockMap();
    
    GetWorldExtrems();
    return 1;
}

void    ShowMap(){
 short Index,x1,y1,x2,y2;
    for (Index=0; Index < NumLines; Index++){
        x1 = Vertex[ Lines[Index].vStart].x + absMinx;
        y1 = Vertex[ Lines[Index].vStart].y + absMiny;
        x2 = Vertex[ Lines[Index].vEnd].x +   absMinx;
        y2 = Vertex[ Lines[Index].vEnd].y +   absMiny;

        x1 = (short)(xScale*x1);
        y1 = (short)(yScale*y1);
        x2 = (short)(xScale*x2);
        y2 = (short)(yScale*y2);

        if (Lines[Index].SideDef[1] == -1) Line(ScreenPtr, x1,199-y1, x2,199-y2, 4);
           else Line(ScreenPtr, x1,199-y1, x2,199-y2, 44);
    }
}


