#ifndef __WADIO_H
#define __WADIO_H

#include <stdio.h>

#define VER     "0.10"

#define DOOM1WAD        "C:\\GAMES\\DOOM\\DOOM1.WAD"
#define DOOM2WAD        "C:\\GAMES\\DOOM2\\DOOM2.WAD"
#define HERETICWAD      "C:\\GAMES\\HERETIC\\HERETIC1.WAD"

#define  fs        16
#define  FixedNum  (1 << fs)

#define     MaxLumps     3000
#define     MaxLineDefs  3000
#define     MaxSideDefs  1000
#define     MaxNodes     1000
#define     MaxSegs      3000
#define     MaxSsectors  2000
#define     MaxSectors   2000
#define     MAX_TEXTURES 512
#define     Player1Start 1

#define     East         0
#define     North        16384
#define     West         -32768
#define     South        -16384
#define     Deg30        5461
#define     Deg90        16384

#define     Deg2Bams(ang) ( (short) (ang)*(float)65535/360)
#define     Bams2Deg(bam) ( (float) (bam)*(float)360/65535)


typedef struct __IDHeaderT{
             char WadType[4];
             long NumLumps;
             long DirOfs;
} IDHeaderT;
 
typedef struct __LumpEntryT{
              long Ofs;
              long Size;
              char Name[8];
} LumpEntryT;

typedef struct __PicT{
    short       Width;
    short       Height;
    short       Left;
    short       Top;
    long        Col[320];
} PicT;

typedef  struct __PostT{
    char        StartY;
    char        NumPixels;
    char        dummy;
} PostT;

typedef  char PatchT[8];
typedef  PatchT *PatchPtr;

typedef struct __TextureT{
        char  name[8];
        long  two_short_zeros;
        short width;
        short height;
        long  two_more_short_zeros;
        short numpatches;
} TextureT;

typedef struct __PatchDescriptor{
        short xofs;
        short yofs;
        short pname;
        short stepdir;
        short colormap;
} PatchDescriptorT;


typedef  struct __ThingT{
    short       x;
    short       y;
    short       angle;
    short       kind;
    short       option;
    } ThingT;

typedef struct __VertexT{
    short      x;
    short      y;
    }VertexT;

typedef struct __LineT{
    short      vStart;
    short      vEnd;
    short      Flags;
    short      Effect;
    short      Tag;
    short      SideDef[2];
    } LineT;

typedef struct __Saved_SideDefT{
    short      xofs;
    short      yofs;
    char       UpperT[8];
    char       LowerT[8];
    char       WallT[8];
    short      SectorIndex;
    } Saved_SideDefT;

typedef struct __SideDefT{
    short      xofs;
    short      yofs;
    short      UpperT;          /* These are indicies into Textures[] pointers*/
    short      LowerT;
    short      WallT;
    short      SectorIndex;
    } SideDefT;


typedef struct __SegT{
    short      vStart;
    short      vEnd;
    short      angle;
    short      LineNum;
    short      Dir;
    short      Ofs;
    } SegT;

typedef struct __SSectorT{
    short      NumSegs;
    short      StartSeg;
    } SSectorT;

typedef struct __BoundingBoxT{
    short      Top;
    short      Bottom;
    short      Left;
    short      Right;
    } BoundingBoxT;

typedef struct __SavedNodeT{
    short      x;
    short      y;
    short      dx;
    short      dy;
    BoundingBoxT LeftBox;
    BoundingBoxT RightBox;
    short      Left;
    short      Right;
    } SavedNodeT;

typedef SavedNodeT *SavedNodeT_Ref;    

typedef struct __SectorT{
    short      FloorHeight;
    short      CeilingHeight;
    char       fpic[8];
    char       cpic[8];
    short      ShadeLevel;
    short      Special;
    short      Tag;
    } SectorT;

typedef struct __BlockMapHT{
    short      xOrg;
    short      yOrg;
    short      xBlocks;
    short      yBlocks;
    } BlockMapHT;

typedef struct __TL{
        char   Name[9];
        char   Index;
        } TextureList;


extern FILE        *WadFile;
extern IDHeaderT   WadHeader;
extern LumpEntryT  *Dir;


int     InitWad( char WadName[]);
void    WadError( char MError[]);
void    EndIt();
int     LoadMap( char   MapName[8]);
void    ShowMap();
void    LoadDoomPal();
char    *LoadFlat( char Name[9]);

#endif
