//---------------------------- 3D.C -------------------------------------
// Original author Steve Cox
// --== SysOp of the Houston Game Designer  (713)-251-0734 ==--
// Contributions from Ryan King - Translation,Rotation in
// object array data base .
// This code is very slow dew to the fact I don't know how to
// Impliment integer math and or use a sin look up table .......  SC
// Compiled and ran on a 486/33 ..........  SC
// This is PD code .... Have FUN !!!!!!!   SC

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>
#include <process.h>       //------- Compiled in LARGE -----------
#include <bios.h>          //------- memory module       -----------
#include <math.h>

//                   Declarations

char keyboard(void);
void quit_pgm(void);
void control(void);
void draw_horizon(void);

int    viewpoint_distance=-25,viewing_heigth=-4,MaxX,MaxY,p=0;
float  x=0,y=0,z=0,sx=0,sy=0;
double sr1=0,cr1=0;

float  viewpointx=75,viewpointy=-1,viewpointz=-280;  //your viewpoint coords
float  maxx=639,minx=0,maxy=399,miny=0;
float  rx=0,ry=0;
float  screen_x=639,screen_y=399;
float  time=0,cursorx=-15,cursorz=10,cursory=0;
	      //unitial posistion of 3D cursor
float  view_direction=6.2,view_angle_increment=.2,view_angle=4.5;
float  cursor_direction=0.0;

draw_object(double array[][3],int fnum,double xoff,double yoff,double zoff);

//-----------------  new stuff -------------------------------------

double nanglec,panglec,nangles,pangles;      // Constants for rotations
float  cangle,sangle,angle;                        // More constants

#define  VERTICES 4     // Number of Vertices in the facets of the object SC
#define  FACETNUM 6     // Number of Facets in Object SC


double object1[][3]={   //THIS IS THE CURSOR DATA BASE  SC

	  -2, 0, 2,   //Vertice 1
	   2, 0, 2,   //Vertice 2      FACET ONE
	   2, 2, 2,   //Vertice 3
	  -2, 2, 2,   //Vertice 4

	  -2, 2,-2,   //Vertice 1
	   2, 2,-2,   //Vertice 2    FACET TWO
	   2, 0,-2,   //Vertice 3    !!same data as facet one accept!!
	  -2, 0,-2,   //Vertice 4    !!data is in reverse order so  !!
		      //             !!facet is facing in opposite  !!
		      //             !!direction as facet one       !!

	  -2, 0,-2,   //Facet 3
	  -2, 0, 2,
	  -2, 2, 2,
	  -2, 2,-2,

	   2, 0, 2,   //Facet 4
	   2, 0,-2,
	   2, 2,-2,
	   2, 2, 2,


	    2, 2, 2,   //Facet 5
	    2, 2,-2,   //TOP
	   -2, 2,-2,
	   -2, 2, 2,


	   -2, 0, 2,   //Facet 6
	   -2, 0,-2,   //Bottom
	    2, 0,-2,
	    2, 0, 2,
	   };


double object2[][3]={   //THIS IS THE STATIC OBJECT DATA BASE    SC

	  -2, 0, 2,   //Vertice 1
	   2, 0, 2,   //Vertice 2      FACET ONE
	   2, 2, 2,   //Vertice 3
	  -2, 2, 2,   //Vertice 4

	  -2, 2,-2,   //Vertice 1
	   2, 2,-2,   //Vertice 2    FACET TWO
	   2, 0,-2,   //Vertice 3    !!same data as facet one accept!!
	  -2, 0,-2,   //Vertice 4    !!data is in reverse order so  !!
		      //             !!facet is facing in opposite  !!
		      //             !!direction as facet one       !!

	  -2, 0,-2,   //Facet 3
	  -2, 0, 2,
	  -2, 2, 2,
	  -2, 2,-2,

	   2, 0, 2,   //Facet 4
	   2, 0,-2,
	   2, 2,-2,
	   2, 2, 2,


	    2, 2, 2,   //Facet 5
	    2, 2,-2,   //TOP
	   -2, 2,-2,
	   -2, 2, 2,


	   -2, 0, 2,   //Facet 6
	   -2, 0,-2,   //Bottom
	    2, 0,-2,
	    2, 0, 2,
	   };


int facet1[][3]={
		  -4,0,0,-4,4,0,        //
		  -4,4,8,-4,0,8,        //   int FACET
		 };

//-----------------------  MAIN ROUTINES --------------------------------
main()
{

    Initialize();                         //set screen mode


   rx=screen_x/799;                      //define windowing ratio
   ry=screen_y/599;                      //
   nanglec = cos((-10.0) * .017453);     // Calculate constants
   panglec = cos((10.0) * .017453);      // for 3D cursor rotation
   nangles = sin((-10.0) * .017453);     //
   pangles = sin((10.0) * .017453);      //
   cangle =  cos(angle);                 //
   sangle =  sin(angle);                 //

   setfillstyle(SOLID_FILL,BLUE);
   flip_page();                          //flip to hidden page

ANIMATE:                                 //animation loop

   cleardevice();                        //blank the hidden page
   set_view();                            //translate your view point to
					  //an objects position
					  //currently are viewpoint
					  //is attached to the 3D cursor

   if(view_angle > 6.28) view_angle = 0;      //inhibit range of yaw angle
   if(view_angle < 0) view_angle = 6.28;
   if(view_direction > 6.28)   view_direction=0;    //inhibit this guy
   if(view_direction < 0)     view_direction=6.28;  //too ....


   sr1=sin(view_angle);              //calc new world viewing angles
   cr1=cos(view_angle);              //for 3D calculations
   control();                        //get keybrd input
   draw_horizon();                   //set color and draw horizon
   setcolor(GREEN);
   draw_facet(facet1,4,10,0,-5);     //Facet shows hidden surface removal
				     //by changing color from blue to white
   draw_list();                      //draw objects that are stationary
   draw_cursor();                    //draw the 3D cursor
   flip_page();
   goto ANIMATE;

}
//-------------------------------------------------------------------------
draw_list()
{
    // this will be a linked list later on

    draw_object(object2,FACETNUM,20,0,-20);
    draw_object(object2,FACETNUM,20,4,-20);

    return;
}
//---------------------------------------------------------------
draw_object(double array[][3],int fnum,double xoff,double yoff,double zoff)
{
    double x1,y1,z1;
    int t=0,s=0,ptr=0,sw=0,offset=0;
    int vert[8],res=0;


  for(s=0;s < fnum;s++)
   {
     ptr=0;                               //reset your index each time SC

     for(t=0;t < VERTICES;t++)            //draw each facet of object  SC
       {                                  //right know facets are made SC
					  //up of only 4 vertices      SC
	 x1=array[t+offset][0]+xoff;      //extract the facet data     SC
	 y1=array[t+offset][1]+yoff;      //one vertice at a time      SC
	 z1=array[t+offset][2]+zoff;      //then calc the screen x,y coord SC
	 point_3d(x1,y1,z1);
	 vert[ptr]=sx;                    //store sx coord             SC
	 ptr++;                           //move to next array location SC
	 vert[ptr]=sy;                    //save sy coord               SC
	 ptr++;                           //adjust to next location     SC
	}
	offset+=VERTICES;                 //offset into next facet      SC

      sw=chkface(vert);              //check to see if facet is facing you SC
      if(sw == 1)                    //if it is .... Draw it !!!!!   SC
	{
	  fillpoly(4,vert);          //Borland's fillpoly function   SC
	 }
      //	 loop until all facets are drawn     SC
     }

      return;

}
//------------------------------------------------------------
point_3d(double xoff,double yoff,double zoff)
{

    float xa,za;
    double x,y,z;

      x=xoff;
      y=yoff;
      z=zoff;

     x=x-viewpointx;       //offset the object from
     y=y+viewpointy;       //the viewers viewpoint
     z=z+viewpointz;       //

     xa=cr1*x-sr1*z;       //Calc the yaw translation
     za=sr1*x+cr1*z;       //

     sx=620*xa/za;         // This code mapps the world
     sy=620*y/za;          //coordinants to screen coordinants
     sx=sx+399;            //
     sy=sy+299;            //
     sx=sx*rx;             //
     sy=sy*ry;             //
     return;

}
//-----------------------------------------------------------------------
draw_cursor()
{
  //since this object is always going to be in front of the viewer ...
  // No 3D clipping is needed . so draw it !!!!!

     double sangle,cangle;

     sangle=sin(cursor_direction);
     cangle=cos(cursor_direction);

     cursorx+=cangle*time;           //calc for x incrementation
     cursorz+=sangle*time;           //calc for z incrementation
     draw_object(object1,FACETNUM,cursorx,cursory,cursorz);
     return;
}
//--------------------------------------------------------------------------
set_view()
{
      //point of view calculations
      // later on . you could pass the current object
      // that you want your view point to be attached to
      // substitute cursorx,mz,my for the passed object

     viewpointx=cursorx+viewpoint_distance*cos(view_direction);
     viewpointz=-cursorz+viewpoint_distance*sin(view_direction);
     viewpointy=-cursory+viewing_heigth;
     return;

}
//---------------------------------------------------------------------
void control(void)
{
     char key;

     if(!kbhit()) return;    //key wasn't hit so return

     key=keyboard();
      switch(key)
	{
/*Esc*/	   case 27: quit_pgm();   //quit program
/*spcbar*/ case 32: break;
/* F1 */   case 59: view_direction+=view_angle_increment;
		    view_angle+=view_angle_increment;
		    break;
/* F2 */   case 60: view_direction-=view_angle_increment;
		    view_angle-=view_angle_increment;
		    break;
/* F3 */   case 61: viewing_heigth-=1;break;
/* F4 */   case 62: viewing_heigth+=1;break;
/* F5 */   case 63: viewpoint_distance+=1;break;
/* F6 */   case 64: viewpoint_distance-=1;break;
/* F7 */   case 65: break;
/* F8 */   case 66: break;
/* F9 */   case 67: break;
/* F10*/   case 68: break;
/*left*/   case 75: left();cursor_direction+=view_angle_increment;
		    if(cursor_direction > 6.28) cursor_direction=0;
		    break;
/*rght*/   case 77: right();cursor_direction-=view_angle_increment;
		    if(cursor_direction < 0) cursor_direction=6.28;
		    break;
/*up*/     case 72: time+=.1;if(time>=2) time=2;break; //+ key increase throttle
/*dwn*/    case 80: time-=.1;if(time<=0) time=0;break;  //- key decrease throttle
	}

	  return;
}
//-----------------------------------------------------------------------
void draw_horizon(void)
{
   setcolor(BLUE);
   line(0,MaxY/2+30,MaxX,MaxY/2+30);
   return;
}
//--------------------------------------------------------------------
flip_page()
{
   //currently were in an easy mode to page flip
   //Mode 13 we would just draw to the virtual screen
   // then copy that Vscreen to video ram

   setactivepage(p);
   setvisualpage(1-p);
   p=1-p;                               //flip pages
   return;

}
//----------------------------------------------------------------------
char keyboard(void)
{
    // this function needs to go !!!!! I think it is really to slow

 union u_type{int a;char b[3];} keystroke;
 char inkey=0;
 if (bioskey(1)==0) {return;}
 keystroke.a=bioskey(0);
 inkey=keystroke.b[0];
 if (inkey!=0) return(inkey);		         //normal key depressed
 if (inkey==0) return(inkey=keystroke.b[1]);    //else extended key
     return;
}
//------------------------------------------------------------------------
void quit_pgm(void)
{
    setvisualpage(0);setactivepage(0);
    cleardevice();
    restorecrtmode();
    exit(0);
}
/*----------------------------------------------------------------------*/
Initialize()
{
     int GraphMode,GraphDriver,ErrorCode=0;

	 GraphDriver=DETECT;
	 initgraph(&GraphDriver,&GraphMode,"");
	 ErrorCode=graphresult();
	 if (ErrorCode!=grOk)
	  {
	    printf("Graphics Error:%s\n",grapherrormsg(ErrorCode));
	    exit(1);
	  }
	  setgraphmode(VGAMED);
	  MaxX=640;
	  MaxY=350;
	  return(0);
}
//---------------------------------------------------------------
draw_facet(int array[][3],int vnum,int xoff,int yoff,int zoff)
{
    int x1,y1,z1,t=0,ptr=0,sw=0;
    int vert[8];
   for(t=0;t < vnum;t++)
    {
      x1=array[t][0]+xoff;              //original facet data
      y1=array[t][1]+yoff;              //
      z1=array[t][2]+zoff;              //
      point_3d(x1,y1,z1);               //3D perspective formula
      vert[ptr]=sx;                     //store for later
      ptr++;
      vert[ptr]=sy;                     //
      ptr++;
      }
      sw=chkface(vert);         //check to see if facet is facing you
      if(sw == 1)
	{
	  setfillstyle(SOLID_FILL,WHITE);  //white color means facet is facing
	  fillpoly(4,vert);                //away from viewer
	  setfillstyle(SOLID_FILL,BLUE);   //restore drawing color
	 }
      else
	   fillpoly(4,vert);            //facet shows so keep the color
      return;
}
//---------------------------------------------------------------
int chkface(int array[8])
{
    //This is how we determine if the facet is visable or not


       int   x0,x1,x2,y0,y1,y2,res;
       long  v1,v2,w1,w2;

       x0=array[0];
       y0=array[1];                       //extract vector coords
       x1=array[2];
       y1=array[3];
       x2=array[4];
       y2=array[5];

      v1 = x1 - x0;
      w1 = x2 - x0;
      v2 = y1 - y0;
      w2 = y2 - y0;

     if((v1*w2 - v2*w1) > 0) res=1;
       else res=0;
       return(res);
}
//Ryan King wrote the Newer version of rotating the data in the
// objects array instead of rotating every point everytime we try to
// draw the screen ... much faster !!!!!!!!
//------------------------------------------------------------------------
down()
{
    double y1,z1,t=0;
    double oldz,oldy;

   for(t=0;t < (VERTICES*FACETNUM);t++)
    {
      oldy=object1[t][1];
      oldz=object1[t][2];
      object1[t][2] = ((panglec * oldz) - (pangles * oldy));
      object1[t][1] = ((pangles * oldz) + (panglec * oldy));
      }

      return 0;
}
//------------------------------------------------------------------------
up()
{
    double y1,z1,t=0;
    double oldz,oldy;

   for(t=0;t < (VERTICES*FACETNUM);t++)
    {
      oldy=object1[t][1];
      oldz=object1[t][2];
      object1[t][2] = ((nanglec * oldz) - (nangles * oldy));
      object1[t][1] = ((nangles * oldz) + (nanglec * oldy));
      }

    return 0;

}
//---------------------------------------------------------------------
right()
{
    double y1,z1,t=0;
    double oldz,oldy;

   for(t=0;t < (VERTICES*FACETNUM);t++)
    {
      oldy=object1[t][0];
      oldz=object1[t][2];
      object1[t][2] = ((panglec * oldz) - (pangles * oldy));
      object1[t][0] = ((pangles * oldz) + (panglec * oldy));
      }
	return 0;
}
//-----------------------------------------------------------------------
left()
{
    double y1,z1,t=0;
    double oldz,oldy;

   for(t=0;t < (VERTICES*FACETNUM);t++)
    {
      oldy=object1[t][0];
      oldz=object1[t][2];
      object1[t][2] = ((nanglec * oldz) - (nangles * oldy));
      object1[t][0] = ((nangles * oldz) + (nanglec * oldy));
      }
      return 0;
}






































































































