;Test include files:
;multi.fns
.486p
.model flat,c
.stack 100h
.code

multi_engine:


        call    Get_Base_Pointer
        mov     edx,OFFSET Object_File_Name
        call    Load_Object
        mov     [Object_3D.Eye_Distance],400


        mov     ax,0013h
        int     10h

        mov     esi,OFFSET palette
        mov     ecx,64*3
        call    Set_Palette
        mov     VAngle_X,360
        mov     VAngle_Y,0;600
        mov     VAngle_Z,0

;=== SECOND PART OF DEMO - FLAT SHADING ===
        @@Flat_Shading:

        mov     eax,XA
        imul    Speed
        add     VAngle_X,eax
        cmp     VAngle_X,360*4
        jb      @@VAngle_X_1
        sub     VAngle_X,360*4
        @@VAngle_X_1:

        mov     eax,YA
        imul    Speed
        add     VAngle_Y,eax
        cmp     VAngle_Y,360*4
        jb      @@VAngle_Y_1
        sub     VAngle_Y,360*4
        @@VAngle_Y_1:

        mov     eax,ZA
        imul    Speed
        add     VAngle_Z,eax
        cmp     VAngle_Z,360*4
        jb      @@VAngle_Z_1
        sub     VAngle_Z,360*4
        @@VAngle_Z_1:

        call    Multiply_Matrix
        call    Rotate_VArray
        call    Project_VArray
        call    Clear

        movzx   ecx,[Object_3D.Number_Of_Faces]
        mov     edi,Object_3D.OffSet_VArray_Projected
        mov     esi,Object_3D.OffSet_Faces
        mov     ebp,Object_3D.OffSet_FNormals_Rotated

        @@Flat_Shading_Main:

        mov     ebx,[esi]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X1],eax
        mov     eax,[edi+ebx+4]
        mov     [Y1],eax

        mov     ebx,[esi+4]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X2],eax
        mov     eax,[edi+ebx+4]
        mov     [Y2],eax

        mov     ebx,[esi+8]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X3],eax
        mov     eax,[edi+ebx+4]
        mov     [Y3],eax

        mov     eax,[X2]
        sub     eax,[X1]
        mov     ebx,[Y3]
        sub     ebx,[Y1]
        imul    ebx
        mov     ebx,eax

        mov     eax,[X3]
        sub     eax,[X1]
        mov     edx,[Y2]
        sub     edx,[Y1]
        imul    edx

        cmp     ebx,eax
        jg      @@Hidden_Face_Removal_Flat

        mov     eax,[ebp+8]
        sar     eax,2
        add     eax,5
        neg     eax
        cmp     eax,5
        jg      @@Color_OK
        mov     al,5
        @@Color_OK:
        mov     [Flat_Color],al

        push    ecx esi edi ebp
        call    Flat_Triangle_Filler
        pop     ebp edi esi ecx

        @@Hidden_Face_Removal_Flat:

        add     esi,12
        add     ebp,12

        dec     ecx
        jnz     @@Flat_Shading_Main

        call    Wait_Retrace
        call    Flip

        mov     ax,100h
        int     16h
        jz      @@Flat_Shading

        xor     ax,ax
        int     16h

;=== THIRD PART OF DEMO - GOURAUD SHADING ===
        @@Gouraud_Shading:

        mov     eax,XA
        imul    Speed
        add     VAngle_X,eax
        cmp     VAngle_X,360*4
        jb      @@VAngle_X_2
        sub     VAngle_X,360*4
        @@VAngle_X_2:

        mov     eax,YA
        imul    Speed
        add     VAngle_Y,eax
        cmp     VAngle_Y,360*4
        jb      @@VAngle_Y_2
        sub     VAngle_Y,360*4
        @@VAngle_Y_2:

        mov     eax,ZA
        imul    Speed
        add     VAngle_Z,eax
        cmp     VAngle_Z,360*4
        jb      @@VAngle_Z_2
        sub     VAngle_Z,360*4
        @@VAngle_Z_2:

        call    Multiply_Matrix
        call    Rotate_VArray
        call    Project_VArray
        call    Clear

        movzx   ecx,[Object_3D.Number_Of_Faces]
        mov     edi,Object_3D.OffSet_VArray_Projected
        mov     esi,Object_3D.OffSet_Faces
        mov     ebp,Object_3D.OffSet_NArray_Rotated

        @@Gouraud_Shading_Main:

        mov     ebx,[esi]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X1],eax
        mov     eax,[edi+ebx+4]
        mov     [Y1],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+8]
        sar     eax,3
        neg     eax
        cmp     eax,0
        jg      @@Color1_OK
        xor     eax,eax
        @@Color1_OK:
        mov     [C1],eax

        mov     ebx,[esi+4]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X2],eax
        mov     eax,[edi+ebx+4]
        mov     [Y2],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+8]
        sar     eax,3
        neg     eax
        cmp     eax,0
        jg      @@Color2_OK
        xor     eax,eax
        @@Color2_OK:
        mov     [C2],eax

        mov     ebx,[esi+8]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X3],eax
        mov     eax,[edi+ebx+4]
        mov     [Y3],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+8]
        sar     eax,3
        neg     eax
        cmp     eax,0
        jg      @@Color3_OK
        xor     eax,eax
        @@Color3_OK:
        mov     [C3],eax

        mov     eax,[X2]
        sub     eax,[X1]
        mov     ebx,[Y3]
        sub     ebx,[Y1]
        imul    ebx
        mov     ebx,eax

        mov     eax,[X3]
        sub     eax,[X1]
        mov     edx,[Y2]
        sub     edx,[Y1]
        imul    edx

        cmp     ebx,eax
        jg      @@Hidden_Face_Removal_Gouraud

        push    ecx esi edi ebp
        call    Gouraud_Triangle_Filler
        pop     ebp edi esi ecx

        @@Hidden_Face_Removal_Gouraud:

        add     esi,12

        dec     ecx
        jnz     @@Gouraud_Shading_Main

        call    Wait_Retrace
        call    Flip

        mov     ax,100h
        int     16h
        jz      @@Gouraud_Shading

        xor     ax,ax
        int     16h

;=== THIRD PART OF DEMO - TEXTURE MAPPING ===
        lea     edx,Texture_File1
        call    Load_Texture
        mov     esi,OFFSET text_pal
        mov     ecx,768
        call    Set_Palette
        mov     [ROTATE_VERTEX_NORMALS],0

        @@Texture:

        mov     eax,XA
        imul    Speed
        add     VAngle_X,eax
        cmp     VAngle_X,360*4
        jb      @@VAngle_X_3
        sub     VAngle_X,360*4
        @@VAngle_X_3:

        mov     eax,YA
        imul    Speed
        add     VAngle_Y,eax
        cmp     VAngle_Y,360*4
        jb      @@VAngle_Y_3
        sub     VAngle_Y,360*4
        @@VAngle_Y_3:

        mov     eax,ZA
        imul    Speed
        add     VAngle_Z,eax
        cmp     VAngle_Z,360*4
        jb      @@VAngle_Z_3
        sub     VAngle_Z,360*4
        @@VAngle_Z_3:

        call    Multiply_Matrix
        call    Rotate_VArray
        call    Project_VArray
        call    Clear

        movzx   ecx,[Object_3D.Number_Of_Faces]
        mov     edi,Object_3D.OffSet_VArray_Projected
        mov     esi,Object_3D.OffSet_Faces
        mov     ebp,Object_3D.OffSet_NArray_Rotated

        @@Texture_Main:

        mov     ebx,[esi]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X1],eax
        mov     eax,[edi+ebx+4]
        mov     [Y1],eax

        mov     ebx,[esi+4]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X2],eax
        mov     eax,[edi+ebx+4]
        mov     [Y2],eax

        mov     ebx,[esi+8]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X3],eax
        mov     eax,[edi+ebx+4]
        mov     [Y3],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X1
        mov     eax,255
        @@Map_X1:
        mov     [MX1],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y1
        mov     eax,255
        @@Map_Y1:
        mov     [MY1],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X2
        mov     eax,255
        @@Map_X2:
        mov     [MX2],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y2
        mov     eax,255
        @@Map_Y2:
        mov     [MY2],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X3
        mov     eax,255
        @@Map_X3:
        mov     [MX3],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y3
        mov     eax,255
        @@Map_Y3:
        mov     [MY3],eax

        mov     eax,[X2]
        sub     eax,[X1]
        mov     ebx,[Y3]
        sub     ebx,[Y1]
        imul    ebx
        mov     ebx,eax

        mov     eax,[X3]
        sub     eax,[X1]
        mov     edx,[Y2]
        sub     edx,[Y1]
        imul    edx

        cmp     ebx,eax
        jg      @@Hidden_Face_Removal_Texture

        push    ecx esi edi ebp
        call    Texture_Triangle_Filler
        pop     ebp edi esi ecx

        @@Hidden_Face_Removal_Texture:

        add     esi,12

        dec     ecx
        jnz     @@Texture_Main

        call    Wait_Retrace
        call    Flip

        mov     ax,100h
        int     16h
        jz      @@Texture
        xor     eax,eax
        int     16h

;=== FOURTH PART OF DEMO - ENVMAP ===
        mov     [ROTATE_VERTEX_NORMALS],1
        @@ENV:

        mov     eax,XA
        imul    Speed
        add     VAngle_X,eax
        cmp     VAngle_X,360*4
        jl      @@VAngle_X_4
        sub     VAngle_X,360*4
        @@VAngle_X_4:

        mov     eax,YA
        imul    Speed
        add     VAngle_Y,eax
        cmp     VAngle_Y,360*4
        jl      @@VAngle_Y_4
        sub     VAngle_Y,360*4
        @@VAngle_Y_4:

        mov     eax,ZA
        imul    Speed
        add     VAngle_Z,eax
        cmp     VAngle_Z,360*4
        jl      @@VAngle_Z_4
        sub     VAngle_Z,360*4
        @@VAngle_Z_4:

        call    Multiply_Matrix
        call    Rotate_VArray
        call    Project_VArray
        call    Clear

        movzx   ecx,[Object_3D.Number_Of_Faces]
        mov     edi,Object_3D.OffSet_VArray_Projected
        mov     esi,Object_3D.OffSet_Faces
        mov     ebp,Object_3D.OffSet_NArray_Rotated

        @@ENV_Main:

        mov     ebx,[esi]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X1],eax
        mov     eax,[edi+ebx+4]
        mov     [Y1],eax

        mov     ebx,[esi+4]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X2],eax
        mov     eax,[edi+ebx+4]
        mov     [Y2],eax

        mov     ebx,[esi+8]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X3],eax
        mov     eax,[edi+ebx+4]
        mov     [Y3],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X11
        mov     eax,255
        @@Map_X11:
        mov     [MX1],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y11
        mov     eax,255
        @@Map_Y11:
        mov     [MY1],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X21
        mov     eax,255
        @@Map_X21:
        mov     [MX2],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y21
        mov     eax,255
        @@Map_Y21:
        mov     [MY2],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X31
        mov     eax,255
        @@Map_X31:
        mov     [MX3],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y31
        mov     eax,255
        @@Map_Y31:
        mov     [MY3],eax

        mov     eax,[X2]
        sub     eax,[X1]
        mov     ebx,[Y3]
        sub     ebx,[Y1]
        imul    ebx
        mov     ebx,eax

        mov     eax,[X3]
        sub     eax,[X1]
        mov     edx,[Y2]
        sub     edx,[Y1]
        imul    edx

        cmp     ebx,eax
        jg      @@Hidden_Face_Removal_ENV

        push    ecx esi edi ebp
        call    Texture_Triangle_Filler
        pop     ebp edi esi ecx

        @@Hidden_Face_Removal_ENV:

        add     esi,12

        dec     ecx
        jnz     @@ENV_Main

        call    Wait_Retrace
        call    Flip

        mov     eax,100h
        int     16h
        jz      @@ENV

        xor     eax,eax
        int     16h
;=== FOURTH PART OF DEMO - PHONG ===
        lea     edx,Texture_File
        call    Load_Texture
        mov     esi,OFFSET text_pal1
        mov     ecx,768
        call    Set_Palette

        @@Phong:

        mov     eax,XA
        imul    Speed
        add     VAngle_X,eax
        cmp     VAngle_X,360*4
        jl      @@VAngle_X_5
        sub     VAngle_X,360*4
        @@VAngle_X_5:

        mov     eax,YA
        imul    Speed
        add     VAngle_Y,eax
        cmp     VAngle_Y,360*4
        jl      @@VAngle_Y_5
        sub     VAngle_Y,360*4
        @@VAngle_Y_5:

        mov     eax,ZA
        imul    Speed
        add     VAngle_Z,eax
        cmp     VAngle_Z,360*4
        jl      @@VAngle_Z_5
        sub     VAngle_Z,360*4
        @@VAngle_Z_5:

        call    Multiply_Matrix
        call    Rotate_VArray
        call    Project_VArray
        call    Clear

        movzx   ecx,[Object_3D.Number_Of_Faces]
        mov     edi,Object_3D.OffSet_VArray_Projected
        mov     esi,Object_3D.OffSet_Faces
        mov     ebp,Object_3D.OffSet_NArray_Rotated

        @@Phong_Main:

        mov     ebx,[esi]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X1],eax
        mov     eax,[edi+ebx+4]
        mov     [Y1],eax

        mov     ebx,[esi+4]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X2],eax
        mov     eax,[edi+ebx+4]
        mov     [Y2],eax

        mov     ebx,[esi+8]
        shl     ebx,3
        mov     eax,[edi+ebx]
        mov     [X3],eax
        mov     eax,[edi+ebx+4]
        mov     [Y3],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X111
        mov     eax,255
        @@Map_X111:
        mov     [MX1],eax

        mov     ebx,[esi]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y111
        mov     eax,255
        @@Map_Y111:
        mov     [MY1],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X211
        mov     eax,255
        @@Map_X211:
        mov     [MX2],eax

        mov     ebx,[esi+4]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y211
        mov     eax,255
        @@Map_Y211:
        mov     [MY2],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_X311
        mov     eax,255
        @@Map_X311:
        mov     [MX3],eax

        mov     ebx,[esi+8]
        mov     eax,ebx
        add     eax,eax
        add     eax,ebx
        sal     eax,2
        mov     eax,[ebp+eax+4]
        sar     eax,2
        sub     eax,100
        neg     eax
        cmp     eax,255
        jl      @@Map_Y311
        mov     eax,255
        @@Map_Y311:
        mov     [MY3],eax

        mov     eax,[X2]
        sub     eax,[X1]
        mov     ebx,[Y3]
        sub     ebx,[Y1]
        imul    ebx
        mov     ebx,eax

        mov     eax,[X3]
        sub     eax,[X1]
        mov     edx,[Y2]
        sub     edx,[Y1]
        imul    edx

        cmp     ebx,eax
        jg      @@Hidden_Face_Removal_Phong

        push    ecx esi edi ebp
        call    Texture_Triangle_Filler
        pop     ebp edi esi ecx

        @@Hidden_Face_Removal_Phong:

        add     esi,12

        dec     ecx
        jnz     @@Phong_Main

        call    Wait_Retrace
        call    Flip

        mov     eax,100h
        int     16h
        jz      @@Phong

        mov     ax,0003h
        int     10h
        mov     ax,900h
        lea     edx,End_Message
        int     21h
        mov     eax,4c00h
        int     21h


      align 4
Clear proc near
      lea     edi,[Virtual_Screen]
      mov     ecx,16000
      xor     eax,eax
      rep     stosd
      ret
Clear endp

     align 4
Flip proc near
     xor     ecx,ecx
     call    Trick_X
     mov     ecx,199
     call    Trick_X
     xor     ecx,ecx
     call    Trick_Y
     mov     ecx,319
     call    Trick_Y
     mov     edi,0a0000h
     sub     edi,[Base_Pointer]
     lea     esi,[Virtual_Screen]
     mov     ecx,16000
     rep     movsd
     ret
Flip endp

        align 4
Trick_X proc near
        lea       edi,[Virtual_Screen]
        lea       ecx,[ecx+ecx*4]
        shl       ecx,6
        add       edi,ecx
        mov       ecx,80
        xor       eax,eax
        rep       stosd
        ret
Trick_X endp

        align 4
Trick_Y proc near
        lea       edi,[Virtual_Screen]
        add       edi,ecx
        mov       ecx,200
        mov       al,0
        rept      200
        mov       [edi],al
        add       edi,320
        endm
        ret
Trick_Y endp

include ../includes/multi.inc
;include ../data/t1.inc
include ../data/phong.inc
;include ../data/bump.inc
include ../data/texture.inc

.data

Palette label byte
i=0
rept 64
  db i,i,i
  i=i+1
endm

XA               dd 4
YA               dd 4
ZA               dd 4
Speed            dd 1
Object_File_Name db '../objects/sakk.dat',0
;Texture_File     db '../data/t1.bin',0
Texture_File     db '../data/phong.bin',0
;Texture_File1    db '../data/bump.bin',0
Texture_File1    db '../data/texture.bin',0
End_Message   db 'Multi shading 3D vector engine by maLi/DarkSiDe',13,10
              db 'E-mail: mtrtnik@info.src.si$',13,10

Virtual_Screen   db 64000 dup (?)

end multi_engine

