                        ALIGN 4
Gouraud_Triangle_Filler PROC NEAR

                        call       Sort_Y              ;sort y coordinates
                        call       Clip_Y_All

                        sal        [X1],16             ;make fixed points
                        sal        [X2],16
                        sal        [X3],16
                        sal        [C1],16
                        sal        [C2],16
                        sal        [C3],16

                        mov        eax,[X3]            ;calculate longer edge -
                        sub        eax,[X1]            ;right edge
                        mov        esi,[Y3]            ;x adder
                        sub        esi,[Y1]
                        or         esi,esi
                        jz         @@No_Gouraud_Triangle
                        cdq
                        idiv       esi
                        mov        [X_Adder_Right],eax ;(x3 - x1) / (y3 - y1)

                        mov        eax,[C3]            ;calculate longer edge -
                        sub        eax,[C1]            ;right edge
                        cdq                            ;color adder
                        idiv       esi
                        mov        [C_Adder_Right],eax ;(c3 - c1) / (y3 - y1)

                        mov        eax,[X2]            ;calculate shorter edge -
                        sub        eax,[X1]            ;left edge
                        mov        esi,[Y2]            ;check if there's
                        sub        esi,[Y1]            ;no upper gouraud
                        or         esi,esi             ;triangle at all
                        jz         @@No_Upper_Gouraud_Triangle
                        cdq                            ;x adder
                        idiv       esi
                        mov        [X_Adder_Left],eax  ;(x2 - x1) / (y2 - y1)

                        mov        eax,[C2]            ;calculate shorter edge -
                        sub        eax,[C1]            ;left edge
                        cdq                            ;color adder
                        idiv       esi
                        mov        [C_Adder_Left],eax  ;(c2 - c1) / (y2 - y1)

                        mov        ebp,[Y1]            ;calculate offset on
                        lea        ebp,[ebp+ebp*4]     ;screen to draw
                        shl        ebp,6               ;NOTE: only Y position
                        lea        edi,[Virtual_Screen];we add X in procedure
                        add        edi,ebp             ;Draw_Gouraud_Segment

                        mov        ebx,[X1]            ;starting x values
                        mov        edx,ebx
                        mov        eax,[C1]            ;starting color values
                        mov        ecx,eax

                        push       eax ebx ecx edx esi ;calculate G
                        @@Calc_G:
                        add        ebx,[X_Adder_Left]  ;we have to do it
                        add        edx,[X_Adder_Right] ;at longest hline
                        add        eax,[C_Adder_Left]  ;and that's at the
                        add        ecx,[C_Adder_Right] ;bottom of firt
                        dec        esi                 ;segment of triangle
                        jnz        @@Calc_G
                        sub        eax,ecx             ;c_end - c_start
                        mov        ecx,ebx             ;calc hline here
                        mov        cx,0ffffh
                        sub        ecx,edx             ;x_end - x_start
                        sar        ecx,16
                        inc        ecx
                        or         ecx,ecx
                        jz         @@ZeroG_1
                        cdq
                        idiv       ecx
                        @@ZeroG_1:
                        rol        eax,16
                        mov        [G],eax             ;save G
                        pop        esi edx ecx ebx eax

                        mov        ebp,[X_Adder_Left]  ;compare both adders
                        cmp        ebp,[X_Adder_Right] ;to see which procedure
                        jg         @@Gouraud_1         ;we have to call
                        call       Draw_Gouraud_Segment;if X_Adder_Left <
                        jmp        @@Gouraud_2         ;X_Adder_Right then
                        @@Gouraud_1:                   ;we draw from ebx to edx
                        call       Draw_Gouraud_Segment1;otherwise from edx to ebx1
                        @@Gouraud_2:

                        mov        esi,[Y3]            ;if y2 = y3 we just return back
                        sub        esi,[Y2]            ;otherwise we have to draw
                        or         esi,esi             ;lower segment of triangle
                        jnz        @@Draw_Lower_Gouraud_Segment

                        ret                            ;return

                        @@Draw_Lower_Gouraud_Segment:

                        push       edx                 ;IDIV suxx cause it destroy EDX ;-)
                        mov        eax,[X3]            ;we have to update
                        sub        eax,[X2]            ;left edge
                        cdq                            ;x adder
                        idiv       esi
                        mov        [X_Adder_Left],eax  ;(x3 - x2) / (y3 - y2)

                        mov        eax,[C3]            ;we have to update
                        sub        eax,[C2]            ;left edge
                        cdq                            ;color adder
                        idiv       esi
                        mov        [C_Adder_Left],eax  ;(c3 - c2) / (y3 - y2)

                        mov        ebx,[X2]            ;update x position
                        mov        eax,[C2]            ;and color value
                        pop        edx                 ;oh not, again IDIV

                        cmp        ebx,edx             ;compare both x positions
                        jg         @@Gouraud_3         ;to see which procedure
                                                       ;we have to call
                        call       Draw_Gouraud_Segment;if ebx < edx then we
                        jmp        @@Gouraud_4         ;draw from ebx to edx
                        @@Gouraud_3:                   ;otherwise from edx to ebx
                        call       Draw_Gouraud_Segment1
                        @@Gouraud_4:

                        ret                            ;return


                        @@No_Upper_Gouraud_Triangle:   ;y1 = y2

                        ;mov        eax,[X3]            ;left edge
                        ;sub        eax,[X1]            ;x adder
                        ;mov        esi,[Y3]            ;since y1=y2 we need
                        ;sub        esi,[Y1]            ;to calc this only once
                        ;cdq
                        ;idiv       esi
                        mov        eax,[X_Adder_Right]
                        mov        [X_Adder_Left],eax  ;(x3 - x1) / (y3 - y1)

                        ;mov        eax,[C3]            ;left edge
                        ;sub        eax,[C1]            ;color adder
                        ;cdq
                        ;idiv       esi
                        mov        eax,[C_Adder_Right]
                        mov        [C_Adder_Left],eax  ;(c3 - c1) / (y3 - y1)

                        mov        eax,[X3]            ;right edge
                        sub        eax,[X2]            ;x adder
                        mov        esi,[Y3]            ;since y1=y2 we need
                        sub        esi,[Y2]            ;to calc this only once
                        or         esi,esi
                        jz         @@No_Gouraud_Triangle
                        cdq
                        idiv       esi
                        mov        [X_Adder_Right],eax ;(x3 - x2) / (y3 - y2)

                        mov        eax,[C3]            ;right edge
                        sub        eax,[C2]            ;color adder
                        cdq
                        idiv       esi
                        mov        [C_Adder_Right],eax ;(c3 - c2) / (y3 - y2)

                        mov        ebp,[Y1]            ;calculate offset on
                        lea        ebp,[ebp+ebp*4]     ;screen to draw
                        shl        ebp,6               ;NOTE: only Y position
                        lea        edi,[Virtual_Screen];we add X in procedure
                        add        edi,ebp             ;Draw_Gouraud_Segment

                        mov        ebx,[X1]            ;setup starting values
                        mov        edx,[X2]            ;x positions
                        mov        eax,[C1]            ;and
                        mov        ecx,[C2]            ;color values

                        push       eax ebx ecx edx     ;calculate G
                        sub        eax,ecx             ;c_end - c_start
                        mov        ecx,ebx             ;calc hline here
                        mov        cx,0ffffh
                        sub        ecx,edx             ;x_end - x_start
                        sar        ecx,16
                        inc        ecx
                        or         ecx,ecx
                        jz         @@ZeroG_2
                        cdq
                        idiv       ecx
                        @@ZeroG_2:
                        rol        eax,16
                        mov        [G],eax             ;save G
                        pop        edx ecx ebx eax

                        cmp        ebx,edx             ;compare both x positions
                        jg         @@Gouraud_5         ;to see which procedure we have to call
                        call       Draw_Gouraud_Segment;if ebx < edx then we
                        jmp        @@Gouraud_6         ;draw from ebx to edx
                        @@Gouraud_5:                   ;otherwise from edx to ebx
                        call       Draw_Gouraud_Segment1
                        @@Gouraud_6:

                        @@No_Gouraud_Triangle:

                        ret                            ;return

Gouraud_Triangle_Filler endp

;;
;                                                                          ;
; Name       : Draw_Gouraud_Segment                                        ;
; Description: Draw one segment of gouraud triangle                        ;
; Input      : EDI = screen offset (row number)                            ;
;              EBX = start x position                                      ;
;              EDX = end x position                                        ;
;              EAX = start color value                                     ;
;              ECX = end color value                                       ;
;              ESI = height of triangle                                    ;
; Output     : /                                                           ;
; Uses       :                                                             ;
;                                                                          ;
;;
                     ALIGN 4
Draw_Gouraud_Segment PROC NEAR

                     @@Draw_Gouraud_Segment_Loop:
                                                       ;interpolating...
                     add           ebx,[X_Adder_Left]  ;left edge
                     add           edx,[X_Adder_Right] ;right edge
                     add           eax,[C_Adder_Left]
                     add           ecx,[C_Adder_Right]

                     push          eax ebx ecx edi

                     mov           ebp,ebx
                     sar           ebp,16              ;get x position of current hline
                     add           edi,ebp             ;calculate offset on screen
                     mov           ebp,eax

                     mov           ecx,edx             ;calculating lenght of hline here
                     mov           cx,0ffffh           ;DO NOT REMOVE THAT LINE!
                     sub           ecx,ebx             ;kalms's advice
                     sar           ecx,16              ;it makes shapes better looking
                     inc           ecx

                     mov           ebx,ebp
                     rol           ebx,16
                     mov           ebp,[G]

                     or            ecx,ecx
                     jz            @@No_Gouraud_HLine

                     neg           ecx
                     sub           edi,ecx
                     @@Gouraud_Inner_Loop:
                     adc           ebx,ebp
                     mov           [edi+ecx],bl
                     inc           ecx
                     jnz           @@Gouraud_Inner_Loop
                     @@No_Gouraud_HLine:
                     pop           edi ecx ebx eax
                     add           edi,320

                     dec           esi
                     jnz           @@Draw_Gouraud_Segment_Loop

                     ret                               ;return

Draw_Gouraud_Segment ENDP


;;
;                                                                          ;
; Name       : Draw_Gouraud_Segment1                                       ;
; Description: Draw one segment of gouraud triangle                        ;
; Input      : EDI = screen offset (row number)                            ;
;              EDX = start x position                                      ;
;              EBX = end x position                                        ;
;              ECX = start color value                                     ;
;              EAX = end color value                                       ;
;              ESI = height of triangle                                    ;
; Output     : /                                                           ;
; Uses       :                                                             ;
;                                                                          ;
;;
                      ALIGN 4
Draw_Gouraud_Segment1 PROC NEAR

                      @@Draw_Gouraud_Segment_Loop1:
                                                       ;interpolating...
                      add           ebx,[X_Adder_Left] ;left edge
                      add           edx,[X_Adder_Right];right edge
                      add           eax,[C_Adder_Left]
                      add           ecx,[C_Adder_Right]

                      push          eax ebx ecx edi

                      mov           ebp,edx
                      sar           ebp,16             ;get x position of current hline
                      add           edi,ebp            ;calculate offset on screen
                      mov           ebp,ecx

                      mov           ecx,ebx            ;calculating lenght of hline here
                      mov           cx,0ffffh          ;DO NOT REMOVE THAT LINE!
                      sub           ecx,edx            ;kalms's advice
                      sar           ecx,16             ;it makes shapes better looking
                      inc           ecx

                      mov           ebx,ebp            ;start color
                      rol           ebx,16
                      mov           ebp,[G]            ;c adder
                      or            ecx,ecx
                      jz            @@No_Gouraud_HLine1

                      neg           ecx
                      sub           edi,ecx

                      @@Gouraud_Inner_Loop1:           ;inner loop
                      adc           ebx,ebp
                      mov           [edi+ecx],bl
                      inc           ecx
                      jnz           @@Gouraud_Inner_Loop1
                      @@No_Gouraud_HLine1:
                      pop           edi ecx ebx eax
                      add           edi,320

                      dec           esi
                      jnz           @@Draw_Gouraud_Segment_Loop1

                      ret                              ;return

Draw_Gouraud_Segment1 ENDP



