SCREEN_WIDTH          equ 320       ;width
SCREEN_HEIGHT         equ 200       ;height

SCREEN_HALF_WIDTH     equ 160       ;width / 2
SCREEN_HALF_HEIGHT    equ 100       ;height / 2

ROTATE_VERTICES       equ 1         ;rotate object vertices if 1
ROTATE_VERTEX_NORMALS dd  1         ;rotate object vertex normals if 1
ROTATE_FACE_NORMALS   equ 1         ;rotate object face normals if 1

LIMIT_FLAT            equ 1         ;shade limit to flat if 1
LIMIT_GOURAUD         equ 1         ;shade limit to gouraud if 1
LIMIT_TEXTURE         equ 1         ;shade limit to texture mapping if 1
LIMIT_ENVMAP          equ 1         ;shade limit to envmap if 1

CLIP_TOP              equ 1         ;clip on top if 1
CLIP_BOTTOM           equ 1         ;clip on bottom if 1
CLIP_LEFT             equ 1         ;clip on left if 1
CLIP_RIGHT            equ 1         ;clip on right if 1

VERTICAL_RETRACE      equ 0         ;wait for verticl retrace if 1

CLIP_LEFT_LIMIT       equ 0*65536   ;where do we have to clip on left
CLIP_TOP_LIMIT        equ 0         ;where do we have to clip on top
CLIP_RIGHT_LIMIT      equ 320*65536 ;where do we have to clip on right
CLIP_BOTTOM_LIMIT     equ 200       ;where do we have to clip on bottom

ENGINE_VERSION        equ 10

;triangle vertex values
X1                    dd  ?
Y1                    dd  ?
Z1                    dd  ?
C1                    dd  ?
MX1                   dd  ?
MY1                   dd  ?
X2                    dd  ?
Y2                    dd  ?
Z2                    dd  ?
C2                    dd  ?
MX2                   dd  ?
MY2                   dd  ?
X3                    dd  ?
Y3                    dd  ?
Z3                    dd  ?
C3                    dd  ?
MX3                   dd  ?
MY3                   dd  ?

Flat_Color            db  ?         ;color for flat shading
X_Adder_Left          dd  ?         ;left X adder for triangles
X_Adder_Right         dd  ?         ;right X adder for triangles
C_Adder_Left          dd  ?         ;left C adder for gouraud triangle
C_Adder_Right         dd  ?         ;right C adder for gouraud triangle
T_Adder_Left_X        dd  ?         ;left X adder for texture mapped triangle
T_Adder_Left_Y        dd  ?         ;left Y adder for texture mapped triangle
T_Adder_Right_X       dd  ?         ;right X adder for texture mapped triangle
T_Adder_Right_Y       dd  ?         ;right Y adder for texture mapped triangle
Mapping_Left_X        dd  ?         ;it holds current left X position in texture
Mapping_Left_Y        dd  ?         ;it holds current left Y position in texture
Mapping_Right_X       dd  ?         ;it holds current right X position in texture
Mapping_Right_Y       dd  ?         ;it holds current right Y position in texture
G                     dd  ?         ;gouraud interpolating color value
U                     dd  ?         ;texture interpolating value U (used for x)
V                     dd  ?         ;texture interpolating value V (used for y)
Base_Pointer          dd  ?         ;this is used for screen manipulations

VAngle_X              dd  ?         ;rotating X angle of vertex
VAngle_Y              dd  ?         ;rotating Y angle of vertex
VAngle_Z              dd  ?         ;rotating Z angle of vertex
M11                   dd  ?         ;matrix components
M12                   dd  ?
M13                   dd  ?
M21                   dd  ?
M22                   dd  ?
M23                   dd  ?
M31                   dd  ?
M32                   dd  ?
M33                   dd  ?
M41                   dd  ?
M42                   dd  ?
M43                   dd  ?
XY                    dd  ?

;;
;                                                                          ;
; Name       : Get_Base_Pointer                                            ;
; Description: Get base address of segment                                 ;
; Input      : /                                                           ;
; Output     : Base_Pointer                                                ;
; Uses       : AX,EBX                                                      ;
;                                                                          ;
;;
                 align 4
Get_Base_Pointer proc near
                 mov     ax,0ee02h
                 int     31h
                 mov     [Base_Pointer],ebx
                 ret
Get_Base_Pointer endp
