{DigEx multi object converter}
uses crt;
type pvertex=^tvertex;
     tvertex=record
               x,y,z:longint;
               nx,ny,nz:longint;
               next:pvertex;
             end;

     pface=^tface;
     tface=record
             a,b,c:longint;
             nx,ny,nz:longint;
             next:pface;
           end;

     pobject=^tobject;
     tobject=record
               vertex:pvertex;
               zac_v:pvertex;
               face:pface;
               zac_f:pface;
               name:string;
               ypos:longint;
               num_vertices:word;
               num_faces:word;
               next:pobject;
               normals:boolean;
               what:byte; {0=object,1=camera,2=light}
             end;

var f:text;
    ff:file;
    tmp_v,tmpv:pvertex;
    tmp_f,tmpf:pface;
    outf,last_name,inf,s,s1,name:string;
    prva,obstaja,file_3ds:boolean;
    fixed_point,objektov,i,j,l:integer;
    y:longint;
    ch:char;
    obj,tobj,zac_obj:pobject;

procedure add_vertex(x,y,z:longint;prvic:boolean);
var v:pvertex;
begin
  if prvic then begin
    new(obj^.vertex);
    obj^.vertex^.x:=x;
    obj^.vertex^.y:=y;
    obj^.vertex^.z:=z;
    obj^.vertex^.nx:=0;
    obj^.vertex^.ny:=0;
    obj^.vertex^.nz:=0;
    obj^.vertex^.next:=nil;
    obj^.zac_v:=obj^.vertex;
  end
  else begin
    new(v);
    v^.x:=x;
    v^.y:=y;
    v^.z:=z;
    v^.nx:=0;
    v^.ny:=0;
    v^.nz:=0;
    v^.next:=nil;
    obj^.vertex^.next:=v;
    obj^.vertex:=v;
  end;
end;

procedure add_face(a,b,c:longint;prvic:boolean);
var f:pface;
begin
  if prvic then begin
    new(obj^.face);
    obj^.face^.a:=a;
    obj^.face^.b:=b;
    obj^.face^.c:=c;
    obj^.face^.next:=nil;
    obj^.zac_f:=obj^.face;
  end
  else begin
    new(f);
    f^.a:=a;
    f^.b:=b;
    f^.c:=c;
    f^.next:=nil;
    obj^.face^.next:=f;
    obj^.face:=f;
  end;
end;

procedure add_normal(nx,ny,nz:longint;n:longint);
begin
  tmp_v:=obj^.zac_v;
  for i:=1 to n do tmp_v:=tmp_v^.next;
  inc(tmp_v^.nx,nx);
  inc(tmp_v^.ny,ny);
  inc(tmp_v^.nz,nz);
end;

procedure get_vertex(var x,y,z:longint;n:longint);
begin
  tmp_v:=obj^.zac_v;
  for i:=1 to n do tmp_v:=tmp_v^.next;
  x:=tmp_v^.x;
  y:=tmp_v^.y;
  z:=tmp_v^.z;
end;


procedure create_normals;
var x1,y1,z1,
    x2,y2,z2,
    x3,y3,z3,
    u1,u2,u3,
    v1,v2,v3,
    nx,ny,nz:longint;
    length:real;
begin
  tmp_f:=obj^.zac_f;
  while tmp_f<>nil do begin
    {preberi koordinate trikotnika}
    get_vertex(x1,y1,z1,tmp_f^.a);
    get_vertex(x2,y2,z2,tmp_f^.b);
    get_vertex(x3,y3,z3,tmp_f^.c);
    {kreiraj normale}

    u1:=x1-x2;{calculating our first vector}
    u2:=y1-y2;
    u3:=z1-z2;

    v1:=x1-x3;{calculating our second vector}
    v2:=y1-y3;
    v3:=z1-z3;

    nx:=u2*v3-u3*v2;{cross product}
    ny:=u3*v1-u1*v3;
    nz:=u1*v2-u2*v1;

    length:=nx*nx+ny*ny+nz*nz;
    if length>0 then
    length:=sqrt(length);{calculate length of normal}
    if length=0 then begin
      nx:=0;
      ny:=0;
      nz:=0;
    end
    else begin
      tmp_f^.nx:=round((nx/length) * fixed_point);{normalize}
      tmp_f^.ny:=round((ny/length) * fixed_point);
      tmp_f^.nz:=round((nz/length) * fixed_point);
    end;
    tmp_f:=tmp_f^.next;
  end;

  tmp_f:=obj^.zac_f;
  while tmp_f<>nil do begin
    add_normal(tmp_f^.nx,tmp_f^.ny,tmp_f^.nz,tmp_f^.a);
    add_normal(tmp_f^.nx,tmp_f^.ny,tmp_f^.nz,tmp_f^.b);
    add_normal(tmp_f^.nx,tmp_f^.ny,tmp_f^.nz,tmp_f^.c);
    tmp_f:=tmp_f^.next;
  end;

  tmp_v:=obj^.zac_v;
  while tmp_v<>nil do begin
    tmp_v^.nx:=tmp_v^.nx div 3;
    tmp_v^.ny:=tmp_v^.ny div 3;
    tmp_v^.nz:=tmp_v^.nz div 3;
    tmp_v:=tmp_v^.next;
  end;
end;

procedure create_object(obj_name:string);
var koncaj,minus:boolean;
    pozicija,v,face,vert,x,y,z,a,b,c:longint;
    l:integer;
    pog:string;
begin
  assign(f,inf);
  reset(f);
  obj:=zac_obj;
  pozicija:=0;
  koncaj:=true;
  while obj<>nil do begin
    if koncaj then inc(pozicija);
    if obj_name=obj^.name then begin
      y:=obj^.ypos;
      vert:=obj^.num_vertices;
      face:=obj^.num_faces;
      koncaj:=false;
    end;
    obj:=obj^.next;
  end;
  obj:=zac_obj;
  dec(pozicija);
  for i:=1 to pozicija do obj:=obj^.next;
  for i:=1 to y+1 do readln(f,s);
  str(vert-1,pog);
  pog:='Vertex '+pog+':';
  koncaj:=false;
  v:=0;
  prva:=true;
  while not koncaj do begin
    readln(f,s);
    if (pos('X:',s)>0) and (pos('Y:',s)>0) and (pos('Z:',s)>0) then begin
      {write('Vertex ',v,': ');}
      i:=1;
      {NAJDI X KOORDINATO}
      minus:=false;
      while s[i-1]+s[i]<>'X:' do inc(i);
      inc(i,2);
      if s[i]='-' then begin
        minus:=true;
        inc(i);
      end;
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  and (i<=ord(s[0])) do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,x,l);
      if minus then x:=0-x;
      {write(x,' ');}
      {NAJDI Y KOORDINATO}
      minus:=false;
      while s[i-1]+s[i]<>'Y:' do inc(i);
      inc(i,2);
      if s[i]='-' then begin
        minus:=true;
        inc(i);
      end;
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  and (i<=ord(s[0])) do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,y,l);
      if minus then y:=0-y;
      {write(y,' ');}
      {NAJDI Z KOORDINATO}
      minus:=false;
      while s[i-1]+s[i]<>'Z:' do inc(i);
      inc(i,2);
      if s[i]='-' then begin
        minus:=true;
        inc(i);
      end;
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  and (i<=ord(s[0])) do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,z,l);
      if minus then z:=0-z;
      inc(v);
      add_vertex(x,y,z,prva);
      if prva=true then prva:=false;
    end;
    if pos(pog,s)>0 then koncaj:=true;
  end;
  str(face-1,pog);
  pog:='Face '+pog+':';
  koncaj:=false;
  v:=0;
  prva:=true;
  while not koncaj do begin
    readln(f,s);
    if (pos('A:',s)>0) and (pos('B:',s)>0) and (pos('C:',s)>0) then begin
      i:=1;
      {NAJDI A FACO}
      while s[i-1]+s[i]<>'A:' do inc(i);
      inc(i);
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  and (i<=ord(s[0])) do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,a,l);
      {NAJDI B FACO}
      while s[i-1]+s[i]<>'B:' do inc(i);
      inc(i);
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,b,l);
      {NAJDI C FACO}
      while s[i-1]+s[i]<>'C:' do inc(i);
      inc(i);
      s1:='';
      while (s[i]>='0') and (s[i]<='9')  do begin
        s1:=s1+s[i];
        inc(i);
      end;
      val(s1,c,l);
      inc(v);
      add_face(a,b,c,prva);
      if prva=true then prva:=false;
    end;
    if pos(pog,s)>0 then koncaj:=true;
  end;
  close(f);
end;

procedure create_output(s:string);
var id:word;
    t:text;
begin
{  assign(t,s+'.deo');
  rewrite(t);}
  assign(ff,s+'.dat');
  rewrite(ff,1);
  id:=10;
  blockwrite(ff,id,2);
  blockwrite(ff,obj^.num_vertices,2);
  blockwrite(ff,obj^.num_faces,2);
  i:=0;
  tmp_v:=obj^.zac_v;
{  writeln(t,'VERTICES');}
  while tmp_v<>nil do begin
    blockwrite(ff,tmp_v^.x,4);
    blockwrite(ff,tmp_v^.y,4);
    blockwrite(ff,tmp_v^.z,4);
{    writeln(t,'Vertex ',i,'   X: ',tmp_v^.x,' Y: ',tmp_v^.y,' Z: ',tmp_v^.z);
    inc(i);}
    tmp_v:=tmp_v^.next;
  end;
  tmp_v:=obj^.zac_v;
{  writeln(t);
  writeln(t,'VERTEX NORMALS');}
  while tmp_v<>nil do begin
    blockwrite(ff,tmp_v^.nx,4);
    blockwrite(ff,tmp_v^.ny,4);
    blockwrite(ff,tmp_v^.nz,4);
{    writeln(t,'NX: ',tmp_v^.nx,' NY: ',tmp_v^.ny,' NZ: ',tmp_v^.nz);}
    tmp_v:=tmp_v^.next;
  end;
  tmp_f:=obj^.zac_f;
{  writeln(t);
  writeln(t,'FACES');
  i:=0;}
  while tmp_f<>nil do begin
    blockwrite(ff,tmp_f^.a,4);
    blockwrite(ff,tmp_f^.b,4);
    blockwrite(ff,tmp_f^.c,4);
{    writeln(t,'Face',i,'   A: ',tmp_f^.a,' B: ',tmp_f^.b,' C: ',tmp_f^.c);
    inc(i);}
    tmp_f:=tmp_f^.next;
  end;
  tmp_f:=obj^.zac_f;
  {writeln(t);
  writeln(t,'FACE NORMALS');}
  while tmp_f<>nil do begin
    blockwrite(ff,tmp_f^.nx,4);
    blockwrite(ff,tmp_f^.ny,4);
    blockwrite(ff,tmp_f^.nz,4);
   { writeln(t,'NX: ',tmp_f^.nx,' NY: ',tmp_f^.ny,' NZ: ',tmp_f^.nz);}
    tmp_f:=tmp_f^.next;
  end;
  close(ff);
{  close(t);}
end;

begin
  clrscr;
  writeln('3D Studio Object File Converter');
  writeln('Coded by maLi/DarkSiDe - September, 1996');
  writeln('Copyright (c) 1996 by Matjaz Trtnik');
  writeln('E-mail: mtrtnik@info.src.si');
  if paramcount<>2 then begin
    writeln;
    writeln('ERROR: Parameter missing!');
    writeln('USE: asc2dat.exe <file.asc> <normal_size>');
    halt(1);
  end;
  inf:=paramstr(1);
  val(paramstr(2),fixed_point,i);
  writeln;
  writeln('Converting file ',inf);
  writeln('Memory available: ',memavail div 1024 ,' KBytes');
  assign(f,inf);
  {$I+}
  reset(f);
  if ioresult<>0 then begin
    writeln('ERROR: File ',inf,' not found!');
    halt(1);
  end;
  zac_obj:=nil;
  file_3ds:=false;
  last_name:='';
  y:=0;
  while not eof(f) do begin
    inc(y);
    readln(f,s);
    i:=pos('Named object: ',s);
    if i>0 then begin
      readln(f,s1);
      inc(y);
      if pos('Tri-mesh',s1)>0 then begin
        file_3ds:=true;
        {preberi ime objekta}
        name:='';
        inc(i,15);
        while s[i]<>'"' do begin
          name:=name+s[i];
          inc(i);
        end;
        {ce sta imena objektov razlicna naredi nov objekt}
        if last_name<>name then begin
          {se ni nobenih objektov... inicializiramo prvega}
          if zac_obj=nil then begin
            new(zac_obj);
            zac_obj^.name:=name;
            zac_obj^.ypos:=y;
            zac_obj^.next:=nil;
            zac_obj^.vertex:=nil;
            zac_obj^.face:=nil;
            zac_obj^.zac_v:=nil;
            zac_obj^.zac_f:=nil;
            zac_obj^.normals:=false;
            obj:=zac_obj;
            objektov:=1;
          end
          {seznam je ze narjen.. samo dodaj}
          else begin
            new(tobj);
            tobj^.next:=nil;
            tobj^.vertex:=nil;
            tobj^.face:=nil;
            tobj^.zac_v:=nil;
            tobj^.zac_f:=nil;
            tobj^.name:=name;
            tobj^.ypos:=y;
            tobj^.normals:=false;
            obj^.next:=tobj;
            obj:=tobj;
            inc(objektov);
          end;
        end;
        last_name:=obj^.name;
      end;
    end;
  end;
  close(f);
  if file_3ds=false then begin
    writeln('File ',inf,' may not be correct .asc file or some data are missing');
    halt(1);
  end;
  {prebere stevilo tock in stevilo trikotnikov}
  obj:=zac_obj;
  while obj<>nil do begin
    assign(f,inf);
    reset(f);
    for l:=1 to obj^.ypos do readln(f,s);
    close(f);
    i:=1;
    s1:='';
    while (s[i]<>':') do inc(i);
    inc(i,2);
    while (s[i]>='0') and (s[i]<='9')  and (i<=ord(s[0])) do begin
      s1:=s1+s[i];
      inc(i);
    end;
    val(s1,obj^.num_vertices,l);
    s1:='';
    while (s[i]<>':') do inc(i);
    inc(i,2);
    while (s[i]>='0') and (s[i]<='9') and (i<=ord(s[0])) do begin
      s1:=s1+s[i];
      inc(i);
    end;
    val(s1,obj^.num_faces,l);
    obj:=obj^.next;
  end;
  obj:=zac_obj;
  writeln;
  write('--------------------------------------------------------------------------------');
  write('| Object name       | Number of vertices | Number of faces   | Create normals  |');
  write('|-------------------|--------------------|-------------------|-----------------|');
  while obj<>nil do begin
    write('| ');
    write(obj^.name);
    for i:=1 to 18-length(obj^.name) do write(' ');
    write('| ');
    write(obj^.num_vertices);
    str(obj^.num_vertices,s);
    for i:=1 to 19-length(s) do write(' ');
    write('| ');
    write(obj^.num_faces);
    str(obj^.num_faces,s);
    for i:=1 to 18-length(s) do write(' ');
    if obj^.normals then write('| YES             |')
    else write('| NO              |');
    obj:=obj^.next;
  end;
  write('--------------------------------------------------------------------------------');
  writeln;
  write('Enter object name you want to convert: ');
  readln(name);
  write('Create normals? (Y/N) ');
  repeat
    ch:=upcase(readkey);
  until (ch='Y') or (ch='N');
  writeln(ch);
  obj:=zac_obj;
  obstaja:=false;
  {preveri ali objekt sploh obstaja}
  while obj<>nil do begin
    if name=obj^.name then begin
      obstaja:=true;
      if ch='Y' then obj^.normals:=true;
    end;
    obj:=obj^.next;
  end;
  if obstaja then begin
    writeln;
    write('Reading vertices and faces...');
    create_object(name);
    writeln(' done');
    if obj^.normals then begin
      write('Calculating normals...');
      create_normals;
      writeln(' done');
    end;
    delete(inf,length(inf)-3,4);
    write('Creating file ',inf,'.dat...');
    create_output(inf);
    writeln(' done');
  end
  else begin
    writeln('ERROR: Object with name "',name,'" not found!');
    halt(1);
  end;
  {dealocira pomnilnik}
  obj:=zac_obj;
  while obj<>nil do begin
    if obj^.vertex<>nil then begin
      tmp_v:=obj^.vertex;
      while tmp_v<>nil do begin
        tmpv:=tmp_v;
        dispose(tmpv);
        tmp_v:=tmp_v^.next;
      end;
    end;
    if obj^.face<>nil then begin
      tmp_f:=obj^.face;
      while tmp_f<>nil do begin
        tmpf:=tmp_f;
        dispose(tmpf);
        tmp_f:=tmp_f^.next;
      end;
    end;
    tobj:=obj;
    dispose(tobj);
    obj:=obj^.next;
  end;
end.