#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>

#include "poly.h"
#include "rotate.h"


struct Object3D {
  short x,y,z,
	xAngle,yAngle,zAngle;

  unsigned short numVertex,numPoly;
  StaticVertex *originalVertex;
  Vertex *vertexList;
  Polygon *polyList;
};


StaticVertex initCubeV[8] = {
  {-50,50,50},  {50,50,50},
  {50,-50,50},  {-50,-50,50},
  {-50,50,-50}, {50,50,-50},
  {50,-50,-50}, {-50,-50,-50}
};

Vertex cubeV[8];


Polygon cubePoly[6] = {
  {4,1,1, {&cubeV[0],&cubeV[1],&cubeV[2],&cubeV[3]}},//the rear face
  {4,2,1, {&cubeV[0],&cubeV[3],&cubeV[7],&cubeV[4]}}, //left face
  {4,3,1, {&cubeV[0],&cubeV[4],&cubeV[5],&cubeV[1]}},//top face
  {4,4,1, {&cubeV[6],&cubeV[5],&cubeV[4],&cubeV[7]}}, //the front face
  {4,5,1, {&cubeV[6],&cubeV[2],&cubeV[1],&cubeV[5]}}, //right face
  {4,9,1, {&cubeV[6],&cubeV[7],&cubeV[3],&cubeV[2]}},//bottom face
};


Object3D cube={
  0,0,200,      //the z,y,z
  0,0,0,        //the angles of rotation
  8,            //8 vertices in a cube shape
  6,            //6 polygons (faces) on a cube
  initCubeV,    //the original vertices for the cube
  cubeV,        //the space to store the rotated/transformed vertices
  cubePoly      //the list of polygons to use
};


char far *screen=(char far*)MK_FP(0xA000,0x0000);
char far *scrn_buffer=0;


void main(void) {

//get mem for a screen buffer to avoid flicker.
  scrn_buffer=new char [320*200];
  if(!scrn_buffer) {
    printf("Could not allocate memory for screen buffer\n");
    exit(0);
  }
  //set the screen to be black at start to avoid trash being copied to
  //the screen on first frame
  _fmemset(scrn_buffer,0,320*200);

//set 320x200x256 mode
  asm {
    mov ax,13h
    int 10h
  }

//loop till key strike
  while(!kbhit()) {

//rotate the 8 cube vertices
    for(int i=0;i<cube.numVertex;i++) {
      rotateVertex(&cube.originalVertex[i],&cube.vertexList[i],
		   cube.xAngle,cube.yAngle,cube.zAngle);

      cube.vertexList[i].x+=cube.x;
      cube.vertexList[i].y+=cube.y;
      cube.vertexList[i].z+=cube.z;

      screenConvertVertex(&cube.vertexList[i]);
    }

    for(i=0;i<cube.numPoly;i++)
      if(!backfacing(&cube.polyList[i]))
	drawPolygon(&cube.polyList[i],scrn_buffer);

    cube.xAngle++;
    cube.yAngle++;
    cube.zAngle++;

    _fmemcpy(screen,scrn_buffer,320*200);
    _fmemset(scrn_buffer,0,320*200);

  }

  getch();

  asm {
    mov ax,03h
    int 10h
  }
}







