.\" Copyright Equivalent Software HB   1992
.\" This program and documentation may be distributed freely under
.\" the terms of GNU GENERAL PUBLIC LICENSE.
.TH PRIMITIVES 3X "December , 1990" 3X
.SH NAME
primitives - a collection of object primitives for SIPP.
.SH SYNOPSIS
\fI#include <primitives.h>\fR
.sp
[g]cc [\fIflags\fR] \fIfiles\fR -lsipp -lm [ \fIlibraries\fR ]

.SH DESCRIPTION
SIPP gives the user access to a number of rather low level functions
to create polygons, surfaces and objects. This manual describes a set of
functions that use the low level functions in SIPP to create
geometric primitives. Each primitive is a complete SIPP object.
.sp
Each object primitive has a last argument that describes what kind of texture
coordinates should be assigned to the surface of the object. This texture
parameter should be one of: \fINATURAL\fR, \fICYLINDRICAL\fR, \fISPHERICAL\fR
or \fIWORD\fR. See the user manual for a detailed description of the meaning
of the different values.

.SH PRIMITIVES
.IP \fIObject\ *sipp_torus(bigradius,\ smallradius,\ res1,\ res2,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  bigradius;\fR
.br
\fIdouble\  smallradius;\fR
.br
\fIint\     res1;\fR
.br
\fIint\     res2;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_torus()\fR creates a torus centered about the origin and with the
z-axis pointing up through the ring. \fINATURAL\fR texture mapping is a two
dimensional mapping with the \fIx\fR coordinate going around the "small"
circle and the \fIy\fR coordinate going around the "large" circle.

.IP \fIObject\ *sipp_cone(bot_rad,\ ,top_rad,\ length,\ resolution,\ surface,\
shader,\ texture)\fR
.br
\fIdouble\  bot_rad;\fR
.br
\fIdouble\  top_rad;\fR
.br
\fIdouble\  length;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_cone()\fR creates a, possibly truncated, cone centered about the
origin and with the z-axis along the cones main axis. \fINATURAL\fR texture
mapping is \fICYLINDRICAL\fR.

.IP \fIObject\ *sipp_cylinder(radius,\ length,\ resolution,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  radius;\fR
.br
\fIdouble\  length;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_cylinder()\fR creates a cylinder centered about the origin and with
the z-axis along the cylinders main axis. \fINATURAL\fR texture mapping is
\fICYLINDRICAL\fR.

.IP \fIObject\ *sipp_ellipsoid(x_rad,\ y_rad,\ z_rad,\ resolution,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  x_rad;\fR
.br
\fIdouble\  y_rad;\fR
.br
\fIdouble\  z_rad;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_ellipsoid()\fR creates a ellipsoid centered about the origin.
\fINATURAL\fR texture mapping is \fISPHERICAL\fR.

.IP \fIObject\ *sipp_sphere(radius,\ resolution,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  radius;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_sphere()\fR creates a sphere centered about the origin.
\fINATURAL\fR texture mapping is \fISPHERICAL\fR.

.IP \fIObject\ *sipp_prism(num_points,\ points,\ length,\ surface,\ shader,\ texture)\fR
.br
\fIint\     num_points;\fR
.br
\fIVector\ *points;\fR
.br
\fIdouble\  length;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_prism()\fR creates a prism defined by the polygon in \fIpoints\fR.
Only the x and y values are used and the prism will ascend and descend equally
far (\fIlength\fR / 2.0) from the x-y plane along the z axis. \fINATURAL\fR
texture mapping is similar to \fICYLINDRICAL\fR but the \fIx\fR coordinate
is not taken from projection on a cylinder but is evenly distributed around
the perimeter. An odd thing in all the 2D mappings for the prism is that the
top face will have texture coordinates (0.0, 1.0) while the bottom will get
(0.0, 0.0).

.IP \fIObject\ *sipp_block(x_size,\ y_size,\ z_size,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  x_size;\fR
.br
\fIdouble\  y_size;\fR
.br
\fIdouble\  z_size;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_block()\fR creates a rectangular block with the size defined by
\fIx_size\fR, \fIz_size\fR and \fIz_size\fR. The block is centered about the
origin. \fINATURAL\fR texture mapping is similar to \fICYLINDRICAL\fR but
the \fIx\fR coordinate is not taken from projection on a cylinder but is
evenly distributed around the perimeter. An odd thing in all the 2D mappings
for the block is that the top face will have texture
coordinates (0.0, 1.0) while the bottom will get (0.0, 0.0).


.IP \fIObject\ *sipp_cube(side,\ surface,\ shader,\ texture)\fR
.br
\fIdouble\  side;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_cube()\fR creates a cube with the side of length \fIside\fR.  The cube
is centered about the origin. \fINATURAL\fR texture mapping is similar to
\fICYLINDRICAL\fR but the \fIx\fR coordinate is not taken from projection on
a cylinder but is evenly distributed around the perimeter. An odd thing in all
the 2D mappings for the cube is that the top face
will have texture coordinates (0.0, 1.0) while the bottom will get (0.0, 0.0).

.IP \fIObject\ *sipp_bezier_patch(num_vertex,\ vertex,\ num_patch,\ vx_index,\ res,\ surface,\ shader,\ texture)\fR
.br
\fIint\     num_vertex;\fR
.br
\fIVector\  vertex[];\fR
.br
\fIint\     num_patch;\fR
.br
\fIint\     vx_index[];\fR
.br
\fIint\     res;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
This function creates one or more bezier patches. All created patches in a
call will belong to the same surface.  The texture coordinates are a bit
special for the bezier patches.  \fICYLINDRICAL\fR and \fISPHERICAL\fR
coordinates are not applicable, if they are specified, SIPP will use
\fINATURAL\fR anyway. The \fINATURAL\fR mapping is a two dimensional mapping
using the surface parameters \fIu\fR and \fIv\fR. Note that
these parameters range from 0 to 1 within each patch!

.IP \fIObject\ *sipp_bezier_rotcurve(num_vertex,\ vertex,\ num_curve,\ vx_index,\ res,\ surface,\ shader,\ texture)\fR
.br
\fIint\     num_vertex;\fR
.br
\fIVector\  vertex[];\fR
.br
\fIint\     num_curve;\fR
.br
\fIint\     vx_index[];\fR
.br
\fIint\     res;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
This function creates a surface by rotating one or more bezier curves about
the world z-axis.  The texture coordinates are a bit special for these
surfaces.  \fISPHERICAL\fR and \fICYLINDRICAL\fR mappings are not
applicable, and \fINATURAL\fR mapping will apply to the peace of surface
created by each bezier curve separately. The \fINATURAL\fR mapping uses the
curve parameter \fIu\fR along each curve as \fIx\fR coordinate and goes from 0
to 1 around the perimeter of the rotational surface on the other axis


.IP \fIObject\ *sipp_bezier_file(file,\ res,\ surface,\ shader,\ texture)\fR
.br
\fIFILE\   *file;\fR
.br
\fIint\     res;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.br
\fIint\     texture;\fR
.sp
\fIsipp_bezier_file()\fR reads a file containing descriptions of a set of
bezier patches or bezier curves. See the user manual for a detailed
description of the format of the definition file. Texture coordinates are
assigned in the same way as in \fIsipp_bezier_patch()\fR and
\fIsipp_bezier_rotcurve()\fR.

.SH SEE ALSO
sipp(3X) - simple polygon processor, a 3d-graphics library
.br
shaders(3X) - a collection of shaders for SIPP.
.br
geometric(3X) - Vector and matrix functions for SIPP.
.br
sipp_pixmap(3X) - pixmap handling code for SIPP.
.br
sipp_bitmap(3X) - bitmap handling code for SIPP.

.SH AUTHORS
Jonas Yngvesson\	\	(jonas-y@isy.liu.se)
.br
Inge Wallin\		(ingwa@isy.liu.se)

.SH BUGS
The format for the bezier patches and curves is prohibitively ugly.
